<?php

namespace NineDotMedia\viapost-php\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FindNearestQueryAddress Struct
 * @subpackage Structs
 */
class FindNearestQueryAddress extends AbstractStructBase
{
    /**
     * The numberOfAddressesToSearch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $numberOfAddressesToSearch;
    /**
     * The radiusOfAreaToSearchInMetres
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $radiusOfAreaToSearchInMetres;
    /**
     * The includeThisAddressInResults
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $includeThisAddressInResults;
    /**
     * The onlyAddressesInThisStreet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $onlyAddressesInThisStreet;
    /**
     * The addressTypes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $addressTypes;
    /**
     * The numberAddressesInResults
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $numberAddressesInResults;
    /**
     * The costOfSearch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $costOfSearch;
    /**
     * The loginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginToken;
    /**
     * The houseNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $houseNumber;
    /**
     * The houseName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $houseName;
    /**
     * The organisation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $organisation;
    /**
     * The postCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $postCode;
    /**
     * The foundOrganisation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $foundOrganisation;
    /**
     * The foundBuildingName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $foundBuildingName;
    /**
     * The foundBuildingNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $foundBuildingNumber;
    /**
     * The foundSubBuildingName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $foundSubBuildingName;
    /**
     * The foundThoroughfare
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $foundThoroughfare;
    /**
     * The foundLocality
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $foundLocality;
    /**
     * The foundPostTown
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $foundPostTown;
    /**
     * The foundPostCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $foundPostCode;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for FindNearestQueryAddress
     * @uses FindNearestQueryAddress::setNumberOfAddressesToSearch()
     * @uses FindNearestQueryAddress::setRadiusOfAreaToSearchInMetres()
     * @uses FindNearestQueryAddress::setIncludeThisAddressInResults()
     * @uses FindNearestQueryAddress::setOnlyAddressesInThisStreet()
     * @uses FindNearestQueryAddress::setAddressTypes()
     * @uses FindNearestQueryAddress::setNumberAddressesInResults()
     * @uses FindNearestQueryAddress::setCostOfSearch()
     * @uses FindNearestQueryAddress::setLoginToken()
     * @uses FindNearestQueryAddress::setHouseNumber()
     * @uses FindNearestQueryAddress::setHouseName()
     * @uses FindNearestQueryAddress::setOrganisation()
     * @uses FindNearestQueryAddress::setPostCode()
     * @uses FindNearestQueryAddress::setFoundOrganisation()
     * @uses FindNearestQueryAddress::setFoundBuildingName()
     * @uses FindNearestQueryAddress::setFoundBuildingNumber()
     * @uses FindNearestQueryAddress::setFoundSubBuildingName()
     * @uses FindNearestQueryAddress::setFoundThoroughfare()
     * @uses FindNearestQueryAddress::setFoundLocality()
     * @uses FindNearestQueryAddress::setFoundPostTown()
     * @uses FindNearestQueryAddress::setFoundPostCode()
     * @uses FindNearestQueryAddress::setReturnMessage()
     * @param int $numberOfAddressesToSearch
     * @param int $radiusOfAreaToSearchInMetres
     * @param bool $includeThisAddressInResults
     * @param bool $onlyAddressesInThisStreet
     * @param string $addressTypes
     * @param int $numberAddressesInResults
     * @param float $costOfSearch
     * @param string $loginToken
     * @param string $houseNumber
     * @param string $houseName
     * @param string $organisation
     * @param string $postCode
     * @param string $foundOrganisation
     * @param string $foundBuildingName
     * @param string $foundBuildingNumber
     * @param string $foundSubBuildingName
     * @param string $foundThoroughfare
     * @param string $foundLocality
     * @param string $foundPostTown
     * @param string $foundPostCode
     * @param string $returnMessage
     */
    public function __construct($numberOfAddressesToSearch = null, $radiusOfAreaToSearchInMetres = null, $includeThisAddressInResults = null, $onlyAddressesInThisStreet = null, $addressTypes = null, $numberAddressesInResults = null, $costOfSearch = null, $loginToken = null, $houseNumber = null, $houseName = null, $organisation = null, $postCode = null, $foundOrganisation = null, $foundBuildingName = null, $foundBuildingNumber = null, $foundSubBuildingName = null, $foundThoroughfare = null, $foundLocality = null, $foundPostTown = null, $foundPostCode = null, $returnMessage = null)
    {
        $this
            ->setNumberOfAddressesToSearch($numberOfAddressesToSearch)
            ->setRadiusOfAreaToSearchInMetres($radiusOfAreaToSearchInMetres)
            ->setIncludeThisAddressInResults($includeThisAddressInResults)
            ->setOnlyAddressesInThisStreet($onlyAddressesInThisStreet)
            ->setAddressTypes($addressTypes)
            ->setNumberAddressesInResults($numberAddressesInResults)
            ->setCostOfSearch($costOfSearch)
            ->setLoginToken($loginToken)
            ->setHouseNumber($houseNumber)
            ->setHouseName($houseName)
            ->setOrganisation($organisation)
            ->setPostCode($postCode)
            ->setFoundOrganisation($foundOrganisation)
            ->setFoundBuildingName($foundBuildingName)
            ->setFoundBuildingNumber($foundBuildingNumber)
            ->setFoundSubBuildingName($foundSubBuildingName)
            ->setFoundThoroughfare($foundThoroughfare)
            ->setFoundLocality($foundLocality)
            ->setFoundPostTown($foundPostTown)
            ->setFoundPostCode($foundPostCode)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get numberOfAddressesToSearch value
     * @return int
     */
    public function getNumberOfAddressesToSearch()
    {
        return $this->numberOfAddressesToSearch;
    }
    /**
     * Set numberOfAddressesToSearch value
     * @param int $numberOfAddressesToSearch
     * @return \NineDotMedia\viapost-php\Struct\FindNearestQueryAddress
     */
    public function setNumberOfAddressesToSearch($numberOfAddressesToSearch = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfAddressesToSearch) && !(is_int($numberOfAddressesToSearch) || ctype_digit($numberOfAddressesToSearch))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfAddressesToSearch, true), gettype($numberOfAddressesToSearch)), __LINE__);
        }
        $this->numberOfAddressesToSearch = $numberOfAddressesToSearch;
        return $this;
    }
    /**
     * Get radiusOfAreaToSearchInMetres value
     * @return int
     */
    public function getRadiusOfAreaToSearchInMetres()
    {
        return $this->radiusOfAreaToSearchInMetres;
    }
    /**
     * Set radiusOfAreaToSearchInMetres value
     * @param int $radiusOfAreaToSearchInMetres
     * @return \NineDotMedia\viapost-php\Struct\FindNearestQueryAddress
     */
    public function setRadiusOfAreaToSearchInMetres($radiusOfAreaToSearchInMetres = null)
    {
        // validation for constraint: int
        if (!is_null($radiusOfAreaToSearchInMetres) && !(is_int($radiusOfAreaToSearchInMetres) || ctype_digit($radiusOfAreaToSearchInMetres))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($radiusOfAreaToSearchInMetres, true), gettype($radiusOfAreaToSearchInMetres)), __LINE__);
        }
        $this->radiusOfAreaToSearchInMetres = $radiusOfAreaToSearchInMetres;
        return $this;
    }
    /**
     * Get includeThisAddressInResults value
     * @return bool
     */
    public function getIncludeThisAddressInResults()
    {
        return $this->includeThisAddressInResults;
    }
    /**
     * Set includeThisAddressInResults value
     * @param bool $includeThisAddressInResults
     * @return \NineDotMedia\viapost-php\Struct\FindNearestQueryAddress
     */
    public function setIncludeThisAddressInResults($includeThisAddressInResults = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeThisAddressInResults) && !is_bool($includeThisAddressInResults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeThisAddressInResults, true), gettype($includeThisAddressInResults)), __LINE__);
        }
        $this->includeThisAddressInResults = $includeThisAddressInResults;
        return $this;
    }
    /**
     * Get onlyAddressesInThisStreet value
     * @return bool
     */
    public function getOnlyAddressesInThisStreet()
    {
        return $this->onlyAddressesInThisStreet;
    }
    /**
     * Set onlyAddressesInThisStreet value
     * @param bool $onlyAddressesInThisStreet
     * @return \NineDotMedia\viapost-php\Struct\FindNearestQueryAddress
     */
    public function setOnlyAddressesInThisStreet($onlyAddressesInThisStreet = null)
    {
        // validation for constraint: boolean
        if (!is_null($onlyAddressesInThisStreet) && !is_bool($onlyAddressesInThisStreet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onlyAddressesInThisStreet, true), gettype($onlyAddressesInThisStreet)), __LINE__);
        }
        $this->onlyAddressesInThisStreet = $onlyAddressesInThisStreet;
        return $this;
    }
    /**
     * Get addressTypes value
     * @return string
     */
    public function getAddressTypes()
    {
        return $this->addressTypes;
    }
    /**
     * Set addressTypes value
     * @uses \NineDotMedia\viapost-php\Enum\FindNearestAddressTypes::valueIsValid()
     * @uses \NineDotMedia\viapost-php\Enum\FindNearestAddressTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $addressTypes
     * @return \NineDotMedia\viapost-php\Struct\FindNearestQueryAddress
     */
    public function setAddressTypes($addressTypes = null)
    {
        // validation for constraint: enumeration
        if (!\NineDotMedia\viapost-php\Enum\FindNearestAddressTypes::valueIsValid($addressTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \NineDotMedia\viapost-php\Enum\FindNearestAddressTypes', is_array($addressTypes) ? implode(', ', $addressTypes) : var_export($addressTypes, true), implode(', ', \NineDotMedia\viapost-php\Enum\FindNearestAddressTypes::getValidValues())), __LINE__);
        }
        $this->addressTypes = $addressTypes;
        return $this;
    }
    /**
     * Get numberAddressesInResults value
     * @return int
     */
    public function getNumberAddressesInResults()
    {
        return $this->numberAddressesInResults;
    }
    /**
     * Set numberAddressesInResults value
     * @param int $numberAddressesInResults
     * @return \NineDotMedia\viapost-php\Struct\FindNearestQueryAddress
     */
    public function setNumberAddressesInResults($numberAddressesInResults = null)
    {
        // validation for constraint: int
        if (!is_null($numberAddressesInResults) && !(is_int($numberAddressesInResults) || ctype_digit($numberAddressesInResults))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberAddressesInResults, true), gettype($numberAddressesInResults)), __LINE__);
        }
        $this->numberAddressesInResults = $numberAddressesInResults;
        return $this;
    }
    /**
     * Get costOfSearch value
     * @return float
     */
    public function getCostOfSearch()
    {
        return $this->costOfSearch;
    }
    /**
     * Set costOfSearch value
     * @param float $costOfSearch
     * @return \NineDotMedia\viapost-php\Struct\FindNearestQueryAddress
     */
    public function setCostOfSearch($costOfSearch = null)
    {
        // validation for constraint: float
        if (!is_null($costOfSearch) && !(is_float($costOfSearch) || is_numeric($costOfSearch))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($costOfSearch, true), gettype($costOfSearch)), __LINE__);
        }
        $this->costOfSearch = $costOfSearch;
        return $this;
    }
    /**
     * Get loginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->loginToken;
    }
    /**
     * Set loginToken value
     * @param string $loginToken
     * @return \NineDotMedia\viapost-php\Struct\FindNearestQueryAddress
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->loginToken = $loginToken;
        return $this;
    }
    /**
     * Get houseNumber value
     * @return string|null
     */
    public function getHouseNumber()
    {
        return $this->houseNumber;
    }
    /**
     * Set houseNumber value
     * @param string $houseNumber
     * @return \NineDotMedia\viapost-php\Struct\FindNearestQueryAddress
     */
    public function setHouseNumber($houseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($houseNumber) && !is_string($houseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($houseNumber, true), gettype($houseNumber)), __LINE__);
        }
        $this->houseNumber = $houseNumber;
        return $this;
    }
    /**
     * Get houseName value
     * @return string|null
     */
    public function getHouseName()
    {
        return $this->houseName;
    }
    /**
     * Set houseName value
     * @param string $houseName
     * @return \NineDotMedia\viapost-php\Struct\FindNearestQueryAddress
     */
    public function setHouseName($houseName = null)
    {
        // validation for constraint: string
        if (!is_null($houseName) && !is_string($houseName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($houseName, true), gettype($houseName)), __LINE__);
        }
        $this->houseName = $houseName;
        return $this;
    }
    /**
     * Get organisation value
     * @return string|null
     */
    public function getOrganisation()
    {
        return $this->organisation;
    }
    /**
     * Set organisation value
     * @param string $organisation
     * @return \NineDotMedia\viapost-php\Struct\FindNearestQueryAddress
     */
    public function setOrganisation($organisation = null)
    {
        // validation for constraint: string
        if (!is_null($organisation) && !is_string($organisation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organisation, true), gettype($organisation)), __LINE__);
        }
        $this->organisation = $organisation;
        return $this;
    }
    /**
     * Get postCode value
     * @return string|null
     */
    public function getPostCode()
    {
        return $this->postCode;
    }
    /**
     * Set postCode value
     * @param string $postCode
     * @return \NineDotMedia\viapost-php\Struct\FindNearestQueryAddress
     */
    public function setPostCode($postCode = null)
    {
        // validation for constraint: string
        if (!is_null($postCode) && !is_string($postCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postCode, true), gettype($postCode)), __LINE__);
        }
        $this->postCode = $postCode;
        return $this;
    }
    /**
     * Get foundOrganisation value
     * @return string|null
     */
    public function getFoundOrganisation()
    {
        return $this->foundOrganisation;
    }
    /**
     * Set foundOrganisation value
     * @param string $foundOrganisation
     * @return \NineDotMedia\viapost-php\Struct\FindNearestQueryAddress
     */
    public function setFoundOrganisation($foundOrganisation = null)
    {
        // validation for constraint: string
        if (!is_null($foundOrganisation) && !is_string($foundOrganisation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($foundOrganisation, true), gettype($foundOrganisation)), __LINE__);
        }
        $this->foundOrganisation = $foundOrganisation;
        return $this;
    }
    /**
     * Get foundBuildingName value
     * @return string|null
     */
    public function getFoundBuildingName()
    {
        return $this->foundBuildingName;
    }
    /**
     * Set foundBuildingName value
     * @param string $foundBuildingName
     * @return \NineDotMedia\viapost-php\Struct\FindNearestQueryAddress
     */
    public function setFoundBuildingName($foundBuildingName = null)
    {
        // validation for constraint: string
        if (!is_null($foundBuildingName) && !is_string($foundBuildingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($foundBuildingName, true), gettype($foundBuildingName)), __LINE__);
        }
        $this->foundBuildingName = $foundBuildingName;
        return $this;
    }
    /**
     * Get foundBuildingNumber value
     * @return string|null
     */
    public function getFoundBuildingNumber()
    {
        return $this->foundBuildingNumber;
    }
    /**
     * Set foundBuildingNumber value
     * @param string $foundBuildingNumber
     * @return \NineDotMedia\viapost-php\Struct\FindNearestQueryAddress
     */
    public function setFoundBuildingNumber($foundBuildingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($foundBuildingNumber) && !is_string($foundBuildingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($foundBuildingNumber, true), gettype($foundBuildingNumber)), __LINE__);
        }
        $this->foundBuildingNumber = $foundBuildingNumber;
        return $this;
    }
    /**
     * Get foundSubBuildingName value
     * @return string|null
     */
    public function getFoundSubBuildingName()
    {
        return $this->foundSubBuildingName;
    }
    /**
     * Set foundSubBuildingName value
     * @param string $foundSubBuildingName
     * @return \NineDotMedia\viapost-php\Struct\FindNearestQueryAddress
     */
    public function setFoundSubBuildingName($foundSubBuildingName = null)
    {
        // validation for constraint: string
        if (!is_null($foundSubBuildingName) && !is_string($foundSubBuildingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($foundSubBuildingName, true), gettype($foundSubBuildingName)), __LINE__);
        }
        $this->foundSubBuildingName = $foundSubBuildingName;
        return $this;
    }
    /**
     * Get foundThoroughfare value
     * @return string|null
     */
    public function getFoundThoroughfare()
    {
        return $this->foundThoroughfare;
    }
    /**
     * Set foundThoroughfare value
     * @param string $foundThoroughfare
     * @return \NineDotMedia\viapost-php\Struct\FindNearestQueryAddress
     */
    public function setFoundThoroughfare($foundThoroughfare = null)
    {
        // validation for constraint: string
        if (!is_null($foundThoroughfare) && !is_string($foundThoroughfare)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($foundThoroughfare, true), gettype($foundThoroughfare)), __LINE__);
        }
        $this->foundThoroughfare = $foundThoroughfare;
        return $this;
    }
    /**
     * Get foundLocality value
     * @return string|null
     */
    public function getFoundLocality()
    {
        return $this->foundLocality;
    }
    /**
     * Set foundLocality value
     * @param string $foundLocality
     * @return \NineDotMedia\viapost-php\Struct\FindNearestQueryAddress
     */
    public function setFoundLocality($foundLocality = null)
    {
        // validation for constraint: string
        if (!is_null($foundLocality) && !is_string($foundLocality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($foundLocality, true), gettype($foundLocality)), __LINE__);
        }
        $this->foundLocality = $foundLocality;
        return $this;
    }
    /**
     * Get foundPostTown value
     * @return string|null
     */
    public function getFoundPostTown()
    {
        return $this->foundPostTown;
    }
    /**
     * Set foundPostTown value
     * @param string $foundPostTown
     * @return \NineDotMedia\viapost-php\Struct\FindNearestQueryAddress
     */
    public function setFoundPostTown($foundPostTown = null)
    {
        // validation for constraint: string
        if (!is_null($foundPostTown) && !is_string($foundPostTown)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($foundPostTown, true), gettype($foundPostTown)), __LINE__);
        }
        $this->foundPostTown = $foundPostTown;
        return $this;
    }
    /**
     * Get foundPostCode value
     * @return string|null
     */
    public function getFoundPostCode()
    {
        return $this->foundPostCode;
    }
    /**
     * Set foundPostCode value
     * @param string $foundPostCode
     * @return \NineDotMedia\viapost-php\Struct\FindNearestQueryAddress
     */
    public function setFoundPostCode($foundPostCode = null)
    {
        // validation for constraint: string
        if (!is_null($foundPostCode) && !is_string($foundPostCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($foundPostCode, true), gettype($foundPostCode)), __LINE__);
        }
        $this->foundPostCode = $foundPostCode;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \NineDotMedia\viapost-php\Struct\FindNearestQueryAddress
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
