<?php

namespace NineDotMedia\viapost-php\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerAPILetter Struct
 * @subpackage Structs
 */
class CustomerAPILetter extends AbstractStructBase
{
    /**
     * The NumberOfPages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfPages;
    /**
     * The DateUploaded
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateUploaded;
    /**
     * The LetterID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LetterID;
    /**
     * The LetterFileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LetterFileName;
    /**
     * Constructor method for CustomerAPILetter
     * @uses CustomerAPILetter::setNumberOfPages()
     * @uses CustomerAPILetter::setDateUploaded()
     * @uses CustomerAPILetter::setLetterID()
     * @uses CustomerAPILetter::setLetterFileName()
     * @param int $numberOfPages
     * @param string $dateUploaded
     * @param string $letterID
     * @param string $letterFileName
     */
    public function __construct($numberOfPages = null, $dateUploaded = null, $letterID = null, $letterFileName = null)
    {
        $this
            ->setNumberOfPages($numberOfPages)
            ->setDateUploaded($dateUploaded)
            ->setLetterID($letterID)
            ->setLetterFileName($letterFileName);
    }
    /**
     * Get NumberOfPages value
     * @return int
     */
    public function getNumberOfPages()
    {
        return $this->NumberOfPages;
    }
    /**
     * Set NumberOfPages value
     * @param int $numberOfPages
     * @return \NineDotMedia\viapost-php\Struct\CustomerAPILetter
     */
    public function setNumberOfPages($numberOfPages = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfPages) && !(is_int($numberOfPages) || ctype_digit($numberOfPages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfPages, true), gettype($numberOfPages)), __LINE__);
        }
        $this->NumberOfPages = $numberOfPages;
        return $this;
    }
    /**
     * Get DateUploaded value
     * @return string
     */
    public function getDateUploaded()
    {
        return $this->DateUploaded;
    }
    /**
     * Set DateUploaded value
     * @param string $dateUploaded
     * @return \NineDotMedia\viapost-php\Struct\CustomerAPILetter
     */
    public function setDateUploaded($dateUploaded = null)
    {
        // validation for constraint: string
        if (!is_null($dateUploaded) && !is_string($dateUploaded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateUploaded, true), gettype($dateUploaded)), __LINE__);
        }
        $this->DateUploaded = $dateUploaded;
        return $this;
    }
    /**
     * Get LetterID value
     * @return string|null
     */
    public function getLetterID()
    {
        return $this->LetterID;
    }
    /**
     * Set LetterID value
     * @param string $letterID
     * @return \NineDotMedia\viapost-php\Struct\CustomerAPILetter
     */
    public function setLetterID($letterID = null)
    {
        // validation for constraint: string
        if (!is_null($letterID) && !is_string($letterID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($letterID, true), gettype($letterID)), __LINE__);
        }
        $this->LetterID = $letterID;
        return $this;
    }
    /**
     * Get LetterFileName value
     * @return string|null
     */
    public function getLetterFileName()
    {
        return $this->LetterFileName;
    }
    /**
     * Set LetterFileName value
     * @param string $letterFileName
     * @return \NineDotMedia\viapost-php\Struct\CustomerAPILetter
     */
    public function setLetterFileName($letterFileName = null)
    {
        // validation for constraint: string
        if (!is_null($letterFileName) && !is_string($letterFileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($letterFileName, true), gettype($letterFileName)), __LINE__);
        }
        $this->LetterFileName = $letterFileName;
        return $this;
    }
}
