<?php

namespace NineDotMedia\viapost-php\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreatePostcard Struct
 * @subpackage Structs
 */
class CreatePostcard extends AbstractStructBase
{
    /**
     * The sharePostcardWithGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $sharePostcardWithGroup;
    /**
     * The postcardID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $postcardID;
    /**
     * The loginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginToken;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The fileContentsFront
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $fileContentsFront;
    /**
     * The fileContentsBack
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $fileContentsBack;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for CreatePostcard
     * @uses CreatePostcard::setSharePostcardWithGroup()
     * @uses CreatePostcard::setPostcardID()
     * @uses CreatePostcard::setLoginToken()
     * @uses CreatePostcard::setName()
     * @uses CreatePostcard::setDescription()
     * @uses CreatePostcard::setFileContentsFront()
     * @uses CreatePostcard::setFileContentsBack()
     * @uses CreatePostcard::setReturnMessage()
     * @param bool $sharePostcardWithGroup
     * @param int $postcardID
     * @param string $loginToken
     * @param string $name
     * @param string $description
     * @param string $fileContentsFront
     * @param string $fileContentsBack
     * @param string $returnMessage
     */
    public function __construct($sharePostcardWithGroup = null, $postcardID = null, $loginToken = null, $name = null, $description = null, $fileContentsFront = null, $fileContentsBack = null, $returnMessage = null)
    {
        $this
            ->setSharePostcardWithGroup($sharePostcardWithGroup)
            ->setPostcardID($postcardID)
            ->setLoginToken($loginToken)
            ->setName($name)
            ->setDescription($description)
            ->setFileContentsFront($fileContentsFront)
            ->setFileContentsBack($fileContentsBack)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get sharePostcardWithGroup value
     * @return bool
     */
    public function getSharePostcardWithGroup()
    {
        return $this->sharePostcardWithGroup;
    }
    /**
     * Set sharePostcardWithGroup value
     * @param bool $sharePostcardWithGroup
     * @return \NineDotMedia\viapost-php\Struct\CreatePostcard
     */
    public function setSharePostcardWithGroup($sharePostcardWithGroup = null)
    {
        // validation for constraint: boolean
        if (!is_null($sharePostcardWithGroup) && !is_bool($sharePostcardWithGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sharePostcardWithGroup, true), gettype($sharePostcardWithGroup)), __LINE__);
        }
        $this->sharePostcardWithGroup = $sharePostcardWithGroup;
        return $this;
    }
    /**
     * Get postcardID value
     * @return int
     */
    public function getPostcardID()
    {
        return $this->postcardID;
    }
    /**
     * Set postcardID value
     * @param int $postcardID
     * @return \NineDotMedia\viapost-php\Struct\CreatePostcard
     */
    public function setPostcardID($postcardID = null)
    {
        // validation for constraint: int
        if (!is_null($postcardID) && !(is_int($postcardID) || ctype_digit($postcardID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($postcardID, true), gettype($postcardID)), __LINE__);
        }
        $this->postcardID = $postcardID;
        return $this;
    }
    /**
     * Get loginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->loginToken;
    }
    /**
     * Set loginToken value
     * @param string $loginToken
     * @return \NineDotMedia\viapost-php\Struct\CreatePostcard
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->loginToken = $loginToken;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \NineDotMedia\viapost-php\Struct\CreatePostcard
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \NineDotMedia\viapost-php\Struct\CreatePostcard
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get fileContentsFront value
     * @return string|null
     */
    public function getFileContentsFront()
    {
        return $this->fileContentsFront;
    }
    /**
     * Set fileContentsFront value
     * @param string $fileContentsFront
     * @return \NineDotMedia\viapost-php\Struct\CreatePostcard
     */
    public function setFileContentsFront($fileContentsFront = null)
    {
        // validation for constraint: string
        if (!is_null($fileContentsFront) && !is_string($fileContentsFront)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileContentsFront, true), gettype($fileContentsFront)), __LINE__);
        }
        $this->fileContentsFront = $fileContentsFront;
        return $this;
    }
    /**
     * Get fileContentsBack value
     * @return string|null
     */
    public function getFileContentsBack()
    {
        return $this->fileContentsBack;
    }
    /**
     * Set fileContentsBack value
     * @param string $fileContentsBack
     * @return \NineDotMedia\viapost-php\Struct\CreatePostcard
     */
    public function setFileContentsBack($fileContentsBack = null)
    {
        // validation for constraint: string
        if (!is_null($fileContentsBack) && !is_string($fileContentsBack)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileContentsBack, true), gettype($fileContentsBack)), __LINE__);
        }
        $this->fileContentsBack = $fileContentsBack;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \NineDotMedia\viapost-php\Struct\CreatePostcard
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
