<?php

namespace NineDotMedia\viapost-php\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateMailPackResponse Struct
 * @subpackage Structs
 */
class CreateMailPackResponse extends AbstractStructBase
{
    /**
     * The CreateMailPackResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CreateMailPackResult;
    /**
     * The mailPackID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $mailPackID;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for CreateMailPackResponse
     * @uses CreateMailPackResponse::setCreateMailPackResult()
     * @uses CreateMailPackResponse::setMailPackID()
     * @uses CreateMailPackResponse::setReturnMessage()
     * @param bool $createMailPackResult
     * @param int $mailPackID
     * @param string $returnMessage
     */
    public function __construct($createMailPackResult = null, $mailPackID = null, $returnMessage = null)
    {
        $this
            ->setCreateMailPackResult($createMailPackResult)
            ->setMailPackID($mailPackID)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get CreateMailPackResult value
     * @return bool
     */
    public function getCreateMailPackResult()
    {
        return $this->CreateMailPackResult;
    }
    /**
     * Set CreateMailPackResult value
     * @param bool $createMailPackResult
     * @return \NineDotMedia\viapost-php\Struct\CreateMailPackResponse
     */
    public function setCreateMailPackResult($createMailPackResult = null)
    {
        // validation for constraint: boolean
        if (!is_null($createMailPackResult) && !is_bool($createMailPackResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($createMailPackResult, true), gettype($createMailPackResult)), __LINE__);
        }
        $this->CreateMailPackResult = $createMailPackResult;
        return $this;
    }
    /**
     * Get mailPackID value
     * @return int
     */
    public function getMailPackID()
    {
        return $this->mailPackID;
    }
    /**
     * Set mailPackID value
     * @param int $mailPackID
     * @return \NineDotMedia\viapost-php\Struct\CreateMailPackResponse
     */
    public function setMailPackID($mailPackID = null)
    {
        // validation for constraint: int
        if (!is_null($mailPackID) && !(is_int($mailPackID) || ctype_digit($mailPackID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mailPackID, true), gettype($mailPackID)), __LINE__);
        }
        $this->mailPackID = $mailPackID;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \NineDotMedia\viapost-php\Struct\CreateMailPackResponse
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
