<?php

namespace NineDotMedia\viapost-php\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateLetterFromXPS Struct
 * @subpackage Structs
 */
class CreateLetterFromXPS extends AbstractStructBase
{
    /**
     * The shareLetterWithGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $shareLetterWithGroup;
    /**
     * The letterID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $letterID;
    /**
     * The loginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginToken;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The fileContents
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $fileContents;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for CreateLetterFromXPS
     * @uses CreateLetterFromXPS::setShareLetterWithGroup()
     * @uses CreateLetterFromXPS::setLetterID()
     * @uses CreateLetterFromXPS::setLoginToken()
     * @uses CreateLetterFromXPS::setName()
     * @uses CreateLetterFromXPS::setDescription()
     * @uses CreateLetterFromXPS::setFileContents()
     * @uses CreateLetterFromXPS::setReturnMessage()
     * @param bool $shareLetterWithGroup
     * @param int $letterID
     * @param string $loginToken
     * @param string $name
     * @param string $description
     * @param string $fileContents
     * @param string $returnMessage
     */
    public function __construct($shareLetterWithGroup = null, $letterID = null, $loginToken = null, $name = null, $description = null, $fileContents = null, $returnMessage = null)
    {
        $this
            ->setShareLetterWithGroup($shareLetterWithGroup)
            ->setLetterID($letterID)
            ->setLoginToken($loginToken)
            ->setName($name)
            ->setDescription($description)
            ->setFileContents($fileContents)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get shareLetterWithGroup value
     * @return bool
     */
    public function getShareLetterWithGroup()
    {
        return $this->shareLetterWithGroup;
    }
    /**
     * Set shareLetterWithGroup value
     * @param bool $shareLetterWithGroup
     * @return \NineDotMedia\viapost-php\Struct\CreateLetterFromXPS
     */
    public function setShareLetterWithGroup($shareLetterWithGroup = null)
    {
        // validation for constraint: boolean
        if (!is_null($shareLetterWithGroup) && !is_bool($shareLetterWithGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shareLetterWithGroup, true), gettype($shareLetterWithGroup)), __LINE__);
        }
        $this->shareLetterWithGroup = $shareLetterWithGroup;
        return $this;
    }
    /**
     * Get letterID value
     * @return int
     */
    public function getLetterID()
    {
        return $this->letterID;
    }
    /**
     * Set letterID value
     * @param int $letterID
     * @return \NineDotMedia\viapost-php\Struct\CreateLetterFromXPS
     */
    public function setLetterID($letterID = null)
    {
        // validation for constraint: int
        if (!is_null($letterID) && !(is_int($letterID) || ctype_digit($letterID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($letterID, true), gettype($letterID)), __LINE__);
        }
        $this->letterID = $letterID;
        return $this;
    }
    /**
     * Get loginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->loginToken;
    }
    /**
     * Set loginToken value
     * @param string $loginToken
     * @return \NineDotMedia\viapost-php\Struct\CreateLetterFromXPS
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->loginToken = $loginToken;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \NineDotMedia\viapost-php\Struct\CreateLetterFromXPS
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \NineDotMedia\viapost-php\Struct\CreateLetterFromXPS
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get fileContents value
     * @return string|null
     */
    public function getFileContents()
    {
        return $this->fileContents;
    }
    /**
     * Set fileContents value
     * @param string $fileContents
     * @return \NineDotMedia\viapost-php\Struct\CreateLetterFromXPS
     */
    public function setFileContents($fileContents = null)
    {
        // validation for constraint: string
        if (!is_null($fileContents) && !is_string($fileContents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileContents, true), gettype($fileContents)), __LINE__);
        }
        $this->fileContents = $fileContents;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \NineDotMedia\viapost-php\Struct\CreateLetterFromXPS
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
