<?php

namespace NineDotMedia\viapost-php\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateJobRunRecord Struct
 * @subpackage Structs
 */
class CreateJobRunRecord extends AbstractStructBase
{
    /**
     * The jobRunID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $jobRunID;
    /**
     * The loginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginToken;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for CreateJobRunRecord
     * @uses CreateJobRunRecord::setJobRunID()
     * @uses CreateJobRunRecord::setLoginToken()
     * @uses CreateJobRunRecord::setReturnMessage()
     * @param int $jobRunID
     * @param string $loginToken
     * @param string $returnMessage
     */
    public function __construct($jobRunID = null, $loginToken = null, $returnMessage = null)
    {
        $this
            ->setJobRunID($jobRunID)
            ->setLoginToken($loginToken)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get jobRunID value
     * @return int
     */
    public function getJobRunID()
    {
        return $this->jobRunID;
    }
    /**
     * Set jobRunID value
     * @param int $jobRunID
     * @return \NineDotMedia\viapost-php\Struct\CreateJobRunRecord
     */
    public function setJobRunID($jobRunID = null)
    {
        // validation for constraint: int
        if (!is_null($jobRunID) && !(is_int($jobRunID) || ctype_digit($jobRunID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($jobRunID, true), gettype($jobRunID)), __LINE__);
        }
        $this->jobRunID = $jobRunID;
        return $this;
    }
    /**
     * Get loginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->loginToken;
    }
    /**
     * Set loginToken value
     * @param string $loginToken
     * @return \NineDotMedia\viapost-php\Struct\CreateJobRunRecord
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->loginToken = $loginToken;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \NineDotMedia\viapost-php\Struct\CreateJobRunRecord
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
