<?php

namespace NineDotMedia\viapost-php\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for APILetter Struct
 * @subpackage Structs
 */
class APILetter extends AbstractStructBase
{
    /**
     * The LetterId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LetterId;
    /**
     * The LetterType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LetterType;
    /**
     * The IsShared
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsShared;
    /**
     * The NumberOfPages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfPages;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for APILetter
     * @uses APILetter::setLetterId()
     * @uses APILetter::setLetterType()
     * @uses APILetter::setIsShared()
     * @uses APILetter::setNumberOfPages()
     * @uses APILetter::setName()
     * @uses APILetter::setDescription()
     * @param int $letterId
     * @param string $letterType
     * @param bool $isShared
     * @param int $numberOfPages
     * @param string $name
     * @param string $description
     */
    public function __construct($letterId = null, $letterType = null, $isShared = null, $numberOfPages = null, $name = null, $description = null)
    {
        $this
            ->setLetterId($letterId)
            ->setLetterType($letterType)
            ->setIsShared($isShared)
            ->setNumberOfPages($numberOfPages)
            ->setName($name)
            ->setDescription($description);
    }
    /**
     * Get LetterId value
     * @return int
     */
    public function getLetterId()
    {
        return $this->LetterId;
    }
    /**
     * Set LetterId value
     * @param int $letterId
     * @return \NineDotMedia\viapost-php\Struct\APILetter
     */
    public function setLetterId($letterId = null)
    {
        // validation for constraint: int
        if (!is_null($letterId) && !(is_int($letterId) || ctype_digit($letterId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($letterId, true), gettype($letterId)), __LINE__);
        }
        $this->LetterId = $letterId;
        return $this;
    }
    /**
     * Get LetterType value
     * @return string
     */
    public function getLetterType()
    {
        return $this->LetterType;
    }
    /**
     * Set LetterType value
     * @uses \NineDotMedia\viapost-php\Enum\APILetterType::valueIsValid()
     * @uses \NineDotMedia\viapost-php\Enum\APILetterType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $letterType
     * @return \NineDotMedia\viapost-php\Struct\APILetter
     */
    public function setLetterType($letterType = null)
    {
        // validation for constraint: enumeration
        if (!\NineDotMedia\viapost-php\Enum\APILetterType::valueIsValid($letterType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \NineDotMedia\viapost-php\Enum\APILetterType', is_array($letterType) ? implode(', ', $letterType) : var_export($letterType, true), implode(', ', \NineDotMedia\viapost-php\Enum\APILetterType::getValidValues())), __LINE__);
        }
        $this->LetterType = $letterType;
        return $this;
    }
    /**
     * Get IsShared value
     * @return bool
     */
    public function getIsShared()
    {
        return $this->IsShared;
    }
    /**
     * Set IsShared value
     * @param bool $isShared
     * @return \NineDotMedia\viapost-php\Struct\APILetter
     */
    public function setIsShared($isShared = null)
    {
        // validation for constraint: boolean
        if (!is_null($isShared) && !is_bool($isShared)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isShared, true), gettype($isShared)), __LINE__);
        }
        $this->IsShared = $isShared;
        return $this;
    }
    /**
     * Get NumberOfPages value
     * @return int
     */
    public function getNumberOfPages()
    {
        return $this->NumberOfPages;
    }
    /**
     * Set NumberOfPages value
     * @param int $numberOfPages
     * @return \NineDotMedia\viapost-php\Struct\APILetter
     */
    public function setNumberOfPages($numberOfPages = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfPages) && !(is_int($numberOfPages) || ctype_digit($numberOfPages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfPages, true), gettype($numberOfPages)), __LINE__);
        }
        $this->NumberOfPages = $numberOfPages;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \NineDotMedia\viapost-php\Struct\APILetter
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \NineDotMedia\viapost-php\Struct\APILetter
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
}
