<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \NineDotMedia\viapost-php\ClassMap::get(),
);
/**
 * Samples for Service ServiceType
 */
$service = new \NineDotMedia\viapost-php\Service\Service($options);
/**
 * Sample call for GetSystemID operation/method
 */
if ($service->GetSystemID(new \NineDotMedia\viapost-php\Struct\GetSystemID()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateLetterFromXPS operation/method
 */
if ($service->CreateLetterFromXPS(new \NineDotMedia\viapost-php\Struct\CreateLetterFromXPS()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetDocumentPageCountRange operation/method
 */
if ($service->GetDocumentPageCountRange(new \NineDotMedia\viapost-php\Struct\GetDocumentPageCountRange()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendDriverMailingConfirmation operation/method
 */
if ($service->SendDriverMailingConfirmation(new \NineDotMedia\viapost-php\Struct\SendDriverMailingConfirmation()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLibraryInserts operation/method
 */
if ($service->GetLibraryInserts(new \NineDotMedia\viapost-php\Struct\GetLibraryInserts()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetCostCentres operation/method
 */
if ($service->GetCostCentres(new \NineDotMedia\viapost-php\Struct\GetCostCentres()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GenerateMappingWithDefaultNameAndMergeFields operation/method
 */
if ($service->GenerateMappingWithDefaultNameAndMergeFields(new \NineDotMedia\viapost-php\Struct\GenerateMappingWithDefaultNameAndMergeFields()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GenerateMappingWithID operation/method
 */
if ($service->GenerateMappingWithID(new \NineDotMedia\viapost-php\Struct\GenerateMappingWithID()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GenerateMappingWithDefaultNameWithID operation/method
 */
if ($service->GenerateMappingWithDefaultNameWithID(new \NineDotMedia\viapost-php\Struct\GenerateMappingWithDefaultNameWithID()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GenerateMappingWithDefaultNameAndMergeFieldsWithID
 * operation/method
 */
if ($service->GenerateMappingWithDefaultNameAndMergeFieldsWithID(new \NineDotMedia\viapost-php\Struct\GenerateMappingWithDefaultNameAndMergeFieldsWithID()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAttachment operation/method
 */
if ($service->CreateAttachment(new \NineDotMedia\viapost-php\Struct\CreateAttachment()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateLetterhead operation/method
 */
if ($service->CreateLetterhead(new \NineDotMedia\viapost-php\Struct\CreateLetterhead()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateLetter operation/method
 */
if ($service->CreateLetter(new \NineDotMedia\viapost-php\Struct\CreateLetter()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateMailPack operation/method
 */
if ($service->CreateMailPack(new \NineDotMedia\viapost-php\Struct\CreateMailPack()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteMailPack operation/method
 */
if ($service->DeleteMailPack(new \NineDotMedia\viapost-php\Struct\DeleteMailPack()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendMailPack operation/method
 */
if ($service->SendMailPack(new \NineDotMedia\viapost-php\Struct\SendMailPack()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendMailPackToFindNearest operation/method
 */
if ($service->SendMailPackToFindNearest(new \NineDotMedia\viapost-php\Struct\SendMailPackToFindNearest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAndSendMailPack operation/method
 */
if ($service->CreateAndSendMailPack(new \NineDotMedia\viapost-php\Struct\CreateAndSendMailPack()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendMailPackToSingleAddress2 operation/method
 */
if ($service->SendMailPackToSingleAddress2(new \NineDotMedia\viapost-php\Struct\SendMailPackToSingleAddress2()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendMailPackToSingleAddress operation/method
 */
if ($service->SendMailPackToSingleAddress(new \NineDotMedia\viapost-php\Struct\SendMailPackToSingleAddress()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAndSendMailPackToSingleAddress operation/method
 */
if ($service->CreateAndSendMailPackToSingleAddress(new \NineDotMedia\viapost-php\Struct\CreateAndSendMailPackToSingleAddress()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendSimpleMailing operation/method
 */
if ($service->SendSimpleMailing(new \NineDotMedia\viapost-php\Struct\SendSimpleMailing()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendSimpleMailingToFindNearest operation/method
 */
if ($service->SendSimpleMailingToFindNearest(new \NineDotMedia\viapost-php\Struct\SendSimpleMailingToFindNearest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAndSendSimpleMailingToFindNearest operation/method
 */
if ($service->CreateAndSendSimpleMailingToFindNearest(new \NineDotMedia\viapost-php\Struct\CreateAndSendSimpleMailingToFindNearest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendSimpleMailingToSingleAddress operation/method
 */
if ($service->SendSimpleMailingToSingleAddress(new \NineDotMedia\viapost-php\Struct\SendSimpleMailingToSingleAddress()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAndSendSimpleMailing operation/method
 */
if ($service->CreateAndSendSimpleMailing(new \NineDotMedia\viapost-php\Struct\CreateAndSendSimpleMailing()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAndSendSimpleMailingToSingleAddress operation/method
 */
if ($service->CreateAndSendSimpleMailingToSingleAddress(new \NineDotMedia\viapost-php\Struct\CreateAndSendSimpleMailingToSingleAddress()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAndSendMailPackToFindNearest operation/method
 */
if ($service->CreateAndSendMailPackToFindNearest(new \NineDotMedia\viapost-php\Struct\CreateAndSendMailPackToFindNearest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for AddExcludedAddress operation/method
 */
if ($service->AddExcludedAddress(new \NineDotMedia\viapost-php\Struct\AddExcludedAddress()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetExcludedAddresses operation/method
 */
if ($service->GetExcludedAddresses(new \NineDotMedia\viapost-php\Struct\GetExcludedAddresses()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteExcludedAddressByID operation/method
 */
if ($service->DeleteExcludedAddressByID(new \NineDotMedia\viapost-php\Struct\DeleteExcludedAddressByID()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for FindNearestQueryAddress operation/method
 */
if ($service->FindNearestQueryAddress(new \NineDotMedia\viapost-php\Struct\FindNearestQueryAddress()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for FindNearestExecuteSearch operation/method
 */
if ($service->FindNearestExecuteSearch(new \NineDotMedia\viapost-php\Struct\FindNearestExecuteSearch()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for UpdateLetter operation/method
 */
if ($service->UpdateLetter(new \NineDotMedia\viapost-php\Struct\UpdateLetter()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for UpdateMailPackLetter operation/method
 */
if ($service->UpdateMailPackLetter(new \NineDotMedia\viapost-php\Struct\UpdateMailPackLetter()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for UpdateMailPackTemplate operation/method
 */
if ($service->UpdateMailPackTemplate(new \NineDotMedia\viapost-php\Struct\UpdateMailPackTemplate()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetMailPacks operation/method
 */
if ($service->GetMailPacks(new \NineDotMedia\viapost-php\Struct\GetMailPacks()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLibraryMailPacks operation/method
 */
if ($service->GetLibraryMailPacks(new \NineDotMedia\viapost-php\Struct\GetLibraryMailPacks()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreatePostcard operation/method
 */
if ($service->CreatePostcard(new \NineDotMedia\viapost-php\Struct\CreatePostcard()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLibraryPostcards operation/method
 */
if ($service->GetLibraryPostcards(new \NineDotMedia\viapost-php\Struct\GetLibraryPostcards()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for PreviewLibraryPostcard operation/method
 */
if ($service->PreviewLibraryPostcard(new \NineDotMedia\viapost-php\Struct\PreviewLibraryPostcard()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendPostcardToSingleAddress operation/method
 */
if ($service->SendPostcardToSingleAddress(new \NineDotMedia\viapost-php\Struct\SendPostcardToSingleAddress()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendPostcard operation/method
 */
if ($service->SendPostcard(new \NineDotMedia\viapost-php\Struct\SendPostcard()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendPostcardToFindNearest operation/method
 */
if ($service->SendPostcardToFindNearest(new \NineDotMedia\viapost-php\Struct\SendPostcardToFindNearest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAndSendPostcardToSingleAddress operation/method
 */
if ($service->CreateAndSendPostcardToSingleAddress(new \NineDotMedia\viapost-php\Struct\CreateAndSendPostcardToSingleAddress()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAndSendPostcard operation/method
 */
if ($service->CreateAndSendPostcard(new \NineDotMedia\viapost-php\Struct\CreateAndSendPostcard()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAndSendPostcardToFindNearest operation/method
 */
if ($service->CreateAndSendPostcardToFindNearest(new \NineDotMedia\viapost-php\Struct\CreateAndSendPostcardToFindNearest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateCostOfSingleAddressMailing operation/method
 */
if ($service->CalculateCostOfSingleAddressMailing(new \NineDotMedia\viapost-php\Struct\CalculateCostOfSingleAddressMailing()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateCostOfMailing operation/method
 */
if ($service->CalculateCostOfMailing(new \NineDotMedia\viapost-php\Struct\CalculateCostOfMailing()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateCostOfFindNearestMailing operation/method
 */
if ($service->CalculateCostOfFindNearestMailing(new \NineDotMedia\viapost-php\Struct\CalculateCostOfFindNearestMailing()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLibraryLetterheads operation/method
 */
if ($service->GetLibraryLetterheads(new \NineDotMedia\viapost-php\Struct\GetLibraryLetterheads()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLibraryAttachments operation/method
 */
if ($service->GetLibraryAttachments(new \NineDotMedia\viapost-php\Struct\GetLibraryAttachments()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for PreviewLibraryLetterhead operation/method
 */
if ($service->PreviewLibraryLetterhead(new \NineDotMedia\viapost-php\Struct\PreviewLibraryLetterhead()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for PreviewLibraryAttachment operation/method
 */
if ($service->PreviewLibraryAttachment(new \NineDotMedia\viapost-php\Struct\PreviewLibraryAttachment()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for PreviewDocumentSingleAddress operation/method
 */
if ($service->PreviewDocumentSingleAddress(new \NineDotMedia\viapost-php\Struct\PreviewDocumentSingleAddress()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for PreviewDocumentMailingList operation/method
 */
if ($service->PreviewDocumentMailingList(new \NineDotMedia\viapost-php\Struct\PreviewDocumentMailingList()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for PreviewDocumentFindNearest operation/method
 */
if ($service->PreviewDocumentFindNearest(new \NineDotMedia\viapost-php\Struct\PreviewDocumentFindNearest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLibraryMappings operation/method
 */
if ($service->GetLibraryMappings(new \NineDotMedia\viapost-php\Struct\GetLibraryMappings()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetDataListUrl operation/method
 */
if ($service->GetDataListUrl(new \NineDotMedia\viapost-php\Struct\GetDataListUrl()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DownloadDataList operation/method
 */
if ($service->DownloadDataList(new \NineDotMedia\viapost-php\Struct\DownloadDataList()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetDataLists operation/method
 */
if ($service->GetDataLists(new \NineDotMedia\viapost-php\Struct\GetDataLists()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateCostOfDataList operation/method
 */
if ($service->CalculateCostOfDataList(new \NineDotMedia\viapost-php\Struct\CalculateCostOfDataList()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetUserVariables operation/method
 */
if ($service->GetUserVariables(new \NineDotMedia\viapost-php\Struct\GetUserVariables()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetDocumentation operation/method
 */
if ($service->GetDocumentation(new \NineDotMedia\viapost-php\Struct\GetDocumentation()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetMailHistoryJobs operation/method
 */
if ($service->GetMailHistoryJobs(new \NineDotMedia\viapost-php\Struct\GetMailHistoryJobs()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetMailHistoryDocumentsByJobId operation/method
 */
if ($service->GetMailHistoryDocumentsByJobId(new \NineDotMedia\viapost-php\Struct\GetMailHistoryDocumentsByJobId()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for RetryLetter operation/method
 */
if ($service->RetryLetter(new \NineDotMedia\viapost-php\Struct\RetryLetter()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetAddressesForPostcode operation/method
 */
if ($service->GetAddressesForPostcode(new \NineDotMedia\viapost-php\Struct\GetAddressesForPostcode()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetDocumentStickerArea operation/method
 */
if ($service->GetDocumentStickerArea(new \NineDotMedia\viapost-php\Struct\GetDocumentStickerArea()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetDocumentReservedAreas operation/method
 */
if ($service->GetDocumentReservedAreas(new \NineDotMedia\viapost-php\Struct\GetDocumentReservedAreas()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateCostOfNewMailing operation/method
 */
if ($service->CalculateCostOfNewMailing(new \NineDotMedia\viapost-php\Struct\CalculateCostOfNewMailing()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for IsFirstClassAvailable operation/method
 */
if ($service->IsFirstClassAvailable(new \NineDotMedia\viapost-php\Struct\IsFirstClassAvailable()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetUserDetails operation/method
 */
if ($service->GetUserDetails(new \NineDotMedia\viapost-php\Struct\GetUserDetails()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for IsValidLoginToken operation/method
 */
if ($service->IsValidLoginToken(new \NineDotMedia\viapost-php\Struct\IsValidLoginToken()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for ChangePassword operation/method
 */
if ($service->ChangePassword(new \NineDotMedia\viapost-php\Struct\ChangePassword()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLatestVersionDetails operation/method
 */
if ($service->GetLatestVersionDetails(new \NineDotMedia\viapost-php\Struct\GetLatestVersionDetails()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetAccountUrl operation/method
 */
if ($service->GetAccountUrl(new \NineDotMedia\viapost-php\Struct\GetAccountUrl()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetPortalUrl operation/method
 */
if ($service->GetPortalUrl(new \NineDotMedia\viapost-php\Struct\GetPortalUrl()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for PreviewLetter operation/method
 */
if ($service->PreviewLetter(new \NineDotMedia\viapost-php\Struct\PreviewLetter()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for PreviewLibraryLetter operation/method
 */
if ($service->PreviewLibraryLetter(new \NineDotMedia\viapost-php\Struct\PreviewLibraryLetter()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for PreviewMailPack operation/method
 */
if ($service->PreviewMailPack(new \NineDotMedia\viapost-php\Struct\PreviewMailPack()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SignIn operation/method
 */
if ($service->SignIn(new \NineDotMedia\viapost-php\Struct\SignIn()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for UploadDocument operation/method
 */
if ($service->UploadDocument(new \NineDotMedia\viapost-php\Struct\UploadDocument()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SearchAddress operation/method
 */
if ($service->SearchAddress(new \NineDotMedia\viapost-php\Struct\SearchAddress()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateJobRunRecord operation/method
 */
if ($service->CreateJobRunRecord(new \NineDotMedia\viapost-php\Struct\CreateJobRunRecord()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendLetterWithStructuredAddress operation/method
 */
if ($service->SendLetterWithStructuredAddress(new \NineDotMedia\viapost-php\Struct\SendLetterWithStructuredAddress()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendLetterWithStructuredAddressAndExceptions operation/method
 */
if ($service->SendLetterWithStructuredAddressAndExceptions(new \NineDotMedia\viapost-php\Struct\SendLetterWithStructuredAddressAndExceptions()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendLetter operation/method
 */
if ($service->SendLetter(new \NineDotMedia\viapost-php\Struct\SendLetter()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetBalance operation/method
 */
if ($service->GetBalance(new \NineDotMedia\viapost-php\Struct\GetBalance()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetAvailableFunds operation/method
 */
if ($service->GetAvailableFunds(new \NineDotMedia\viapost-php\Struct\GetAvailableFunds()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLetterByID operation/method
 */
if ($service->GetLetterByID(new \NineDotMedia\viapost-php\Struct\GetLetterByID()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLetters operation/method
 */
if ($service->GetLetters(new \NineDotMedia\viapost-php\Struct\GetLetters()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLibraryLetters operation/method
 */
if ($service->GetLibraryLetters(new \NineDotMedia\viapost-php\Struct\GetLibraryLetters()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetMailingLists operation/method
 */
if ($service->GetMailingLists(new \NineDotMedia\viapost-php\Struct\GetMailingLists()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetMailingListByID operation/method
 */
if ($service->GetMailingListByID(new \NineDotMedia\viapost-php\Struct\GetMailingListByID()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteMailingList operation/method
 */
if ($service->DeleteMailingList(new \NineDotMedia\viapost-php\Struct\DeleteMailingList()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteMapping operation/method
 */
if ($service->DeleteMapping(new \NineDotMedia\viapost-php\Struct\DeleteMapping()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteUserVariable operation/method
 */
if ($service->DeleteUserVariable(new \NineDotMedia\viapost-php\Struct\DeleteUserVariable()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteLetterhead operation/method
 */
if ($service->DeleteLetterhead(new \NineDotMedia\viapost-php\Struct\DeleteLetterhead()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteLetter operation/method
 */
if ($service->DeleteLetter(new \NineDotMedia\viapost-php\Struct\DeleteLetter()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteAttachment operation/method
 */
if ($service->DeleteAttachment(new \NineDotMedia\viapost-php\Struct\DeleteAttachment()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeletePostcard operation/method
 */
if ($service->DeletePostcard(new \NineDotMedia\viapost-php\Struct\DeletePostcard()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for UploadMailingList operation/method
 */
if ($service->UploadMailingList(new \NineDotMedia\viapost-php\Struct\UploadMailingList()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for UploadMailingListWithMapping operation/method
 */
if ($service->UploadMailingListWithMapping(new \NineDotMedia\viapost-php\Struct\UploadMailingListWithMapping()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for UploadMailingListWithMappingAndShare operation/method
 */
if ($service->UploadMailingListWithMappingAndShare(new \NineDotMedia\viapost-php\Struct\UploadMailingListWithMappingAndShare()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for UploadConsolidatedPDF operation/method
 */
if ($service->UploadConsolidatedPDF(new \NineDotMedia\viapost-php\Struct\UploadConsolidatedPDF()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for MailMerge operation/method
 */
if ($service->MailMerge(new \NineDotMedia\viapost-php\Struct\MailMerge()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for MailMergeWithExceptionsAndConfirmationEmails operation/method
 */
if ($service->MailMergeWithExceptionsAndConfirmationEmails(new \NineDotMedia\viapost-php\Struct\MailMergeWithExceptionsAndConfirmationEmails()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for MailMergeWithExceptions operation/method
 */
if ($service->MailMergeWithExceptions(new \NineDotMedia\viapost-php\Struct\MailMergeWithExceptions()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAccount operation/method
 */
if ($service->CreateAccount(new \NineDotMedia\viapost-php\Struct\CreateAccount()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAccountNonUK operation/method
 */
if ($service->CreateAccountNonUK(new \NineDotMedia\viapost-php\Struct\CreateAccountNonUK()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for AddUserToAccount operation/method
 */
if ($service->AddUserToAccount(new \NineDotMedia\viapost-php\Struct\AddUserToAccount()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for AddUserToAccountPermissions operation/method
 */
if ($service->AddUserToAccountPermissions(new \NineDotMedia\viapost-php\Struct\AddUserToAccountPermissions()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for AddUserToAccountNonUK operation/method
 */
if ($service->AddUserToAccountNonUK(new \NineDotMedia\viapost-php\Struct\AddUserToAccountNonUK()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for AddUserToAccountNonUKPermissions operation/method
 */
if ($service->AddUserToAccountNonUKPermissions(new \NineDotMedia\viapost-php\Struct\AddUserToAccountNonUKPermissions()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateLetterCostComplexBatchWithExceptions operation/method
 */
if ($service->CalculateLetterCostComplexBatchWithExceptions(new \NineDotMedia\viapost-php\Struct\CalculateLetterCostComplexBatchWithExceptions()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateLetterCostSimpleBatch operation/method
 */
if ($service->CalculateLetterCostSimpleBatch(new \NineDotMedia\viapost-php\Struct\CalculateLetterCostSimpleBatch()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateLetterCostSimpleBatchWithExceptions operation/method
 */
if ($service->CalculateLetterCostSimpleBatchWithExceptions(new \NineDotMedia\viapost-php\Struct\CalculateLetterCostSimpleBatchWithExceptions()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateLetterCostComplexBatch operation/method
 */
if ($service->CalculateLetterCostComplexBatch(new \NineDotMedia\viapost-php\Struct\CalculateLetterCostComplexBatch()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateMailMergeCost operation/method
 */
if ($service->CalculateMailMergeCost(new \NineDotMedia\viapost-php\Struct\CalculateMailMergeCost()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateEstimatedDeliveryDate operation/method
 */
if ($service->CalculateEstimatedDeliveryDate(new \NineDotMedia\viapost-php\Struct\CalculateEstimatedDeliveryDate()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateEstimatedDeliveryDateNow operation/method
 */
if ($service->CalculateEstimatedDeliveryDateNow(new \NineDotMedia\viapost-php\Struct\CalculateEstimatedDeliveryDateNow()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateSendDateForDeliveryDate operation/method
 */
if ($service->CalculateSendDateForDeliveryDate(new \NineDotMedia\viapost-php\Struct\CalculateSendDateForDeliveryDate()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLetterStatusByLetterID operation/method
 */
if ($service->GetLetterStatusByLetterID(new \NineDotMedia\viapost-php\Struct\GetLetterStatusByLetterID()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLetterStatusByCustomerAPILetter operation/method
 */
if ($service->GetLetterStatusByCustomerAPILetter(new \NineDotMedia\viapost-php\Struct\GetLetterStatusByCustomerAPILetter()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteLetterByLetterID operation/method
 */
if ($service->DeleteLetterByLetterID(new \NineDotMedia\viapost-php\Struct\DeleteLetterByLetterID()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteLetterByCustomerAPILetter operation/method
 */
if ($service->DeleteLetterByCustomerAPILetter(new \NineDotMedia\viapost-php\Struct\DeleteLetterByCustomerAPILetter()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreatePriceBand operation/method
 */
if ($service->CreatePriceBand(new \NineDotMedia\viapost-php\Struct\CreatePriceBand()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for AssignPriceBand operation/method
 */
if ($service->AssignPriceBand(new \NineDotMedia\viapost-php\Struct\AssignPriceBand()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetPriceBands operation/method
 */
if ($service->GetPriceBands(new \NineDotMedia\viapost-php\Struct\GetPriceBands()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeletePriceBand operation/method
 */
if ($service->DeletePriceBand(new \NineDotMedia\viapost-php\Struct\DeletePriceBand()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetCountries operation/method
 */
if ($service->GetCountries(new \NineDotMedia\viapost-php\Struct\GetCountries()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DisableUser operation/method
 */
if ($service->DisableUser(new \NineDotMedia\viapost-php\Struct\DisableUser()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetMessage operation/method
 */
if ($service->GetMessage(new \NineDotMedia\viapost-php\Struct\GetMessage()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GenerateMapping operation/method
 */
if ($service->GenerateMapping(new \NineDotMedia\viapost-php\Struct\GenerateMapping()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GenerateMappingWithDefaultName operation/method
 */
if ($service->GenerateMappingWithDefaultName(new \NineDotMedia\viapost-php\Struct\GenerateMappingWithDefaultName()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
