<?php

namespace NineDotMedia\viapost-php\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateLetterResponse Struct
 * @subpackage Structs
 */
class UpdateLetterResponse extends AbstractStructBase
{
    /**
     * The UpdateLetterResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $UpdateLetterResult;
    /**
     * The newLetterID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $newLetterID;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for UpdateLetterResponse
     * @uses UpdateLetterResponse::setUpdateLetterResult()
     * @uses UpdateLetterResponse::setNewLetterID()
     * @uses UpdateLetterResponse::setReturnMessage()
     * @param bool $updateLetterResult
     * @param int $newLetterID
     * @param string $returnMessage
     */
    public function __construct($updateLetterResult = null, $newLetterID = null, $returnMessage = null)
    {
        $this
            ->setUpdateLetterResult($updateLetterResult)
            ->setNewLetterID($newLetterID)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get UpdateLetterResult value
     * @return bool
     */
    public function getUpdateLetterResult()
    {
        return $this->UpdateLetterResult;
    }
    /**
     * Set UpdateLetterResult value
     * @param bool $updateLetterResult
     * @return \NineDotMedia\viapost-php\Struct\UpdateLetterResponse
     */
    public function setUpdateLetterResult($updateLetterResult = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateLetterResult) && !is_bool($updateLetterResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateLetterResult, true), gettype($updateLetterResult)), __LINE__);
        }
        $this->UpdateLetterResult = $updateLetterResult;
        return $this;
    }
    /**
     * Get newLetterID value
     * @return int
     */
    public function getNewLetterID()
    {
        return $this->newLetterID;
    }
    /**
     * Set newLetterID value
     * @param int $newLetterID
     * @return \NineDotMedia\viapost-php\Struct\UpdateLetterResponse
     */
    public function setNewLetterID($newLetterID = null)
    {
        // validation for constraint: int
        if (!is_null($newLetterID) && !(is_int($newLetterID) || ctype_digit($newLetterID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($newLetterID, true), gettype($newLetterID)), __LINE__);
        }
        $this->newLetterID = $newLetterID;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \NineDotMedia\viapost-php\Struct\UpdateLetterResponse
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
