<?php

namespace NineDotMedia\viapost-php\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDocumentPageCountRange Struct
 * @subpackage Structs
 */
class GetDocumentPageCountRange extends AbstractStructBase
{
    /**
     * The documentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $documentType;
    /**
     * The duplex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $duplex;
    /**
     * The minPageCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $minPageCount;
    /**
     * The maxPageCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $maxPageCount;
    /**
     * The loginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginToken;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for GetDocumentPageCountRange
     * @uses GetDocumentPageCountRange::setDocumentType()
     * @uses GetDocumentPageCountRange::setDuplex()
     * @uses GetDocumentPageCountRange::setMinPageCount()
     * @uses GetDocumentPageCountRange::setMaxPageCount()
     * @uses GetDocumentPageCountRange::setLoginToken()
     * @uses GetDocumentPageCountRange::setReturnMessage()
     * @param string $documentType
     * @param bool $duplex
     * @param int $minPageCount
     * @param int $maxPageCount
     * @param string $loginToken
     * @param string $returnMessage
     */
    public function __construct($documentType = null, $duplex = null, $minPageCount = null, $maxPageCount = null, $loginToken = null, $returnMessage = null)
    {
        $this
            ->setDocumentType($documentType)
            ->setDuplex($duplex)
            ->setMinPageCount($minPageCount)
            ->setMaxPageCount($maxPageCount)
            ->setLoginToken($loginToken)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get documentType value
     * @return string
     */
    public function getDocumentType()
    {
        return $this->documentType;
    }
    /**
     * Set documentType value
     * @uses \NineDotMedia\viapost-php\Enum\DocumentType::valueIsValid()
     * @uses \NineDotMedia\viapost-php\Enum\DocumentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $documentType
     * @return \NineDotMedia\viapost-php\Struct\GetDocumentPageCountRange
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: enumeration
        if (!\NineDotMedia\viapost-php\Enum\DocumentType::valueIsValid($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \NineDotMedia\viapost-php\Enum\DocumentType', is_array($documentType) ? implode(', ', $documentType) : var_export($documentType, true), implode(', ', \NineDotMedia\viapost-php\Enum\DocumentType::getValidValues())), __LINE__);
        }
        $this->documentType = $documentType;
        return $this;
    }
    /**
     * Get duplex value
     * @return bool
     */
    public function getDuplex()
    {
        return $this->duplex;
    }
    /**
     * Set duplex value
     * @param bool $duplex
     * @return \NineDotMedia\viapost-php\Struct\GetDocumentPageCountRange
     */
    public function setDuplex($duplex = null)
    {
        // validation for constraint: boolean
        if (!is_null($duplex) && !is_bool($duplex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($duplex, true), gettype($duplex)), __LINE__);
        }
        $this->duplex = $duplex;
        return $this;
    }
    /**
     * Get minPageCount value
     * @return int
     */
    public function getMinPageCount()
    {
        return $this->minPageCount;
    }
    /**
     * Set minPageCount value
     * @param int $minPageCount
     * @return \NineDotMedia\viapost-php\Struct\GetDocumentPageCountRange
     */
    public function setMinPageCount($minPageCount = null)
    {
        // validation for constraint: int
        if (!is_null($minPageCount) && !(is_int($minPageCount) || ctype_digit($minPageCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minPageCount, true), gettype($minPageCount)), __LINE__);
        }
        $this->minPageCount = $minPageCount;
        return $this;
    }
    /**
     * Get maxPageCount value
     * @return int
     */
    public function getMaxPageCount()
    {
        return $this->maxPageCount;
    }
    /**
     * Set maxPageCount value
     * @param int $maxPageCount
     * @return \NineDotMedia\viapost-php\Struct\GetDocumentPageCountRange
     */
    public function setMaxPageCount($maxPageCount = null)
    {
        // validation for constraint: int
        if (!is_null($maxPageCount) && !(is_int($maxPageCount) || ctype_digit($maxPageCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxPageCount, true), gettype($maxPageCount)), __LINE__);
        }
        $this->maxPageCount = $maxPageCount;
        return $this;
    }
    /**
     * Get loginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->loginToken;
    }
    /**
     * Set loginToken value
     * @param string $loginToken
     * @return \NineDotMedia\viapost-php\Struct\GetDocumentPageCountRange
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->loginToken = $loginToken;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \NineDotMedia\viapost-php\Struct\GetDocumentPageCountRange
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
