<?php

namespace \NineDotMedia\Viapost\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendMailPackToFindNearest Struct
 * @subpackage Structs
 */
class SendMailPackToFindNearest extends AbstractStructBase
{
    /**
     * The mailPackID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $mailPackID;
    /**
     * The numberOfAddressesToSearch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $numberOfAddressesToSearch;
    /**
     * The radiusOfAreaToSearchInMetres
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $radiusOfAreaToSearchInMetres;
    /**
     * The includeThisAddressInResults
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $includeThisAddressInResults;
    /**
     * The onlyAddressesInThisStreet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $onlyAddressesInThisStreet;
    /**
     * The addressTypes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $addressTypes;
    /**
     * The colour
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $colour;
    /**
     * The simplex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $simplex;
    /**
     * The sendNow
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $sendNow;
    /**
     * The dateToSend
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $dateToSend;
    /**
     * The emailNotification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $emailNotification;
    /**
     * The costOfMailing
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $costOfMailing;
    /**
     * The numberOfPages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $numberOfPages;
    /**
     * The numberOfSheets
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $numberOfSheets;
    /**
     * The numberOfAddressesSentTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $numberOfAddressesSentTo;
    /**
     * The loginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginToken;
    /**
     * The AddresseeTitle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddresseeTitle;
    /**
     * The houseNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $houseNumber;
    /**
     * The houseName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $houseName;
    /**
     * The Organisation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Organisation;
    /**
     * The postCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $postCode;
    /**
     * The firstClassStr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $firstClassStr;
    /**
     * The insertsStr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $insertsStr;
    /**
     * The costCentreStr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $costCentreStr;
    /**
     * The affiliateGUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $affiliateGUID;
    /**
     * The mailingNameOverride
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mailingNameOverride;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for SendMailPackToFindNearest
     * @uses SendMailPackToFindNearest::setMailPackID()
     * @uses SendMailPackToFindNearest::setNumberOfAddressesToSearch()
     * @uses SendMailPackToFindNearest::setRadiusOfAreaToSearchInMetres()
     * @uses SendMailPackToFindNearest::setIncludeThisAddressInResults()
     * @uses SendMailPackToFindNearest::setOnlyAddressesInThisStreet()
     * @uses SendMailPackToFindNearest::setAddressTypes()
     * @uses SendMailPackToFindNearest::setColour()
     * @uses SendMailPackToFindNearest::setSimplex()
     * @uses SendMailPackToFindNearest::setSendNow()
     * @uses SendMailPackToFindNearest::setDateToSend()
     * @uses SendMailPackToFindNearest::setEmailNotification()
     * @uses SendMailPackToFindNearest::setCostOfMailing()
     * @uses SendMailPackToFindNearest::setNumberOfPages()
     * @uses SendMailPackToFindNearest::setNumberOfSheets()
     * @uses SendMailPackToFindNearest::setNumberOfAddressesSentTo()
     * @uses SendMailPackToFindNearest::setLoginToken()
     * @uses SendMailPackToFindNearest::setAddresseeTitle()
     * @uses SendMailPackToFindNearest::setHouseNumber()
     * @uses SendMailPackToFindNearest::setHouseName()
     * @uses SendMailPackToFindNearest::setOrganisation()
     * @uses SendMailPackToFindNearest::setPostCode()
     * @uses SendMailPackToFindNearest::setFirstClassStr()
     * @uses SendMailPackToFindNearest::setInsertsStr()
     * @uses SendMailPackToFindNearest::setCostCentreStr()
     * @uses SendMailPackToFindNearest::setAffiliateGUID()
     * @uses SendMailPackToFindNearest::setMailingNameOverride()
     * @uses SendMailPackToFindNearest::setReturnMessage()
     * @param int $mailPackID
     * @param int $numberOfAddressesToSearch
     * @param int $radiusOfAreaToSearchInMetres
     * @param bool $includeThisAddressInResults
     * @param bool $onlyAddressesInThisStreet
     * @param string $addressTypes
     * @param bool $colour
     * @param bool $simplex
     * @param bool $sendNow
     * @param string $dateToSend
     * @param bool $emailNotification
     * @param float $costOfMailing
     * @param int $numberOfPages
     * @param int $numberOfSheets
     * @param int $numberOfAddressesSentTo
     * @param string $loginToken
     * @param string $addresseeTitle
     * @param string $houseNumber
     * @param string $houseName
     * @param string $organisation
     * @param string $postCode
     * @param string $firstClassStr
     * @param string $insertsStr
     * @param string $costCentreStr
     * @param string $affiliateGUID
     * @param string $mailingNameOverride
     * @param string $returnMessage
     */
    public function __construct($mailPackID = null, $numberOfAddressesToSearch = null, $radiusOfAreaToSearchInMetres = null, $includeThisAddressInResults = null, $onlyAddressesInThisStreet = null, $addressTypes = null, $colour = null, $simplex = null, $sendNow = null, $dateToSend = null, $emailNotification = null, $costOfMailing = null, $numberOfPages = null, $numberOfSheets = null, $numberOfAddressesSentTo = null, $loginToken = null, $addresseeTitle = null, $houseNumber = null, $houseName = null, $organisation = null, $postCode = null, $firstClassStr = null, $insertsStr = null, $costCentreStr = null, $affiliateGUID = null, $mailingNameOverride = null, $returnMessage = null)
    {
        $this
            ->setMailPackID($mailPackID)
            ->setNumberOfAddressesToSearch($numberOfAddressesToSearch)
            ->setRadiusOfAreaToSearchInMetres($radiusOfAreaToSearchInMetres)
            ->setIncludeThisAddressInResults($includeThisAddressInResults)
            ->setOnlyAddressesInThisStreet($onlyAddressesInThisStreet)
            ->setAddressTypes($addressTypes)
            ->setColour($colour)
            ->setSimplex($simplex)
            ->setSendNow($sendNow)
            ->setDateToSend($dateToSend)
            ->setEmailNotification($emailNotification)
            ->setCostOfMailing($costOfMailing)
            ->setNumberOfPages($numberOfPages)
            ->setNumberOfSheets($numberOfSheets)
            ->setNumberOfAddressesSentTo($numberOfAddressesSentTo)
            ->setLoginToken($loginToken)
            ->setAddresseeTitle($addresseeTitle)
            ->setHouseNumber($houseNumber)
            ->setHouseName($houseName)
            ->setOrganisation($organisation)
            ->setPostCode($postCode)
            ->setFirstClassStr($firstClassStr)
            ->setInsertsStr($insertsStr)
            ->setCostCentreStr($costCentreStr)
            ->setAffiliateGUID($affiliateGUID)
            ->setMailingNameOverride($mailingNameOverride)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get mailPackID value
     * @return int
     */
    public function getMailPackID()
    {
        return $this->mailPackID;
    }
    /**
     * Set mailPackID value
     * @param int $mailPackID
     * @return \\NineDotMedia\Viapost\Struct\SendMailPackToFindNearest
     */
    public function setMailPackID($mailPackID = null)
    {
        // validation for constraint: int
        if (!is_null($mailPackID) && !(is_int($mailPackID) || ctype_digit($mailPackID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mailPackID, true), gettype($mailPackID)), __LINE__);
        }
        $this->mailPackID = $mailPackID;
        return $this;
    }
    /**
     * Get numberOfAddressesToSearch value
     * @return int
     */
    public function getNumberOfAddressesToSearch()
    {
        return $this->numberOfAddressesToSearch;
    }
    /**
     * Set numberOfAddressesToSearch value
     * @param int $numberOfAddressesToSearch
     * @return \\NineDotMedia\Viapost\Struct\SendMailPackToFindNearest
     */
    public function setNumberOfAddressesToSearch($numberOfAddressesToSearch = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfAddressesToSearch) && !(is_int($numberOfAddressesToSearch) || ctype_digit($numberOfAddressesToSearch))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfAddressesToSearch, true), gettype($numberOfAddressesToSearch)), __LINE__);
        }
        $this->numberOfAddressesToSearch = $numberOfAddressesToSearch;
        return $this;
    }
    /**
     * Get radiusOfAreaToSearchInMetres value
     * @return int
     */
    public function getRadiusOfAreaToSearchInMetres()
    {
        return $this->radiusOfAreaToSearchInMetres;
    }
    /**
     * Set radiusOfAreaToSearchInMetres value
     * @param int $radiusOfAreaToSearchInMetres
     * @return \\NineDotMedia\Viapost\Struct\SendMailPackToFindNearest
     */
    public function setRadiusOfAreaToSearchInMetres($radiusOfAreaToSearchInMetres = null)
    {
        // validation for constraint: int
        if (!is_null($radiusOfAreaToSearchInMetres) && !(is_int($radiusOfAreaToSearchInMetres) || ctype_digit($radiusOfAreaToSearchInMetres))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($radiusOfAreaToSearchInMetres, true), gettype($radiusOfAreaToSearchInMetres)), __LINE__);
        }
        $this->radiusOfAreaToSearchInMetres = $radiusOfAreaToSearchInMetres;
        return $this;
    }
    /**
     * Get includeThisAddressInResults value
     * @return bool
     */
    public function getIncludeThisAddressInResults()
    {
        return $this->includeThisAddressInResults;
    }
    /**
     * Set includeThisAddressInResults value
     * @param bool $includeThisAddressInResults
     * @return \\NineDotMedia\Viapost\Struct\SendMailPackToFindNearest
     */
    public function setIncludeThisAddressInResults($includeThisAddressInResults = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeThisAddressInResults) && !is_bool($includeThisAddressInResults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeThisAddressInResults, true), gettype($includeThisAddressInResults)), __LINE__);
        }
        $this->includeThisAddressInResults = $includeThisAddressInResults;
        return $this;
    }
    /**
     * Get onlyAddressesInThisStreet value
     * @return bool
     */
    public function getOnlyAddressesInThisStreet()
    {
        return $this->onlyAddressesInThisStreet;
    }
    /**
     * Set onlyAddressesInThisStreet value
     * @param bool $onlyAddressesInThisStreet
     * @return \\NineDotMedia\Viapost\Struct\SendMailPackToFindNearest
     */
    public function setOnlyAddressesInThisStreet($onlyAddressesInThisStreet = null)
    {
        // validation for constraint: boolean
        if (!is_null($onlyAddressesInThisStreet) && !is_bool($onlyAddressesInThisStreet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onlyAddressesInThisStreet, true), gettype($onlyAddressesInThisStreet)), __LINE__);
        }
        $this->onlyAddressesInThisStreet = $onlyAddressesInThisStreet;
        return $this;
    }
    /**
     * Get addressTypes value
     * @return string
     */
    public function getAddressTypes()
    {
        return $this->addressTypes;
    }
    /**
     * Set addressTypes value
     * @uses \\NineDotMedia\Viapost\Enum\FindNearestAddressTypes::valueIsValid()
     * @uses \\NineDotMedia\Viapost\Enum\FindNearestAddressTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $addressTypes
     * @return \\NineDotMedia\Viapost\Struct\SendMailPackToFindNearest
     */
    public function setAddressTypes($addressTypes = null)
    {
        // validation for constraint: enumeration
        if (!\\NineDotMedia\Viapost\Enum\FindNearestAddressTypes::valueIsValid($addressTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \\NineDotMedia\Viapost\Enum\FindNearestAddressTypes', is_array($addressTypes) ? implode(', ', $addressTypes) : var_export($addressTypes, true), implode(', ', \\NineDotMedia\Viapost\Enum\FindNearestAddressTypes::getValidValues())), __LINE__);
        }
        $this->addressTypes = $addressTypes;
        return $this;
    }
    /**
     * Get colour value
     * @return bool
     */
    public function getColour()
    {
        return $this->colour;
    }
    /**
     * Set colour value
     * @param bool $colour
     * @return \\NineDotMedia\Viapost\Struct\SendMailPackToFindNearest
     */
    public function setColour($colour = null)
    {
        // validation for constraint: boolean
        if (!is_null($colour) && !is_bool($colour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($colour, true), gettype($colour)), __LINE__);
        }
        $this->colour = $colour;
        return $this;
    }
    /**
     * Get simplex value
     * @return bool
     */
    public function getSimplex()
    {
        return $this->simplex;
    }
    /**
     * Set simplex value
     * @param bool $simplex
     * @return \\NineDotMedia\Viapost\Struct\SendMailPackToFindNearest
     */
    public function setSimplex($simplex = null)
    {
        // validation for constraint: boolean
        if (!is_null($simplex) && !is_bool($simplex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($simplex, true), gettype($simplex)), __LINE__);
        }
        $this->simplex = $simplex;
        return $this;
    }
    /**
     * Get sendNow value
     * @return bool
     */
    public function getSendNow()
    {
        return $this->sendNow;
    }
    /**
     * Set sendNow value
     * @param bool $sendNow
     * @return \\NineDotMedia\Viapost\Struct\SendMailPackToFindNearest
     */
    public function setSendNow($sendNow = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendNow) && !is_bool($sendNow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendNow, true), gettype($sendNow)), __LINE__);
        }
        $this->sendNow = $sendNow;
        return $this;
    }
    /**
     * Get dateToSend value
     * @return string
     */
    public function getDateToSend()
    {
        return $this->dateToSend;
    }
    /**
     * Set dateToSend value
     * @param string $dateToSend
     * @return \\NineDotMedia\Viapost\Struct\SendMailPackToFindNearest
     */
    public function setDateToSend($dateToSend = null)
    {
        // validation for constraint: string
        if (!is_null($dateToSend) && !is_string($dateToSend)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateToSend, true), gettype($dateToSend)), __LINE__);
        }
        $this->dateToSend = $dateToSend;
        return $this;
    }
    /**
     * Get emailNotification value
     * @return bool
     */
    public function getEmailNotification()
    {
        return $this->emailNotification;
    }
    /**
     * Set emailNotification value
     * @param bool $emailNotification
     * @return \\NineDotMedia\Viapost\Struct\SendMailPackToFindNearest
     */
    public function setEmailNotification($emailNotification = null)
    {
        // validation for constraint: boolean
        if (!is_null($emailNotification) && !is_bool($emailNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($emailNotification, true), gettype($emailNotification)), __LINE__);
        }
        $this->emailNotification = $emailNotification;
        return $this;
    }
    /**
     * Get costOfMailing value
     * @return float
     */
    public function getCostOfMailing()
    {
        return $this->costOfMailing;
    }
    /**
     * Set costOfMailing value
     * @param float $costOfMailing
     * @return \\NineDotMedia\Viapost\Struct\SendMailPackToFindNearest
     */
    public function setCostOfMailing($costOfMailing = null)
    {
        // validation for constraint: float
        if (!is_null($costOfMailing) && !(is_float($costOfMailing) || is_numeric($costOfMailing))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($costOfMailing, true), gettype($costOfMailing)), __LINE__);
        }
        $this->costOfMailing = $costOfMailing;
        return $this;
    }
    /**
     * Get numberOfPages value
     * @return int
     */
    public function getNumberOfPages()
    {
        return $this->numberOfPages;
    }
    /**
     * Set numberOfPages value
     * @param int $numberOfPages
     * @return \\NineDotMedia\Viapost\Struct\SendMailPackToFindNearest
     */
    public function setNumberOfPages($numberOfPages = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfPages) && !(is_int($numberOfPages) || ctype_digit($numberOfPages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfPages, true), gettype($numberOfPages)), __LINE__);
        }
        $this->numberOfPages = $numberOfPages;
        return $this;
    }
    /**
     * Get numberOfSheets value
     * @return int
     */
    public function getNumberOfSheets()
    {
        return $this->numberOfSheets;
    }
    /**
     * Set numberOfSheets value
     * @param int $numberOfSheets
     * @return \\NineDotMedia\Viapost\Struct\SendMailPackToFindNearest
     */
    public function setNumberOfSheets($numberOfSheets = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfSheets) && !(is_int($numberOfSheets) || ctype_digit($numberOfSheets))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfSheets, true), gettype($numberOfSheets)), __LINE__);
        }
        $this->numberOfSheets = $numberOfSheets;
        return $this;
    }
    /**
     * Get numberOfAddressesSentTo value
     * @return int
     */
    public function getNumberOfAddressesSentTo()
    {
        return $this->numberOfAddressesSentTo;
    }
    /**
     * Set numberOfAddressesSentTo value
     * @param int $numberOfAddressesSentTo
     * @return \\NineDotMedia\Viapost\Struct\SendMailPackToFindNearest
     */
    public function setNumberOfAddressesSentTo($numberOfAddressesSentTo = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfAddressesSentTo) && !(is_int($numberOfAddressesSentTo) || ctype_digit($numberOfAddressesSentTo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfAddressesSentTo, true), gettype($numberOfAddressesSentTo)), __LINE__);
        }
        $this->numberOfAddressesSentTo = $numberOfAddressesSentTo;
        return $this;
    }
    /**
     * Get loginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->loginToken;
    }
    /**
     * Set loginToken value
     * @param string $loginToken
     * @return \\NineDotMedia\Viapost\Struct\SendMailPackToFindNearest
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->loginToken = $loginToken;
        return $this;
    }
    /**
     * Get AddresseeTitle value
     * @return string|null
     */
    public function getAddresseeTitle()
    {
        return $this->AddresseeTitle;
    }
    /**
     * Set AddresseeTitle value
     * @param string $addresseeTitle
     * @return \\NineDotMedia\Viapost\Struct\SendMailPackToFindNearest
     */
    public function setAddresseeTitle($addresseeTitle = null)
    {
        // validation for constraint: string
        if (!is_null($addresseeTitle) && !is_string($addresseeTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addresseeTitle, true), gettype($addresseeTitle)), __LINE__);
        }
        $this->AddresseeTitle = $addresseeTitle;
        return $this;
    }
    /**
     * Get houseNumber value
     * @return string|null
     */
    public function getHouseNumber()
    {
        return $this->houseNumber;
    }
    /**
     * Set houseNumber value
     * @param string $houseNumber
     * @return \\NineDotMedia\Viapost\Struct\SendMailPackToFindNearest
     */
    public function setHouseNumber($houseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($houseNumber) && !is_string($houseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($houseNumber, true), gettype($houseNumber)), __LINE__);
        }
        $this->houseNumber = $houseNumber;
        return $this;
    }
    /**
     * Get houseName value
     * @return string|null
     */
    public function getHouseName()
    {
        return $this->houseName;
    }
    /**
     * Set houseName value
     * @param string $houseName
     * @return \\NineDotMedia\Viapost\Struct\SendMailPackToFindNearest
     */
    public function setHouseName($houseName = null)
    {
        // validation for constraint: string
        if (!is_null($houseName) && !is_string($houseName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($houseName, true), gettype($houseName)), __LINE__);
        }
        $this->houseName = $houseName;
        return $this;
    }
    /**
     * Get Organisation value
     * @return string|null
     */
    public function getOrganisation()
    {
        return $this->Organisation;
    }
    /**
     * Set Organisation value
     * @param string $organisation
     * @return \\NineDotMedia\Viapost\Struct\SendMailPackToFindNearest
     */
    public function setOrganisation($organisation = null)
    {
        // validation for constraint: string
        if (!is_null($organisation) && !is_string($organisation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organisation, true), gettype($organisation)), __LINE__);
        }
        $this->Organisation = $organisation;
        return $this;
    }
    /**
     * Get postCode value
     * @return string|null
     */
    public function getPostCode()
    {
        return $this->postCode;
    }
    /**
     * Set postCode value
     * @param string $postCode
     * @return \\NineDotMedia\Viapost\Struct\SendMailPackToFindNearest
     */
    public function setPostCode($postCode = null)
    {
        // validation for constraint: string
        if (!is_null($postCode) && !is_string($postCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postCode, true), gettype($postCode)), __LINE__);
        }
        $this->postCode = $postCode;
        return $this;
    }
    /**
     * Get firstClassStr value
     * @return string|null
     */
    public function getFirstClassStr()
    {
        return $this->firstClassStr;
    }
    /**
     * Set firstClassStr value
     * @param string $firstClassStr
     * @return \\NineDotMedia\Viapost\Struct\SendMailPackToFindNearest
     */
    public function setFirstClassStr($firstClassStr = null)
    {
        // validation for constraint: string
        if (!is_null($firstClassStr) && !is_string($firstClassStr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstClassStr, true), gettype($firstClassStr)), __LINE__);
        }
        $this->firstClassStr = $firstClassStr;
        return $this;
    }
    /**
     * Get insertsStr value
     * @return string|null
     */
    public function getInsertsStr()
    {
        return $this->insertsStr;
    }
    /**
     * Set insertsStr value
     * @param string $insertsStr
     * @return \\NineDotMedia\Viapost\Struct\SendMailPackToFindNearest
     */
    public function setInsertsStr($insertsStr = null)
    {
        // validation for constraint: string
        if (!is_null($insertsStr) && !is_string($insertsStr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insertsStr, true), gettype($insertsStr)), __LINE__);
        }
        $this->insertsStr = $insertsStr;
        return $this;
    }
    /**
     * Get costCentreStr value
     * @return string|null
     */
    public function getCostCentreStr()
    {
        return $this->costCentreStr;
    }
    /**
     * Set costCentreStr value
     * @param string $costCentreStr
     * @return \\NineDotMedia\Viapost\Struct\SendMailPackToFindNearest
     */
    public function setCostCentreStr($costCentreStr = null)
    {
        // validation for constraint: string
        if (!is_null($costCentreStr) && !is_string($costCentreStr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($costCentreStr, true), gettype($costCentreStr)), __LINE__);
        }
        $this->costCentreStr = $costCentreStr;
        return $this;
    }
    /**
     * Get affiliateGUID value
     * @return string|null
     */
    public function getAffiliateGUID()
    {
        return $this->affiliateGUID;
    }
    /**
     * Set affiliateGUID value
     * @param string $affiliateGUID
     * @return \\NineDotMedia\Viapost\Struct\SendMailPackToFindNearest
     */
    public function setAffiliateGUID($affiliateGUID = null)
    {
        // validation for constraint: string
        if (!is_null($affiliateGUID) && !is_string($affiliateGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($affiliateGUID, true), gettype($affiliateGUID)), __LINE__);
        }
        $this->affiliateGUID = $affiliateGUID;
        return $this;
    }
    /**
     * Get mailingNameOverride value
     * @return string|null
     */
    public function getMailingNameOverride()
    {
        return $this->mailingNameOverride;
    }
    /**
     * Set mailingNameOverride value
     * @param string $mailingNameOverride
     * @return \\NineDotMedia\Viapost\Struct\SendMailPackToFindNearest
     */
    public function setMailingNameOverride($mailingNameOverride = null)
    {
        // validation for constraint: string
        if (!is_null($mailingNameOverride) && !is_string($mailingNameOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailingNameOverride, true), gettype($mailingNameOverride)), __LINE__);
        }
        $this->mailingNameOverride = $mailingNameOverride;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \\NineDotMedia\Viapost\Struct\SendMailPackToFindNearest
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
