<?php

namespace \NineDotMedia\Viapost\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PreviewDocumentFindNearest Struct
 * @subpackage Structs
 */
class PreviewDocumentFindNearest extends AbstractStructBase
{
    /**
     * The documentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $documentType;
    /**
     * The documentID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $documentID;
    /**
     * The colour
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $colour;
    /**
     * The simplex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $simplex;
    /**
     * The addressTypes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $addressTypes;
    /**
     * The loginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginToken;
    /**
     * The addresseeTitle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $addresseeTitle;
    /**
     * The houseNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $houseNumber;
    /**
     * The houseName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $houseName;
    /**
     * The organisation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $organisation;
    /**
     * The postCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $postCode;
    /**
     * The documentData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $documentData;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for PreviewDocumentFindNearest
     * @uses PreviewDocumentFindNearest::setDocumentType()
     * @uses PreviewDocumentFindNearest::setDocumentID()
     * @uses PreviewDocumentFindNearest::setColour()
     * @uses PreviewDocumentFindNearest::setSimplex()
     * @uses PreviewDocumentFindNearest::setAddressTypes()
     * @uses PreviewDocumentFindNearest::setLoginToken()
     * @uses PreviewDocumentFindNearest::setAddresseeTitle()
     * @uses PreviewDocumentFindNearest::setHouseNumber()
     * @uses PreviewDocumentFindNearest::setHouseName()
     * @uses PreviewDocumentFindNearest::setOrganisation()
     * @uses PreviewDocumentFindNearest::setPostCode()
     * @uses PreviewDocumentFindNearest::setDocumentData()
     * @uses PreviewDocumentFindNearest::setReturnMessage()
     * @param string $documentType
     * @param int $documentID
     * @param bool $colour
     * @param bool $simplex
     * @param string $addressTypes
     * @param string $loginToken
     * @param string $addresseeTitle
     * @param string $houseNumber
     * @param string $houseName
     * @param string $organisation
     * @param string $postCode
     * @param string $documentData
     * @param string $returnMessage
     */
    public function __construct($documentType = null, $documentID = null, $colour = null, $simplex = null, $addressTypes = null, $loginToken = null, $addresseeTitle = null, $houseNumber = null, $houseName = null, $organisation = null, $postCode = null, $documentData = null, $returnMessage = null)
    {
        $this
            ->setDocumentType($documentType)
            ->setDocumentID($documentID)
            ->setColour($colour)
            ->setSimplex($simplex)
            ->setAddressTypes($addressTypes)
            ->setLoginToken($loginToken)
            ->setAddresseeTitle($addresseeTitle)
            ->setHouseNumber($houseNumber)
            ->setHouseName($houseName)
            ->setOrganisation($organisation)
            ->setPostCode($postCode)
            ->setDocumentData($documentData)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get documentType value
     * @return string
     */
    public function getDocumentType()
    {
        return $this->documentType;
    }
    /**
     * Set documentType value
     * @uses \\NineDotMedia\Viapost\Enum\DocumentType::valueIsValid()
     * @uses \\NineDotMedia\Viapost\Enum\DocumentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $documentType
     * @return \\NineDotMedia\Viapost\Struct\PreviewDocumentFindNearest
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: enumeration
        if (!\\NineDotMedia\Viapost\Enum\DocumentType::valueIsValid($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \\NineDotMedia\Viapost\Enum\DocumentType', is_array($documentType) ? implode(', ', $documentType) : var_export($documentType, true), implode(', ', \\NineDotMedia\Viapost\Enum\DocumentType::getValidValues())), __LINE__);
        }
        $this->documentType = $documentType;
        return $this;
    }
    /**
     * Get documentID value
     * @return int
     */
    public function getDocumentID()
    {
        return $this->documentID;
    }
    /**
     * Set documentID value
     * @param int $documentID
     * @return \\NineDotMedia\Viapost\Struct\PreviewDocumentFindNearest
     */
    public function setDocumentID($documentID = null)
    {
        // validation for constraint: int
        if (!is_null($documentID) && !(is_int($documentID) || ctype_digit($documentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentID, true), gettype($documentID)), __LINE__);
        }
        $this->documentID = $documentID;
        return $this;
    }
    /**
     * Get colour value
     * @return bool
     */
    public function getColour()
    {
        return $this->colour;
    }
    /**
     * Set colour value
     * @param bool $colour
     * @return \\NineDotMedia\Viapost\Struct\PreviewDocumentFindNearest
     */
    public function setColour($colour = null)
    {
        // validation for constraint: boolean
        if (!is_null($colour) && !is_bool($colour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($colour, true), gettype($colour)), __LINE__);
        }
        $this->colour = $colour;
        return $this;
    }
    /**
     * Get simplex value
     * @return bool
     */
    public function getSimplex()
    {
        return $this->simplex;
    }
    /**
     * Set simplex value
     * @param bool $simplex
     * @return \\NineDotMedia\Viapost\Struct\PreviewDocumentFindNearest
     */
    public function setSimplex($simplex = null)
    {
        // validation for constraint: boolean
        if (!is_null($simplex) && !is_bool($simplex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($simplex, true), gettype($simplex)), __LINE__);
        }
        $this->simplex = $simplex;
        return $this;
    }
    /**
     * Get addressTypes value
     * @return string
     */
    public function getAddressTypes()
    {
        return $this->addressTypes;
    }
    /**
     * Set addressTypes value
     * @uses \\NineDotMedia\Viapost\Enum\FindNearestAddressTypes::valueIsValid()
     * @uses \\NineDotMedia\Viapost\Enum\FindNearestAddressTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $addressTypes
     * @return \\NineDotMedia\Viapost\Struct\PreviewDocumentFindNearest
     */
    public function setAddressTypes($addressTypes = null)
    {
        // validation for constraint: enumeration
        if (!\\NineDotMedia\Viapost\Enum\FindNearestAddressTypes::valueIsValid($addressTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \\NineDotMedia\Viapost\Enum\FindNearestAddressTypes', is_array($addressTypes) ? implode(', ', $addressTypes) : var_export($addressTypes, true), implode(', ', \\NineDotMedia\Viapost\Enum\FindNearestAddressTypes::getValidValues())), __LINE__);
        }
        $this->addressTypes = $addressTypes;
        return $this;
    }
    /**
     * Get loginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->loginToken;
    }
    /**
     * Set loginToken value
     * @param string $loginToken
     * @return \\NineDotMedia\Viapost\Struct\PreviewDocumentFindNearest
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->loginToken = $loginToken;
        return $this;
    }
    /**
     * Get addresseeTitle value
     * @return string|null
     */
    public function getAddresseeTitle()
    {
        return $this->addresseeTitle;
    }
    /**
     * Set addresseeTitle value
     * @param string $addresseeTitle
     * @return \\NineDotMedia\Viapost\Struct\PreviewDocumentFindNearest
     */
    public function setAddresseeTitle($addresseeTitle = null)
    {
        // validation for constraint: string
        if (!is_null($addresseeTitle) && !is_string($addresseeTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addresseeTitle, true), gettype($addresseeTitle)), __LINE__);
        }
        $this->addresseeTitle = $addresseeTitle;
        return $this;
    }
    /**
     * Get houseNumber value
     * @return string|null
     */
    public function getHouseNumber()
    {
        return $this->houseNumber;
    }
    /**
     * Set houseNumber value
     * @param string $houseNumber
     * @return \\NineDotMedia\Viapost\Struct\PreviewDocumentFindNearest
     */
    public function setHouseNumber($houseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($houseNumber) && !is_string($houseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($houseNumber, true), gettype($houseNumber)), __LINE__);
        }
        $this->houseNumber = $houseNumber;
        return $this;
    }
    /**
     * Get houseName value
     * @return string|null
     */
    public function getHouseName()
    {
        return $this->houseName;
    }
    /**
     * Set houseName value
     * @param string $houseName
     * @return \\NineDotMedia\Viapost\Struct\PreviewDocumentFindNearest
     */
    public function setHouseName($houseName = null)
    {
        // validation for constraint: string
        if (!is_null($houseName) && !is_string($houseName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($houseName, true), gettype($houseName)), __LINE__);
        }
        $this->houseName = $houseName;
        return $this;
    }
    /**
     * Get organisation value
     * @return string|null
     */
    public function getOrganisation()
    {
        return $this->organisation;
    }
    /**
     * Set organisation value
     * @param string $organisation
     * @return \\NineDotMedia\Viapost\Struct\PreviewDocumentFindNearest
     */
    public function setOrganisation($organisation = null)
    {
        // validation for constraint: string
        if (!is_null($organisation) && !is_string($organisation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organisation, true), gettype($organisation)), __LINE__);
        }
        $this->organisation = $organisation;
        return $this;
    }
    /**
     * Get postCode value
     * @return string|null
     */
    public function getPostCode()
    {
        return $this->postCode;
    }
    /**
     * Set postCode value
     * @param string $postCode
     * @return \\NineDotMedia\Viapost\Struct\PreviewDocumentFindNearest
     */
    public function setPostCode($postCode = null)
    {
        // validation for constraint: string
        if (!is_null($postCode) && !is_string($postCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postCode, true), gettype($postCode)), __LINE__);
        }
        $this->postCode = $postCode;
        return $this;
    }
    /**
     * Get documentData value
     * @return string|null
     */
    public function getDocumentData()
    {
        return $this->documentData;
    }
    /**
     * Set documentData value
     * @param string $documentData
     * @return \\NineDotMedia\Viapost\Struct\PreviewDocumentFindNearest
     */
    public function setDocumentData($documentData = null)
    {
        // validation for constraint: string
        if (!is_null($documentData) && !is_string($documentData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentData, true), gettype($documentData)), __LINE__);
        }
        $this->documentData = $documentData;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \\NineDotMedia\Viapost\Struct\PreviewDocumentFindNearest
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
