<?php

namespace \NineDotMedia\Viapost\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteExcludedAddressByID Struct
 * @subpackage Structs
 */
class DeleteExcludedAddressByID extends AbstractStructBase
{
    /**
     * The lngExcludedAddressID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $lngExcludedAddressID;
    /**
     * The loginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginToken;
    /**
     * The strReturnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $strReturnMessage;
    /**
     * Constructor method for DeleteExcludedAddressByID
     * @uses DeleteExcludedAddressByID::setLngExcludedAddressID()
     * @uses DeleteExcludedAddressByID::setLoginToken()
     * @uses DeleteExcludedAddressByID::setStrReturnMessage()
     * @param int $lngExcludedAddressID
     * @param string $loginToken
     * @param string $strReturnMessage
     */
    public function __construct($lngExcludedAddressID = null, $loginToken = null, $strReturnMessage = null)
    {
        $this
            ->setLngExcludedAddressID($lngExcludedAddressID)
            ->setLoginToken($loginToken)
            ->setStrReturnMessage($strReturnMessage);
    }
    /**
     * Get lngExcludedAddressID value
     * @return int
     */
    public function getLngExcludedAddressID()
    {
        return $this->lngExcludedAddressID;
    }
    /**
     * Set lngExcludedAddressID value
     * @param int $lngExcludedAddressID
     * @return \\NineDotMedia\Viapost\Struct\DeleteExcludedAddressByID
     */
    public function setLngExcludedAddressID($lngExcludedAddressID = null)
    {
        // validation for constraint: int
        if (!is_null($lngExcludedAddressID) && !(is_int($lngExcludedAddressID) || ctype_digit($lngExcludedAddressID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lngExcludedAddressID, true), gettype($lngExcludedAddressID)), __LINE__);
        }
        $this->lngExcludedAddressID = $lngExcludedAddressID;
        return $this;
    }
    /**
     * Get loginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->loginToken;
    }
    /**
     * Set loginToken value
     * @param string $loginToken
     * @return \\NineDotMedia\Viapost\Struct\DeleteExcludedAddressByID
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->loginToken = $loginToken;
        return $this;
    }
    /**
     * Get strReturnMessage value
     * @return string|null
     */
    public function getStrReturnMessage()
    {
        return $this->strReturnMessage;
    }
    /**
     * Set strReturnMessage value
     * @param string $strReturnMessage
     * @return \\NineDotMedia\Viapost\Struct\DeleteExcludedAddressByID
     */
    public function setStrReturnMessage($strReturnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($strReturnMessage) && !is_string($strReturnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($strReturnMessage, true), gettype($strReturnMessage)), __LINE__);
        }
        $this->strReturnMessage = $strReturnMessage;
        return $this;
    }
}
