<?php

namespace \NineDotMedia\Viapost\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CostCentre Struct
 * @subpackage Structs
 */
class CostCentre extends AbstractStructBase
{
    /**
     * The CostCentreId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CostCentreId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for CostCentre
     * @uses CostCentre::setCostCentreId()
     * @uses CostCentre::setDescription()
     * @param int $costCentreId
     * @param string $description
     */
    public function __construct($costCentreId = null, $description = null)
    {
        $this
            ->setCostCentreId($costCentreId)
            ->setDescription($description);
    }
    /**
     * Get CostCentreId value
     * @return int
     */
    public function getCostCentreId()
    {
        return $this->CostCentreId;
    }
    /**
     * Set CostCentreId value
     * @param int $costCentreId
     * @return \\NineDotMedia\Viapost\Struct\CostCentre
     */
    public function setCostCentreId($costCentreId = null)
    {
        // validation for constraint: int
        if (!is_null($costCentreId) && !(is_int($costCentreId) || ctype_digit($costCentreId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($costCentreId, true), gettype($costCentreId)), __LINE__);
        }
        $this->CostCentreId = $costCentreId;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \\NineDotMedia\Viapost\Struct\CostCentre
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
}
