<?php

namespace \NineDotMedia\Viapost\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalculateCostOfNewMailing Struct
 * @subpackage Structs
 */
class CalculateCostOfNewMailing extends AbstractStructBase
{
    /**
     * The documentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $documentType;
    /**
     * The pages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pages;
    /**
     * The colour
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $colour;
    /**
     * The simplex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $simplex;
    /**
     * The firstClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $firstClass;
    /**
     * The costOfMailing
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $costOfMailing;
    /**
     * The loginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginToken;
    /**
     * The insertsStr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $insertsStr;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for CalculateCostOfNewMailing
     * @uses CalculateCostOfNewMailing::setDocumentType()
     * @uses CalculateCostOfNewMailing::setPages()
     * @uses CalculateCostOfNewMailing::setColour()
     * @uses CalculateCostOfNewMailing::setSimplex()
     * @uses CalculateCostOfNewMailing::setFirstClass()
     * @uses CalculateCostOfNewMailing::setCostOfMailing()
     * @uses CalculateCostOfNewMailing::setLoginToken()
     * @uses CalculateCostOfNewMailing::setInsertsStr()
     * @uses CalculateCostOfNewMailing::setReturnMessage()
     * @param string $documentType
     * @param int $pages
     * @param bool $colour
     * @param bool $simplex
     * @param bool $firstClass
     * @param float $costOfMailing
     * @param string $loginToken
     * @param string $insertsStr
     * @param string $returnMessage
     */
    public function __construct($documentType = null, $pages = null, $colour = null, $simplex = null, $firstClass = null, $costOfMailing = null, $loginToken = null, $insertsStr = null, $returnMessage = null)
    {
        $this
            ->setDocumentType($documentType)
            ->setPages($pages)
            ->setColour($colour)
            ->setSimplex($simplex)
            ->setFirstClass($firstClass)
            ->setCostOfMailing($costOfMailing)
            ->setLoginToken($loginToken)
            ->setInsertsStr($insertsStr)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get documentType value
     * @return string
     */
    public function getDocumentType()
    {
        return $this->documentType;
    }
    /**
     * Set documentType value
     * @uses \\NineDotMedia\Viapost\Enum\DocumentType::valueIsValid()
     * @uses \\NineDotMedia\Viapost\Enum\DocumentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $documentType
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfNewMailing
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: enumeration
        if (!\\NineDotMedia\Viapost\Enum\DocumentType::valueIsValid($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \\NineDotMedia\Viapost\Enum\DocumentType', is_array($documentType) ? implode(', ', $documentType) : var_export($documentType, true), implode(', ', \\NineDotMedia\Viapost\Enum\DocumentType::getValidValues())), __LINE__);
        }
        $this->documentType = $documentType;
        return $this;
    }
    /**
     * Get pages value
     * @return int
     */
    public function getPages()
    {
        return $this->pages;
    }
    /**
     * Set pages value
     * @param int $pages
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfNewMailing
     */
    public function setPages($pages = null)
    {
        // validation for constraint: int
        if (!is_null($pages) && !(is_int($pages) || ctype_digit($pages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pages, true), gettype($pages)), __LINE__);
        }
        $this->pages = $pages;
        return $this;
    }
    /**
     * Get colour value
     * @return bool
     */
    public function getColour()
    {
        return $this->colour;
    }
    /**
     * Set colour value
     * @param bool $colour
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfNewMailing
     */
    public function setColour($colour = null)
    {
        // validation for constraint: boolean
        if (!is_null($colour) && !is_bool($colour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($colour, true), gettype($colour)), __LINE__);
        }
        $this->colour = $colour;
        return $this;
    }
    /**
     * Get simplex value
     * @return bool
     */
    public function getSimplex()
    {
        return $this->simplex;
    }
    /**
     * Set simplex value
     * @param bool $simplex
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfNewMailing
     */
    public function setSimplex($simplex = null)
    {
        // validation for constraint: boolean
        if (!is_null($simplex) && !is_bool($simplex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($simplex, true), gettype($simplex)), __LINE__);
        }
        $this->simplex = $simplex;
        return $this;
    }
    /**
     * Get firstClass value
     * @return bool
     */
    public function getFirstClass()
    {
        return $this->firstClass;
    }
    /**
     * Set firstClass value
     * @param bool $firstClass
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfNewMailing
     */
    public function setFirstClass($firstClass = null)
    {
        // validation for constraint: boolean
        if (!is_null($firstClass) && !is_bool($firstClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($firstClass, true), gettype($firstClass)), __LINE__);
        }
        $this->firstClass = $firstClass;
        return $this;
    }
    /**
     * Get costOfMailing value
     * @return float
     */
    public function getCostOfMailing()
    {
        return $this->costOfMailing;
    }
    /**
     * Set costOfMailing value
     * @param float $costOfMailing
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfNewMailing
     */
    public function setCostOfMailing($costOfMailing = null)
    {
        // validation for constraint: float
        if (!is_null($costOfMailing) && !(is_float($costOfMailing) || is_numeric($costOfMailing))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($costOfMailing, true), gettype($costOfMailing)), __LINE__);
        }
        $this->costOfMailing = $costOfMailing;
        return $this;
    }
    /**
     * Get loginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->loginToken;
    }
    /**
     * Set loginToken value
     * @param string $loginToken
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfNewMailing
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->loginToken = $loginToken;
        return $this;
    }
    /**
     * Get insertsStr value
     * @return string|null
     */
    public function getInsertsStr()
    {
        return $this->insertsStr;
    }
    /**
     * Set insertsStr value
     * @param string $insertsStr
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfNewMailing
     */
    public function setInsertsStr($insertsStr = null)
    {
        // validation for constraint: string
        if (!is_null($insertsStr) && !is_string($insertsStr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insertsStr, true), gettype($insertsStr)), __LINE__);
        }
        $this->insertsStr = $insertsStr;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfNewMailing
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
