<?php

namespace \NineDotMedia\Viapost\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalculateCostOfMailing Struct
 * @subpackage Structs
 */
class CalculateCostOfMailing extends AbstractStructBase
{
    /**
     * The documentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $documentType;
    /**
     * The documentID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $documentID;
    /**
     * The colour
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $colour;
    /**
     * The simplex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $simplex;
    /**
     * The mailingListID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $mailingListID;
    /**
     * The costOfMailing
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $costOfMailing;
    /**
     * The numberOfPages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $numberOfPages;
    /**
     * The numberOfSheets
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $numberOfSheets;
    /**
     * The loginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginToken;
    /**
     * The firstClassStr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $firstClassStr;
    /**
     * The insertsStr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $insertsStr;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for CalculateCostOfMailing
     * @uses CalculateCostOfMailing::setDocumentType()
     * @uses CalculateCostOfMailing::setDocumentID()
     * @uses CalculateCostOfMailing::setColour()
     * @uses CalculateCostOfMailing::setSimplex()
     * @uses CalculateCostOfMailing::setMailingListID()
     * @uses CalculateCostOfMailing::setCostOfMailing()
     * @uses CalculateCostOfMailing::setNumberOfPages()
     * @uses CalculateCostOfMailing::setNumberOfSheets()
     * @uses CalculateCostOfMailing::setLoginToken()
     * @uses CalculateCostOfMailing::setFirstClassStr()
     * @uses CalculateCostOfMailing::setInsertsStr()
     * @uses CalculateCostOfMailing::setReturnMessage()
     * @param string $documentType
     * @param int $documentID
     * @param bool $colour
     * @param bool $simplex
     * @param int $mailingListID
     * @param float $costOfMailing
     * @param int $numberOfPages
     * @param int $numberOfSheets
     * @param string $loginToken
     * @param string $firstClassStr
     * @param string $insertsStr
     * @param string $returnMessage
     */
    public function __construct($documentType = null, $documentID = null, $colour = null, $simplex = null, $mailingListID = null, $costOfMailing = null, $numberOfPages = null, $numberOfSheets = null, $loginToken = null, $firstClassStr = null, $insertsStr = null, $returnMessage = null)
    {
        $this
            ->setDocumentType($documentType)
            ->setDocumentID($documentID)
            ->setColour($colour)
            ->setSimplex($simplex)
            ->setMailingListID($mailingListID)
            ->setCostOfMailing($costOfMailing)
            ->setNumberOfPages($numberOfPages)
            ->setNumberOfSheets($numberOfSheets)
            ->setLoginToken($loginToken)
            ->setFirstClassStr($firstClassStr)
            ->setInsertsStr($insertsStr)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get documentType value
     * @return string
     */
    public function getDocumentType()
    {
        return $this->documentType;
    }
    /**
     * Set documentType value
     * @uses \\NineDotMedia\Viapost\Enum\DocumentType::valueIsValid()
     * @uses \\NineDotMedia\Viapost\Enum\DocumentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $documentType
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfMailing
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: enumeration
        if (!\\NineDotMedia\Viapost\Enum\DocumentType::valueIsValid($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \\NineDotMedia\Viapost\Enum\DocumentType', is_array($documentType) ? implode(', ', $documentType) : var_export($documentType, true), implode(', ', \\NineDotMedia\Viapost\Enum\DocumentType::getValidValues())), __LINE__);
        }
        $this->documentType = $documentType;
        return $this;
    }
    /**
     * Get documentID value
     * @return int
     */
    public function getDocumentID()
    {
        return $this->documentID;
    }
    /**
     * Set documentID value
     * @param int $documentID
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfMailing
     */
    public function setDocumentID($documentID = null)
    {
        // validation for constraint: int
        if (!is_null($documentID) && !(is_int($documentID) || ctype_digit($documentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentID, true), gettype($documentID)), __LINE__);
        }
        $this->documentID = $documentID;
        return $this;
    }
    /**
     * Get colour value
     * @return bool
     */
    public function getColour()
    {
        return $this->colour;
    }
    /**
     * Set colour value
     * @param bool $colour
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfMailing
     */
    public function setColour($colour = null)
    {
        // validation for constraint: boolean
        if (!is_null($colour) && !is_bool($colour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($colour, true), gettype($colour)), __LINE__);
        }
        $this->colour = $colour;
        return $this;
    }
    /**
     * Get simplex value
     * @return bool
     */
    public function getSimplex()
    {
        return $this->simplex;
    }
    /**
     * Set simplex value
     * @param bool $simplex
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfMailing
     */
    public function setSimplex($simplex = null)
    {
        // validation for constraint: boolean
        if (!is_null($simplex) && !is_bool($simplex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($simplex, true), gettype($simplex)), __LINE__);
        }
        $this->simplex = $simplex;
        return $this;
    }
    /**
     * Get mailingListID value
     * @return int
     */
    public function getMailingListID()
    {
        return $this->mailingListID;
    }
    /**
     * Set mailingListID value
     * @param int $mailingListID
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfMailing
     */
    public function setMailingListID($mailingListID = null)
    {
        // validation for constraint: int
        if (!is_null($mailingListID) && !(is_int($mailingListID) || ctype_digit($mailingListID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mailingListID, true), gettype($mailingListID)), __LINE__);
        }
        $this->mailingListID = $mailingListID;
        return $this;
    }
    /**
     * Get costOfMailing value
     * @return float
     */
    public function getCostOfMailing()
    {
        return $this->costOfMailing;
    }
    /**
     * Set costOfMailing value
     * @param float $costOfMailing
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfMailing
     */
    public function setCostOfMailing($costOfMailing = null)
    {
        // validation for constraint: float
        if (!is_null($costOfMailing) && !(is_float($costOfMailing) || is_numeric($costOfMailing))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($costOfMailing, true), gettype($costOfMailing)), __LINE__);
        }
        $this->costOfMailing = $costOfMailing;
        return $this;
    }
    /**
     * Get numberOfPages value
     * @return int
     */
    public function getNumberOfPages()
    {
        return $this->numberOfPages;
    }
    /**
     * Set numberOfPages value
     * @param int $numberOfPages
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfMailing
     */
    public function setNumberOfPages($numberOfPages = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfPages) && !(is_int($numberOfPages) || ctype_digit($numberOfPages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfPages, true), gettype($numberOfPages)), __LINE__);
        }
        $this->numberOfPages = $numberOfPages;
        return $this;
    }
    /**
     * Get numberOfSheets value
     * @return int
     */
    public function getNumberOfSheets()
    {
        return $this->numberOfSheets;
    }
    /**
     * Set numberOfSheets value
     * @param int $numberOfSheets
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfMailing
     */
    public function setNumberOfSheets($numberOfSheets = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfSheets) && !(is_int($numberOfSheets) || ctype_digit($numberOfSheets))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfSheets, true), gettype($numberOfSheets)), __LINE__);
        }
        $this->numberOfSheets = $numberOfSheets;
        return $this;
    }
    /**
     * Get loginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->loginToken;
    }
    /**
     * Set loginToken value
     * @param string $loginToken
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfMailing
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->loginToken = $loginToken;
        return $this;
    }
    /**
     * Get firstClassStr value
     * @return string|null
     */
    public function getFirstClassStr()
    {
        return $this->firstClassStr;
    }
    /**
     * Set firstClassStr value
     * @param string $firstClassStr
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfMailing
     */
    public function setFirstClassStr($firstClassStr = null)
    {
        // validation for constraint: string
        if (!is_null($firstClassStr) && !is_string($firstClassStr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstClassStr, true), gettype($firstClassStr)), __LINE__);
        }
        $this->firstClassStr = $firstClassStr;
        return $this;
    }
    /**
     * Get insertsStr value
     * @return string|null
     */
    public function getInsertsStr()
    {
        return $this->insertsStr;
    }
    /**
     * Set insertsStr value
     * @param string $insertsStr
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfMailing
     */
    public function setInsertsStr($insertsStr = null)
    {
        // validation for constraint: string
        if (!is_null($insertsStr) && !is_string($insertsStr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insertsStr, true), gettype($insertsStr)), __LINE__);
        }
        $this->insertsStr = $insertsStr;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfMailing
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
