<?php

namespace \NineDotMedia\Viapost\Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for all operations
 * @subpackage Services
 */
class Service extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetSystemID
     * Meta information extracted from the WSDL
     * - documentation: Return a string containing the system identifier.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetSystemID $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetSystemIDResponse|bool
     */
    public function GetSystemID(\\NineDotMedia\Viapost\Struct\GetSystemID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSystemID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateLetterFromXPS
     * Meta information extracted from the WSDL
     * - documentation: Use this method to upload a new Letter in XPS format. Letters can be used either in a Mail Pack or in a Simple Mailing.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\CreateLetterFromXPS $parameters
     * @return \\NineDotMedia\Viapost\Struct\CreateLetterFromXPSResponse|bool
     */
    public function CreateLetterFromXPS(\\NineDotMedia\Viapost\Struct\CreateLetterFromXPS $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateLetterFromXPS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDocumentPageCountRange
     * Meta information extracted from the WSDL
     * - documentation: Returns the minimum and maximum number of pages for a given document type.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetDocumentPageCountRange $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetDocumentPageCountRangeResponse|bool
     */
    public function GetDocumentPageCountRange(\\NineDotMedia\Viapost\Struct\GetDocumentPageCountRange $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDocumentPageCountRange($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendDriverMailingConfirmation
     * Meta information extracted from the WSDL
     * - documentation: Internal use only.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\SendDriverMailingConfirmation $parameters
     * @return \\NineDotMedia\Viapost\Struct\SendDriverMailingConfirmationResponse|bool
     */
    public function SendDriverMailingConfirmation(\\NineDotMedia\Viapost\Struct\SendDriverMailingConfirmation $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendDriverMailingConfirmation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLibraryInserts
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of the user's available inserts.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetLibraryInserts $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetLibraryInsertsResponse|bool
     */
    public function GetLibraryInserts(\\NineDotMedia\Viapost\Struct\GetLibraryInserts $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLibraryInserts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCostCentres
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of the cost centres defined for this user/customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetCostCentres $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetCostCentresResponse|bool
     */
    public function GetCostCentres(\\NineDotMedia\Viapost\Struct\GetCostCentres $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCostCentres($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GenerateMappingWithDefaultNameAndMergeFields
     * Meta information extracted from the WSDL
     * - documentation: Generate an XML Mapping for a Mailing List and specify a default name and merge fields.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GenerateMappingWithDefaultNameAndMergeFields $parameters
     * @return \\NineDotMedia\Viapost\Struct\GenerateMappingWithDefaultNameAndMergeFieldsResponse|bool
     */
    public function GenerateMappingWithDefaultNameAndMergeFields(\\NineDotMedia\Viapost\Struct\GenerateMappingWithDefaultNameAndMergeFields $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GenerateMappingWithDefaultNameAndMergeFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GenerateMappingWithID
     * Meta information extracted from the WSDL
     * - documentation: Generate an XML Mapping for a Mailing List and get the ID.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GenerateMappingWithID $parameters
     * @return \\NineDotMedia\Viapost\Struct\GenerateMappingWithIDResponse|bool
     */
    public function GenerateMappingWithID(\\NineDotMedia\Viapost\Struct\GenerateMappingWithID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GenerateMappingWithID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GenerateMappingWithDefaultNameWithID
     * Meta information extracted from the WSDL
     * - documentation: Generate an XML Mapping for a Mailing List and specify a default name and get the ID.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GenerateMappingWithDefaultNameWithID $parameters
     * @return \\NineDotMedia\Viapost\Struct\GenerateMappingWithDefaultNameWithIDResponse|bool
     */
    public function GenerateMappingWithDefaultNameWithID(\\NineDotMedia\Viapost\Struct\GenerateMappingWithDefaultNameWithID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GenerateMappingWithDefaultNameWithID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GenerateMappingWithDefaultNameAndMergeFieldsWithID
     * Meta information extracted from the WSDL
     * - documentation: Generate an XML Mapping for a Mailing List and specify a default name and merge fields and get the ID.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GenerateMappingWithDefaultNameAndMergeFieldsWithID $parameters
     * @return \\NineDotMedia\Viapost\Struct\GenerateMappingWithDefaultNameAndMergeFieldsWithIDResponse|bool
     */
    public function GenerateMappingWithDefaultNameAndMergeFieldsWithID(\\NineDotMedia\Viapost\Struct\GenerateMappingWithDefaultNameAndMergeFieldsWithID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GenerateMappingWithDefaultNameAndMergeFieldsWithID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateAttachment
     * Meta information extracted from the WSDL
     * - documentation: Use this method to upload a PDF attachment which can be attached to a letter when creating a Mail Pack. A number of attachments can be added to a Mail Pack. The attachmentID can be referenced for use with Mail Packs.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\CreateAttachment $parameters
     * @return \\NineDotMedia\Viapost\Struct\CreateAttachmentResponse|bool
     */
    public function CreateAttachment(\\NineDotMedia\Viapost\Struct\CreateAttachment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAttachment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateLetterhead
     * Meta information extracted from the WSDL
     * - documentation: Use this method to upload a new Letterhead in PDF format. Letterheads can be used in Mail Packs either on the first page or every page in the Pack. The letterheadID can be referenced for use with Mail Packs.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\CreateLetterhead $parameters
     * @return \\NineDotMedia\Viapost\Struct\CreateLetterheadResponse|bool
     */
    public function CreateLetterhead(\\NineDotMedia\Viapost\Struct\CreateLetterhead $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateLetterhead($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateLetter
     * Meta information extracted from the WSDL
     * - documentation: Use this method to upload a new Letter in either PDF or Word XML (.xml) format. Letters can be used either in a Mail Pack or in a Simple Mailing. Document's uploaded in Word XML (.xml) format can contain Merge Fields which will be
     * replaced when the Mailing is run. The letterID can be referenced for use with Mail Packs or Simple Mailings.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\CreateLetter $parameters
     * @return \\NineDotMedia\Viapost\Struct\CreateLetterResponse|bool
     */
    public function CreateLetter(\\NineDotMedia\Viapost\Struct\CreateLetter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateLetter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateMailPack
     * Meta information extracted from the WSDL
     * - documentation: Use this method to Create a Mail Pack, a letterID must be supplied while both attachmentIDs and letterheadID are optional. A Mail Pack will be created which can then be sent to a single address or an address list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\CreateMailPack $parameters
     * @return \\NineDotMedia\Viapost\Struct\CreateMailPackResponse|bool
     */
    public function CreateMailPack(\\NineDotMedia\Viapost\Struct\CreateMailPack $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateMailPack($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteMailPack
     * Meta information extracted from the WSDL
     * - documentation: Use this method to delete a Mail Pack using it's unique ID. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The mailPackID you supply will be used to delete your Mail Pack. This method
     * returns True if successful or False if a problem occurred. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\DeleteMailPack $parameters
     * @return \\NineDotMedia\Viapost\Struct\DeleteMailPackResponse|bool
     */
    public function DeleteMailPack(\\NineDotMedia\Viapost\Struct\DeleteMailPack $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteMailPack($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendMailPack
     * Meta information extracted from the WSDL
     * - documentation: Use this method to send a previously saved Mail Pack.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\SendMailPack $parameters
     * @return \\NineDotMedia\Viapost\Struct\SendMailPackResponse|bool
     */
    public function SendMailPack(\\NineDotMedia\Viapost\Struct\SendMailPack $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendMailPack($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendMailPackToFindNearest
     * Meta information extracted from the WSDL
     * - documentation: Use this method to send a previously saved Mail Pack to a Mailing list created from Find Nearest.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\SendMailPackToFindNearest $parameters
     * @return \\NineDotMedia\Viapost\Struct\SendMailPackToFindNearestResponse|bool
     */
    public function SendMailPackToFindNearest(\\NineDotMedia\Viapost\Struct\SendMailPackToFindNearest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendMailPackToFindNearest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateAndSendMailPack
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create and send a Mail Pack to a Mailing List. This will require a letterID from a previously uploaded letter, attachmentsID's and letterheadID are optional.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\CreateAndSendMailPack $parameters
     * @return \\NineDotMedia\Viapost\Struct\CreateAndSendMailPackResponse|bool
     */
    public function CreateAndSendMailPack(\\NineDotMedia\Viapost\Struct\CreateAndSendMailPack $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAndSendMailPack($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendMailPackToSingleAddress2
     * Meta information extracted from the WSDL
     * - documentation: Use this method to send a Mail Pack a previously saved MailPack to a Single Address. This will require a Mail Pack ID and single address details. This method is used by the ViaPost Spooler software. SendMailPackToSingleAddress should
     * be used for any API integration.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\SendMailPackToSingleAddress2 $parameters
     * @return \\NineDotMedia\Viapost\Struct\SendMailPackToSingleAddress2Response|bool
     */
    public function SendMailPackToSingleAddress2(\\NineDotMedia\Viapost\Struct\SendMailPackToSingleAddress2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendMailPackToSingleAddress2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendMailPackToSingleAddress
     * Meta information extracted from the WSDL
     * - documentation: Use this method to send a Mail Pack a previously saved MailPack to a Single Address. This will require a Mail Pack ID and single address details.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\SendMailPackToSingleAddress $parameters
     * @return \\NineDotMedia\Viapost\Struct\SendMailPackToSingleAddressResponse|bool
     */
    public function SendMailPackToSingleAddress(\\NineDotMedia\Viapost\Struct\SendMailPackToSingleAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendMailPackToSingleAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * CreateAndSendMailPackToSingleAddress
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create and send a Mail Pack to a Single Address. This will require a letterID from a previously uploaded letter, attachmentsID's and letterheadID are optional.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\CreateAndSendMailPackToSingleAddress $parameters
     * @return \\NineDotMedia\Viapost\Struct\CreateAndSendMailPackToSingleAddressResponse|bool
     */
    public function CreateAndSendMailPackToSingleAddress(\\NineDotMedia\Viapost\Struct\CreateAndSendMailPackToSingleAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAndSendMailPackToSingleAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendSimpleMailing
     * Meta information extracted from the WSDL
     * - documentation: Use this method to send a Simple Mailing. A simple mailing consists of a previosly uploaded letter and an address list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\SendSimpleMailing $parameters
     * @return \\NineDotMedia\Viapost\Struct\SendSimpleMailingResponse|bool
     */
    public function SendSimpleMailing(\\NineDotMedia\Viapost\Struct\SendSimpleMailing $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendSimpleMailing($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendSimpleMailingToFindNearest
     * Meta information extracted from the WSDL
     * - documentation: Use this method to send a Simple Mailing to a Mailing list created from Find Nearest. A simple mailing consists of a previosly uploaded letter and address details for a Find Nearest search.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\SendSimpleMailingToFindNearest $parameters
     * @return \\NineDotMedia\Viapost\Struct\SendSimpleMailingToFindNearestResponse|bool
     */
    public function SendSimpleMailingToFindNearest(\\NineDotMedia\Viapost\Struct\SendSimpleMailingToFindNearest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendSimpleMailingToFindNearest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * CreateAndSendSimpleMailingToFindNearest
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create and send a Simple Mailing to a Mailing list created from Find Nearest. A letter in either PDF or Word XML (.xml) must be supplied with addess details for the Find Nearest search.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\CreateAndSendSimpleMailingToFindNearest $parameters
     * @return \\NineDotMedia\Viapost\Struct\CreateAndSendSimpleMailingToFindNearestResponse|bool
     */
    public function CreateAndSendSimpleMailingToFindNearest(\\NineDotMedia\Viapost\Struct\CreateAndSendSimpleMailingToFindNearest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAndSendSimpleMailingToFindNearest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendSimpleMailingToSingleAddress
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create and send a Simple Mailing to a Single Address. A letter in either PDF or Word XML (.xml) must be supplied with the single address details.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\SendSimpleMailingToSingleAddress $parameters
     * @return \\NineDotMedia\Viapost\Struct\SendSimpleMailingToSingleAddressResponse|bool
     */
    public function SendSimpleMailingToSingleAddress(\\NineDotMedia\Viapost\Struct\SendSimpleMailingToSingleAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendSimpleMailingToSingleAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateAndSendSimpleMailing
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create and send a Simple Mailing. A letter in either PDF or Word XML (.xml) must be supplied with a mailinglistID from a previously uploaded mailing list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\CreateAndSendSimpleMailing $parameters
     * @return \\NineDotMedia\Viapost\Struct\CreateAndSendSimpleMailingResponse|bool
     */
    public function CreateAndSendSimpleMailing(\\NineDotMedia\Viapost\Struct\CreateAndSendSimpleMailing $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAndSendSimpleMailing($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * CreateAndSendSimpleMailingToSingleAddress
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create and send a Simple Mailing to a single address. A letter in either PDF or Word XML (.xml) must be supplied with the single address details.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\CreateAndSendSimpleMailingToSingleAddress $parameters
     * @return \\NineDotMedia\Viapost\Struct\CreateAndSendSimpleMailingToSingleAddressResponse|bool
     */
    public function CreateAndSendSimpleMailingToSingleAddress(\\NineDotMedia\Viapost\Struct\CreateAndSendSimpleMailingToSingleAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAndSendSimpleMailingToSingleAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateAndSendMailPackToFindNearest
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create and send a Mail Pack to a Mailing list created from Find Nearest. This will require a letterID from a previously uploaded letter, attachmentsID's and letterheadID are optional.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\CreateAndSendMailPackToFindNearest $parameters
     * @return \\NineDotMedia\Viapost\Struct\CreateAndSendMailPackToFindNearestResponse|bool
     */
    public function CreateAndSendMailPackToFindNearest(\\NineDotMedia\Viapost\Struct\CreateAndSendMailPackToFindNearest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAndSendMailPackToFindNearest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddExcludedAddress
     * Meta information extracted from the WSDL
     * - documentation: Use this method to add an excluded address at either a list, user or company level. For lists you should enter the mailinglistID. Otherwise this should be 0.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\AddExcludedAddress $parameters
     * @return \\NineDotMedia\Viapost\Struct\AddExcludedAddressResponse|bool
     */
    public function AddExcludedAddress(\\NineDotMedia\Viapost\Struct\AddExcludedAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddExcludedAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetExcludedAddresses
     * Meta information extracted from the WSDL
     * - documentation: Use this method to get a list of your excluded address which are currently in use.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetExcludedAddresses $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetExcludedAddressesResponse|bool
     */
    public function GetExcludedAddresses(\\NineDotMedia\Viapost\Struct\GetExcludedAddresses $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetExcludedAddresses($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteExcludedAddressByID
     * Meta information extracted from the WSDL
     * - documentation: Use this method to get a delete an excluded address - you can get the ID by using the GetExcludedAddresses method
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\DeleteExcludedAddressByID $parameters
     * @return \\NineDotMedia\Viapost\Struct\DeleteExcludedAddressByIDResponse|bool
     */
    public function DeleteExcludedAddressByID(\\NineDotMedia\Viapost\Struct\DeleteExcludedAddressByID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteExcludedAddressByID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FindNearestQueryAddress
     * Meta information extracted from the WSDL
     * - documentation: Use this method to query a FindNearest search. This method will not create a Find Nearest list but will return the cost of the list including how many addresses were found. Use the FindNearestExecuteSearch method to create a mailing
     * list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\FindNearestQueryAddress $parameters
     * @return \\NineDotMedia\Viapost\Struct\FindNearestQueryAddressResponse|bool
     */
    public function FindNearestQueryAddress(\\NineDotMedia\Viapost\Struct\FindNearestQueryAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FindNearestQueryAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FindNearestExecuteSearch
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create a FindNearest List. The resulting list will contain all addresses within a radius or range surrounding the search address provided. This list can then be used when sending Simple Mailings or Mail Packs.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\FindNearestExecuteSearch $parameters
     * @return \\NineDotMedia\Viapost\Struct\FindNearestExecuteSearchResponse|bool
     */
    public function FindNearestExecuteSearch(\\NineDotMedia\Viapost\Struct\FindNearestExecuteSearch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FindNearestExecuteSearch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateLetter
     * Meta information extracted from the WSDL
     * - documentation: Use this method to edit an existing letter. The new ID will be returned and all references to the letter will be updated.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\UpdateLetter $parameters
     * @return \\NineDotMedia\Viapost\Struct\UpdateLetterResponse|bool
     */
    public function UpdateLetter(\\NineDotMedia\Viapost\Struct\UpdateLetter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateLetter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateMailPackLetter
     * Meta information extracted from the WSDL
     * - documentation: Use this method to update a Mail Pack to refer to a different letter.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\UpdateMailPackLetter $parameters
     * @return \\NineDotMedia\Viapost\Struct\UpdateMailPackLetterResponse|bool
     */
    public function UpdateMailPackLetter(\\NineDotMedia\Viapost\Struct\UpdateMailPackLetter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateMailPackLetter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateMailPackTemplate
     * Meta information extracted from the WSDL
     * - documentation: Use this method to update a Mail Pack to refer to a different template.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\UpdateMailPackTemplate $parameters
     * @return \\NineDotMedia\Viapost\Struct\UpdateMailPackTemplateResponse|bool
     */
    public function UpdateMailPackTemplate(\\NineDotMedia\Viapost\Struct\UpdateMailPackTemplate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateMailPackTemplate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMailPacks
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Use this method to get a list of available MailPacks. The list is returned as a pipe-delimited string with the newest MailPacks first.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetMailPacks $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetMailPacksResponse|bool
     */
    public function GetMailPacks(\\NineDotMedia\Viapost\Struct\GetMailPacks $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMailPacks($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLibraryMailPacks
     * Meta information extracted from the WSDL
     * - documentation: Use this method to get a list of available MailPacks. An array of MailPack objects is returned with the newest MailPacks first.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetLibraryMailPacks $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetLibraryMailPacksResponse|bool
     */
    public function GetLibraryMailPacks(\\NineDotMedia\Viapost\Struct\GetLibraryMailPacks $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLibraryMailPacks($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreatePostcard
     * Meta information extracted from the WSDL
     * - documentation: Use this method to upload a new A5 landscape postcard in PDF format. A postcard can be defined by two pages in a single PDF or the first page of two PDFs.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\CreatePostcard $parameters
     * @return \\NineDotMedia\Viapost\Struct\CreatePostcardResponse|bool
     */
    public function CreatePostcard(\\NineDotMedia\Viapost\Struct\CreatePostcard $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreatePostcard($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLibraryPostcards
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of the user's postcards that have been uploaded via the portal or the CreatePostcard API method.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetLibraryPostcards $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetLibraryPostcardsResponse|bool
     */
    public function GetLibraryPostcards(\\NineDotMedia\Viapost\Struct\GetLibraryPostcards $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLibraryPostcards($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PreviewLibraryPostcard
     * Meta information extracted from the WSDL
     * - documentation: Gets a byte array that is the postcard which was uploaded via the portal or the CreatePostcard API method.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\PreviewLibraryPostcard $parameters
     * @return \\NineDotMedia\Viapost\Struct\PreviewLibraryPostcardResponse|bool
     */
    public function PreviewLibraryPostcard(\\NineDotMedia\Viapost\Struct\PreviewLibraryPostcard $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PreviewLibraryPostcard($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendPostcardToSingleAddress
     * Meta information extracted from the WSDL
     * - documentation: Use this method to send an existing postcard to a single address.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\SendPostcardToSingleAddress $parameters
     * @return \\NineDotMedia\Viapost\Struct\SendPostcardToSingleAddressResponse|bool
     */
    public function SendPostcardToSingleAddress(\\NineDotMedia\Viapost\Struct\SendPostcardToSingleAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendPostcardToSingleAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendPostcard
     * Meta information extracted from the WSDL
     * - documentation: Use this method to send an existing postcard to a mailing list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\SendPostcard $parameters
     * @return \\NineDotMedia\Viapost\Struct\SendPostcardResponse|bool
     */
    public function SendPostcard(\\NineDotMedia\Viapost\Struct\SendPostcard $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendPostcard($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendPostcardToFindNearest
     * Meta information extracted from the WSDL
     * - documentation: Use this method to send an existing postcard to a mailing list created from a find nearest request.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\SendPostcardToFindNearest $parameters
     * @return \\NineDotMedia\Viapost\Struct\SendPostcardToFindNearestResponse|bool
     */
    public function SendPostcardToFindNearest(\\NineDotMedia\Viapost\Struct\SendPostcardToFindNearest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendPostcardToFindNearest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * CreateAndSendPostcardToSingleAddress
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create and send a postcard to a single address. An A5 landscape postcard in PDF format must be supplied with the single address details.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\CreateAndSendPostcardToSingleAddress $parameters
     * @return \\NineDotMedia\Viapost\Struct\CreateAndSendPostcardToSingleAddressResponse|bool
     */
    public function CreateAndSendPostcardToSingleAddress(\\NineDotMedia\Viapost\Struct\CreateAndSendPostcardToSingleAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAndSendPostcardToSingleAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateAndSendPostcard
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create and send a postcard to a mailing list. An A5 landscape postcard in PDF format must be supplied with the mailing list ID.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\CreateAndSendPostcard $parameters
     * @return \\NineDotMedia\Viapost\Struct\CreateAndSendPostcardResponse|bool
     */
    public function CreateAndSendPostcard(\\NineDotMedia\Viapost\Struct\CreateAndSendPostcard $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAndSendPostcard($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateAndSendPostcardToFindNearest
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create and send a postcard to a mailing list created from a find nearest request. An A5 landscape postcard in PDF format must be supplied with the find nearest request details.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\CreateAndSendPostcardToFindNearest $parameters
     * @return \\NineDotMedia\Viapost\Struct\CreateAndSendPostcardToFindNearestResponse|bool
     */
    public function CreateAndSendPostcardToFindNearest(\\NineDotMedia\Viapost\Struct\CreateAndSendPostcardToFindNearest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAndSendPostcardToFindNearest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * CalculateCostOfSingleAddressMailing
     * Meta information extracted from the WSDL
     * - documentation: Use this method to calculate the cost of sending a letter (simple mailing), Mail Pack or postcard to a single address.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\CalculateCostOfSingleAddressMailing $parameters
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfSingleAddressMailingResponse|bool
     */
    public function CalculateCostOfSingleAddressMailing(\\NineDotMedia\Viapost\Struct\CalculateCostOfSingleAddressMailing $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateCostOfSingleAddressMailing($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CalculateCostOfMailing
     * Meta information extracted from the WSDL
     * - documentation: Use this method to calculate the cost of sending a letter (simple mailing), Mail Pack or postcard to a mailing list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\CalculateCostOfMailing $parameters
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfMailingResponse|bool
     */
    public function CalculateCostOfMailing(\\NineDotMedia\Viapost\Struct\CalculateCostOfMailing $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateCostOfMailing($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CalculateCostOfFindNearestMailing
     * Meta information extracted from the WSDL
     * - documentation: Use this method to calculate the cost of sending a letter (simple mailing), Mail Pack or postcard to a mailing list created from a find nearest request.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\CalculateCostOfFindNearestMailing $parameters
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfFindNearestMailingResponse|bool
     */
    public function CalculateCostOfFindNearestMailing(\\NineDotMedia\Viapost\Struct\CalculateCostOfFindNearestMailing $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateCostOfFindNearestMailing($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLibraryLetterheads
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of the user's letterheads that have been uploaded via the portal or the CreateLetterhead API method.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetLibraryLetterheads $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetLibraryLetterheadsResponse|bool
     */
    public function GetLibraryLetterheads(\\NineDotMedia\Viapost\Struct\GetLibraryLetterheads $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLibraryLetterheads($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLibraryAttachments
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of the user's attachments that have been uploaded via the portal or the CreateAttachment API method.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetLibraryAttachments $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetLibraryAttachmentsResponse|bool
     */
    public function GetLibraryAttachments(\\NineDotMedia\Viapost\Struct\GetLibraryAttachments $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLibraryAttachments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PreviewLibraryLetterhead
     * Meta information extracted from the WSDL
     * - documentation: Gets a byte array that is the letterhead which was uploaded via the portal or the CreateLetterhead API method.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\PreviewLibraryLetterhead $parameters
     * @return \\NineDotMedia\Viapost\Struct\PreviewLibraryLetterheadResponse|bool
     */
    public function PreviewLibraryLetterhead(\\NineDotMedia\Viapost\Struct\PreviewLibraryLetterhead $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PreviewLibraryLetterhead($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PreviewLibraryAttachment
     * Meta information extracted from the WSDL
     * - documentation: Gets a byte array that is the attachment which was uploaded via the portal or the CreateAttachment API method.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\PreviewLibraryAttachment $parameters
     * @return \\NineDotMedia\Viapost\Struct\PreviewLibraryAttachmentResponse|bool
     */
    public function PreviewLibraryAttachment(\\NineDotMedia\Viapost\Struct\PreviewLibraryAttachment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PreviewLibraryAttachment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PreviewDocumentSingleAddress
     * Meta information extracted from the WSDL
     * - documentation: Gets a byte array that represents the finalized document to be sent to a single address.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\PreviewDocumentSingleAddress $parameters
     * @return \\NineDotMedia\Viapost\Struct\PreviewDocumentSingleAddressResponse|bool
     */
    public function PreviewDocumentSingleAddress(\\NineDotMedia\Viapost\Struct\PreviewDocumentSingleAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PreviewDocumentSingleAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PreviewDocumentMailingList
     * Meta information extracted from the WSDL
     * - documentation: Gets a byte array that represents the finalized document to be sent to a mailing list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\PreviewDocumentMailingList $parameters
     * @return \\NineDotMedia\Viapost\Struct\PreviewDocumentMailingListResponse|bool
     */
    public function PreviewDocumentMailingList(\\NineDotMedia\Viapost\Struct\PreviewDocumentMailingList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PreviewDocumentMailingList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PreviewDocumentFindNearest
     * Meta information extracted from the WSDL
     * - documentation: Gets a byte array that represents the finalized document to be sent to a mailing list created from a find nearest request.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\PreviewDocumentFindNearest $parameters
     * @return \\NineDotMedia\Viapost\Struct\PreviewDocumentFindNearestResponse|bool
     */
    public function PreviewDocumentFindNearest(\\NineDotMedia\Viapost\Struct\PreviewDocumentFindNearest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PreviewDocumentFindNearest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLibraryMappings
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of the user's address list mappings that have been uploaded via the portal or the various GenerateMapping API methods.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetLibraryMappings $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetLibraryMappingsResponse|bool
     */
    public function GetLibraryMappings(\\NineDotMedia\Viapost\Struct\GetLibraryMappings $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLibraryMappings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDataListUrl
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve the URL of a specified data list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetDataListUrl $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetDataListUrlResponse|bool
     */
    public function GetDataListUrl(\\NineDotMedia\Viapost\Struct\GetDataListUrl $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDataListUrl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DownloadDataList
     * Meta information extracted from the WSDL
     * - documentation: Use this method to download a specified data list as a CSV file. Note that not all data lists are permitted to be downloaded.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\DownloadDataList $parameters
     * @return \\NineDotMedia\Viapost\Struct\DownloadDataListResponse|bool
     */
    public function DownloadDataList(\\NineDotMedia\Viapost\Struct\DownloadDataList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DownloadDataList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDataLists
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of the user's data lists.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetDataLists $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetDataListsResponse|bool
     */
    public function GetDataLists(\\NineDotMedia\Viapost\Struct\GetDataLists $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDataLists($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CalculateCostOfDataList
     * Meta information extracted from the WSDL
     * - documentation: Use this method to calculate the cost of purchasing a data list containing a given number of items.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\CalculateCostOfDataList $parameters
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfDataListResponse|bool
     */
    public function CalculateCostOfDataList(\\NineDotMedia\Viapost\Struct\CalculateCostOfDataList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateCostOfDataList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserVariables
     * Meta information extracted from the WSDL
     * - documentation: This method returns a list of variables, similar to the functionality of the Merge Fields page within the Portal. The variable name and value are returned.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetUserVariables $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetUserVariablesResponse|bool
     */
    public function GetUserVariables(\\NineDotMedia\Viapost\Struct\GetUserVariables $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUserVariables($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDocumentation
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of documentation urls such as the letter guidance template. A description and url is returned for each url.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetDocumentation $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetDocumentationResponse|bool
     */
    public function GetDocumentation(\\NineDotMedia\Viapost\Struct\GetDocumentation $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDocumentation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMailHistoryJobs
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of jobs. The method returns similar data to the Mail History page within the Portal.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetMailHistoryJobs $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetMailHistoryJobsResponse|bool
     */
    public function GetMailHistoryJobs(\\NineDotMedia\Viapost\Struct\GetMailHistoryJobs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMailHistoryJobs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMailHistoryDocumentsByJobId
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of documents for a particular job. The method returns similar data to the page that is displayed within the Portal when you click on a particular job and it lists the documents.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetMailHistoryDocumentsByJobId $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetMailHistoryDocumentsByJobIdResponse|bool
     */
    public function GetMailHistoryDocumentsByJobId(\\NineDotMedia\Viapost\Struct\GetMailHistoryDocumentsByJobId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMailHistoryDocumentsByJobId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetryLetter
     * Meta information extracted from the WSDL
     * - documentation: Retry sending a letter which couldn't previously be sent.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\RetryLetter $parameters
     * @return \\NineDotMedia\Viapost\Struct\RetryLetterResponse|bool
     */
    public function RetryLetter(\\NineDotMedia\Viapost\Struct\RetryLetter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetryLetter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAddressesForPostcode
     * Meta information extracted from the WSDL
     * - documentation: Return a list of addresses belonging to the specified postcode.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetAddressesForPostcode $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetAddressesForPostcodeResponse|bool
     */
    public function GetAddressesForPostcode(\\NineDotMedia\Viapost\Struct\GetAddressesForPostcode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAddressesForPostcode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDocumentStickerArea
     * Meta information extracted from the WSDL
     * - documentation: Get the dimensions of the address sticker in pixels. Can be used for letters or postcards.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetDocumentStickerArea $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetDocumentStickerAreaResponse|bool
     */
    public function GetDocumentStickerArea(\\NineDotMedia\Viapost\Struct\GetDocumentStickerArea $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDocumentStickerArea($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDocumentReservedAreas
     * Meta information extracted from the WSDL
     * - documentation: Get the reserved areas for a particular document type. Can be used for letters or postcards.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetDocumentReservedAreas $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetDocumentReservedAreasResponse|bool
     */
    public function GetDocumentReservedAreas(\\NineDotMedia\Viapost\Struct\GetDocumentReservedAreas $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDocumentReservedAreas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CalculateCostOfNewMailing
     * Meta information extracted from the WSDL
     * - documentation: Calculate the cost of sending a letter or postcard not yet uploaded on the system to a single address.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\CalculateCostOfNewMailing $parameters
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfNewMailingResponse|bool
     */
    public function CalculateCostOfNewMailing(\\NineDotMedia\Viapost\Struct\CalculateCostOfNewMailing $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateCostOfNewMailing($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IsFirstClassAvailable
     * Meta information extracted from the WSDL
     * - documentation: Determine if 1st class delivery support is available in addition to the standard 2nd class delivery support.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\IsFirstClassAvailable $parameters
     * @return \\NineDotMedia\Viapost\Struct\IsFirstClassAvailableResponse|bool
     */
    public function IsFirstClassAvailable(\\NineDotMedia\Viapost\Struct\IsFirstClassAvailable $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IsFirstClassAvailable($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserDetails
     * Meta information extracted from the WSDL
     * - documentation: Use this method to get Baisc User Deta, User Pricing and VatRate.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetUserDetails $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetUserDetailsResponse|bool
     */
    public function GetUserDetails(\\NineDotMedia\Viapost\Struct\GetUserDetails $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUserDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IsValidLoginToken
     * Meta information extracted from the WSDL
     * - documentation: Checks whether the supplied login token is valid or not.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\IsValidLoginToken $parameters
     * @return \\NineDotMedia\Viapost\Struct\IsValidLoginTokenResponse|bool
     */
    public function IsValidLoginToken(\\NineDotMedia\Viapost\Struct\IsValidLoginToken $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IsValidLoginToken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ChangePassword
     * Meta information extracted from the WSDL
     * - documentation: Use this method to change a user's password. You can only change the password of the user that you are logged into the API as.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\ChangePassword $parameters
     * @return \\NineDotMedia\Viapost\Struct\ChangePasswordResponse|bool
     */
    public function ChangePassword(\\NineDotMedia\Viapost\Struct\ChangePassword $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ChangePassword($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLatestVersionDetails
     * Meta information extracted from the WSDL
     * - documentation: Gets the latest version of a specifed client application.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetLatestVersionDetails $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetLatestVersionDetailsResponse|bool
     */
    public function GetLatestVersionDetails(\\NineDotMedia\Viapost\Struct\GetLatestVersionDetails $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLatestVersionDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccountUrl
     * Meta information extracted from the WSDL
     * - documentation: Gets a url to the users account page in the portal.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetAccountUrl $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetAccountUrlResponse|bool
     */
    public function GetAccountUrl(\\NineDotMedia\Viapost\Struct\GetAccountUrl $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAccountUrl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPortalUrl
     * Meta information extracted from the WSDL
     * - documentation: Gets a url to the specified portal page.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetPortalUrl $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetPortalUrlResponse|bool
     */
    public function GetPortalUrl(\\NineDotMedia\Viapost\Struct\GetPortalUrl $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPortalUrl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PreviewLetter
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Gets a byte array that is the PDF letter with the stickered address. Only works for addresses with a valid postcode.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\PreviewLetter $parameters
     * @return \\NineDotMedia\Viapost\Struct\PreviewLetterResponse|bool
     */
    public function PreviewLetter(\\NineDotMedia\Viapost\Struct\PreviewLetter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PreviewLetter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PreviewLibraryLetter
     * Meta information extracted from the WSDL
     * - documentation: Gets a byte array that is the letter which was uploaded via the portal or the CreateLetter API method. Letters uploaded via the UploadDocument or UploadConsolidatedPDF API methods are not supported.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\PreviewLibraryLetter $parameters
     * @return \\NineDotMedia\Viapost\Struct\PreviewLibraryLetterResponse|bool
     */
    public function PreviewLibraryLetter(\\NineDotMedia\Viapost\Struct\PreviewLibraryLetter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PreviewLibraryLetter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PreviewMailPack
     * Meta information extracted from the WSDL
     * - documentation: Gets a byte array that is the PDF Mail Pack with the stickered address. Only works for addresses with a valid postcode.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\PreviewMailPack $parameters
     * @return \\NineDotMedia\Viapost\Struct\PreviewMailPackResponse|bool
     */
    public function PreviewMailPack(\\NineDotMedia\Viapost\Struct\PreviewMailPack $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PreviewMailPack($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SignIn
     * Meta information extracted from the WSDL
     * - documentation: Use this method to sign in to the ViaPost User Webservices. Signing in is mandatory and must be done before any other service methods can be used. You must supply a valid Viapost Username and Password. Returns a LoginToken which must
     * be supplied as a parameter to the other methods. This method returns True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\SignIn $parameters
     * @return \\NineDotMedia\Viapost\Struct\SignInResponse|bool
     */
    public function SignIn(\\NineDotMedia\Viapost\Struct\SignIn $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SignIn($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadDocument
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Use this method to upload a PDF document. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The Letter Name you supply will be used to display your letter. The DocumentData
     * parameter must contain your PDF as a Base64-encoded byte array. This method returns True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure. The LetterID is populated with the new record
     * ID once the letter has been uploaded.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\UploadDocument $parameters
     * @return \\NineDotMedia\Viapost\Struct\UploadDocumentResponse|bool
     */
    public function UploadDocument(\\NineDotMedia\Viapost\Struct\UploadDocument $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadDocument($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SearchAddress
     * Meta information extracted from the WSDL
     * - documentation: Passed an address to search for in InputAddress (can be partially complete), returns a list of postal addresses as well as descriptive text (ReturnMessage) and a code (PafCode) for the results of the search. You must supply a valid
     * LoginToken to use this method (use SignIn to acquire a LoginToken). If an address search fails the PafCode and ReturnMessage parameters will have more detail and the list of returned addresses will be empty.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\SearchAddress $parameters
     * @return \\NineDotMedia\Viapost\Struct\SearchAddressResponse|bool
     */
    public function SearchAddress(\\NineDotMedia\Viapost\Struct\SearchAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SearchAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateJobRunRecord
     * Meta information extracted from the WSDL
     * - documentation: Internal use only.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\CreateJobRunRecord $parameters
     * @return \\NineDotMedia\Viapost\Struct\CreateJobRunRecordResponse|bool
     */
    public function CreateJobRunRecord(\\NineDotMedia\Viapost\Struct\CreateJobRunRecord $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateJobRunRecord($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendLetterWithStructuredAddress
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Use this method to send a letter using a structured address block (as returned by SearchAddress) and receive detailed information on the address validation if it fails (PafCode and ReturnMessage). You must supply a valid
     * LoginToken to use this method (use SignIn to acquire a LoginToken). This method returns True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\SendLetterWithStructuredAddress $parameters
     * @return \\NineDotMedia\Viapost\Struct\SendLetterWithStructuredAddressResponse|bool
     */
    public function SendLetterWithStructuredAddress(\\NineDotMedia\Viapost\Struct\SendLetterWithStructuredAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendLetterWithStructuredAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * SendLetterWithStructuredAddressAndExceptions
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] This method is a specialisation of the old SendLetterWithStructuredAddress that allows users force an address i.e. it is not checked against the PAF database. There is additional cost for this option.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\SendLetterWithStructuredAddressAndExceptions $parameters
     * @return \\NineDotMedia\Viapost\Struct\SendLetterWithStructuredAddressAndExceptionsResponse|bool
     */
    public function SendLetterWithStructuredAddressAndExceptions(\\NineDotMedia\Viapost\Struct\SendLetterWithStructuredAddressAndExceptions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendLetterWithStructuredAddressAndExceptions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendLetter
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Use this method to send a letter. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). This method returns True if successful or False if a problem occured. The ReturnMessage
     * provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\SendLetter $parameters
     * @return \\NineDotMedia\Viapost\Struct\SendLetterResponse|bool
     */
    public function SendLetter(\\NineDotMedia\Viapost\Struct\SendLetter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendLetter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBalance
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve your account balance. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). This method returns True if successful or False if a problem occured. Your account balance
     * is returned in the AccountBalance parameter. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetBalance $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetBalanceResponse|bool
     */
    public function GetBalance(\\NineDotMedia\Viapost\Struct\GetBalance $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBalance($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailableFunds
     * Meta information extracted from the WSDL
     * - documentation: Use this method to determine the available funds on your account, including any possible credit limit.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetAvailableFunds $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetAvailableFundsResponse|bool
     */
    public function GetAvailableFunds(\\NineDotMedia\Viapost\Struct\GetAvailableFunds $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailableFunds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLetterByID
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a letter using it's unique ID. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The LetterID text you supply will be identify your letter. This method returns
     * True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure. The returnLetter returns a CustomerAPILetter object.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetLetterByID $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetLetterByIDResponse|bool
     */
    public function GetLetterByID(\\NineDotMedia\Viapost\Struct\GetLetterByID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLetterByID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLetters
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a letter list. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The SearchDocumentName text you supply will be used to find your letter by its uploaded title. The
     * SearchDocumentName can be a partial string, in which case the first matching letter is returned. This method returns True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure. The
     * returnLetters returns an arrayList of CustomerAPILetter objects.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetLetters $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetLettersResponse|bool
     */
    public function GetLetters(\\NineDotMedia\Viapost\Struct\GetLetters $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLetters($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLibraryLetters
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of the user's letters that have been uploaded via the portal or the CreateLetter API method. Letters uploaded via the UploadDocument or UploadConsolidatedPDF API methods are not supported.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetLibraryLetters $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetLibraryLettersResponse|bool
     */
    public function GetLibraryLetters(\\NineDotMedia\Viapost\Struct\GetLibraryLetters $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLibraryLetters($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMailingLists
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of mailing lists. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The SearchMailingListTitle text you supply will be used to find your mailing list by its
     * uploaded title. The SearchMailingListTitle can be a partial string, in which case the first matching mailing list is returned. This method returns True if successful or False if a problem occured. The ReturnMessage provides an explanation in the
     * event of a failure. The returnMailinglists returns an ArrayList of CustomerAPIMailingList objects.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetMailingLists $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetMailingListsResponse|bool
     */
    public function GetMailingLists(\\NineDotMedia\Viapost\Struct\GetMailingLists $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMailingLists($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMailingListByID
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a mailing list using its unique ID. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The MailingListID you supply will be used to locate your mailing list. This
     * method returns True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure. The returnMailinglist returns a CustomerAPIMailingList object.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetMailingListByID $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetMailingListByIDResponse|bool
     */
    public function GetMailingListByID(\\NineDotMedia\Viapost\Struct\GetMailingListByID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMailingListByID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteMailingList
     * Meta information extracted from the WSDL
     * - documentation: Use this method to delete a mailing list using its unique ID. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The MailingListID you supply will be used to delete your mailing list. This
     * method returns True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\DeleteMailingList $parameters
     * @return \\NineDotMedia\Viapost\Struct\DeleteMailingListResponse|bool
     */
    public function DeleteMailingList(\\NineDotMedia\Viapost\Struct\DeleteMailingList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteMailingList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteMapping
     * Meta information extracted from the WSDL
     * - documentation: Use this method to delete a mapping using its unique ID. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The mappingID you supply will be used to delete your mapping. This method returns
     * True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\DeleteMapping $parameters
     * @return \\NineDotMedia\Viapost\Struct\DeleteMappingResponse|bool
     */
    public function DeleteMapping(\\NineDotMedia\Viapost\Struct\DeleteMapping $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteMapping($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteUserVariable
     * Meta information extracted from the WSDL
     * - documentation: Use this method to delete a user variable using it's unique ID. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The variableID you supply will be used to delete your user variable. This
     * method returns True if successful or False if a problem occurred. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\DeleteUserVariable $parameters
     * @return \\NineDotMedia\Viapost\Struct\DeleteUserVariableResponse|bool
     */
    public function DeleteUserVariable(\\NineDotMedia\Viapost\Struct\DeleteUserVariable $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteUserVariable($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteLetterhead
     * Meta information extracted from the WSDL
     * - documentation: Use this method to delete a letterhead using it's unique ID. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The letterheadID you supply will be used to delete your letterhead. This method
     * returns True if successful or False if a problem occurred. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\DeleteLetterhead $parameters
     * @return \\NineDotMedia\Viapost\Struct\DeleteLetterheadResponse|bool
     */
    public function DeleteLetterhead(\\NineDotMedia\Viapost\Struct\DeleteLetterhead $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteLetterhead($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteLetter
     * Meta information extracted from the WSDL
     * - documentation: Use this method to delete a letter using it's unique ID. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The letterID you supply will be used to delete the letter. This method returns True
     * if successful or False if a problem occurred. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\DeleteLetter $parameters
     * @return \\NineDotMedia\Viapost\Struct\DeleteLetterResponse|bool
     */
    public function DeleteLetter(\\NineDotMedia\Viapost\Struct\DeleteLetter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteLetter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteAttachment
     * Meta information extracted from the WSDL
     * - documentation: Use this method to delete an attachment using it's unique ID. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The attachmentID you supply will be used to delete your attachment. This method
     * returns True if successful or False if a problem occurred. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\DeleteAttachment $parameters
     * @return \\NineDotMedia\Viapost\Struct\DeleteAttachmentResponse|bool
     */
    public function DeleteAttachment(\\NineDotMedia\Viapost\Struct\DeleteAttachment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteAttachment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeletePostcard
     * Meta information extracted from the WSDL
     * - documentation: Use this method to delete a postcard using it's unique ID. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The postcardID you supply will be used to delete your postcard. This method
     * returns True if successful or False if a problem occurred. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\DeletePostcard $parameters
     * @return \\NineDotMedia\Viapost\Struct\DeletePostcardResponse|bool
     */
    public function DeletePostcard(\\NineDotMedia\Viapost\Struct\DeletePostcard $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeletePostcard($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadMailingList
     * Meta information extracted from the WSDL
     * - documentation: Use this method to upload a mailing list in CSV format (refer to the CustomerAPI documentation for details on the CSV format requirements). You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken).
     * The Mailing Address Name you supply will be used to display your mailing list. The MailingListData parameter must contain your CSV data as a Base64-encoded byte array. This method returns True if successful or False if a problem occured. The
     * ReturnMessage provides an explanation in the event of a failure. The MailingListID parameter is populated with the ID of the new record.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\UploadMailingList $parameters
     * @return \\NineDotMedia\Viapost\Struct\UploadMailingListResponse|bool
     */
    public function UploadMailingList(\\NineDotMedia\Viapost\Struct\UploadMailingList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadMailingList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadMailingListWithMapping
     * Meta information extracted from the WSDL
     * - documentation: Use this method to upload a mailing list in CSV format. You can also specify the ID of a custom mapping to successfully extract the addresses from your spreadsheet. You must supply a valid LoginToken to use this method (use SignIn to
     * acquire a LoginToken). The Mailing Address Name you supply will be used to display your mailing list. The MailingListData parameter must contain your CSV data as a Base64-encoded byte array. This method returns True if successful or False if a
     * problem occured. The ReturnMessage provides an explanation in the event of a failure. The MailingListID parameter is populated with the ID of the new record.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\UploadMailingListWithMapping $parameters
     * @return \\NineDotMedia\Viapost\Struct\UploadMailingListWithMappingResponse|bool
     */
    public function UploadMailingListWithMapping(\\NineDotMedia\Viapost\Struct\UploadMailingListWithMapping $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadMailingListWithMapping($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * UploadMailingListWithMappingAndShare
     * Meta information extracted from the WSDL
     * - documentation: Use this method to upload a mailing list in CSV format. You can also specify the ID of a custom mapping to successfully extract the addresses from your spreadsheet. You must supply a valid LoginToken to use this method (use SignIn to
     * acquire a LoginToken). The Mailing Address Name you supply will be used to display your mailing list. The MailingListData parameter must contain your CSV data as a Base64-encoded byte array. This method returns True if successful or False if a
     * problem occured. The ReturnMessage provides an explanation in the event of a failure. The MailingListID parameter is populated with the ID of the new record.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\UploadMailingListWithMappingAndShare $parameters
     * @return \\NineDotMedia\Viapost\Struct\UploadMailingListWithMappingAndShareResponse|bool
     */
    public function UploadMailingListWithMappingAndShare(\\NineDotMedia\Viapost\Struct\UploadMailingListWithMappingAndShare $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadMailingListWithMappingAndShare($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadConsolidatedPDF
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Use this method upload a Consolidated PDF. The consolidated PDF will be splint into individual documents based on SplitOptions and then sent/uploaded as individual letters.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\UploadConsolidatedPDF $parameters
     * @return \\NineDotMedia\Viapost\Struct\UploadConsolidatedPDFResponse|bool
     */
    public function UploadConsolidatedPDF(\\NineDotMedia\Viapost\Struct\UploadConsolidatedPDF $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadConsolidatedPDF($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MailMerge
     * Meta information extracted from the WSDL
     * - documentation: Use this method to perform a mail merge. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The Letter and MailingList you supply will be used to select the letter template and mailing list to
     * be used. This method returns True if successful or False if a problem occurred. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\MailMerge $parameters
     * @return \\NineDotMedia\Viapost\Struct\MailMergeResponse|bool
     */
    public function MailMerge(\\NineDotMedia\Viapost\Struct\MailMerge $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MailMerge($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * MailMergeWithExceptionsAndConfirmationEmails
     * Meta information extracted from the WSDL
     * - documentation: Use this method to perform a mail merge. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The Letter and MailingList you supply will be used to select the letter template and mailing list to
     * be used. You can choose whether you want to send a confirmation email out for each letter. This method returns True if successful or False if a problem occurred. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\MailMergeWithExceptionsAndConfirmationEmails $parameters
     * @return \\NineDotMedia\Viapost\Struct\MailMergeWithExceptionsAndConfirmationEmailsResponse|bool
     */
    public function MailMergeWithExceptionsAndConfirmationEmails(\\NineDotMedia\Viapost\Struct\MailMergeWithExceptionsAndConfirmationEmails $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MailMergeWithExceptionsAndConfirmationEmails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MailMergeWithExceptions
     * Meta information extracted from the WSDL
     * - documentation: Use this method to perform a mail merge. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The Letter and MailingList you supply will be used to select the letter template and mailing list to
     * be used. This method returns True if successful or False if a problem occurred. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\MailMergeWithExceptions $parameters
     * @return \\NineDotMedia\Viapost\Struct\MailMergeWithExceptionsResponse|bool
     */
    public function MailMergeWithExceptions(\\NineDotMedia\Viapost\Struct\MailMergeWithExceptions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MailMergeWithExceptions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateAccount
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create a customer account. The method also adds a user to the customer account who is specified as the account admin. Refer to Documentation for information on which fields are required. This method returns True if
     * successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure. If you pass in an empty string for the password variable the method will create a password for you and return it to this variable.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\CreateAccount $parameters
     * @return \\NineDotMedia\Viapost\Struct\CreateAccountResponse|bool
     */
    public function CreateAccount(\\NineDotMedia\Viapost\Struct\CreateAccount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAccount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateAccountNonUK
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create a customer account. The method also adds a user to the customer account who is specified as the account admin. Refer to Documentation for information on which fields are required. This method returns True if
     * successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure. If you pass in an empty string for the password variable the method will create a password for you and return it to this variable.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\CreateAccountNonUK $parameters
     * @return \\NineDotMedia\Viapost\Struct\CreateAccountNonUKResponse|bool
     */
    public function CreateAccountNonUK(\\NineDotMedia\Viapost\Struct\CreateAccountNonUK $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAccountNonUK($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddUserToAccount
     * Meta information extracted from the WSDL
     * - documentation: Use this method to add a user to a customer account. Your login token must belong an account admin to use this method. You can specify whether or not you want the created user to also be an admin. Refer to Documentation for
     * information on which fields are required. This method returns True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure. If you pass in an empty string for the password variable the method
     * will create a password for you and return it to this variable.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\AddUserToAccount $parameters
     * @return \\NineDotMedia\Viapost\Struct\AddUserToAccountResponse|bool
     */
    public function AddUserToAccount(\\NineDotMedia\Viapost\Struct\AddUserToAccount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddUserToAccount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddUserToAccountPermissions
     * Meta information extracted from the WSDL
     * - documentation: Use this method to add a user to a customer account. Your login token must belong an account admin to use this method. You can specify whether or not you want the created user to also be an admin. Refer to Documentation for
     * information on which fields are required. This method returns True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure. If you pass in an empty string for the password variable the method
     * will create a password for you and return it to this variable.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\AddUserToAccountPermissions $parameters
     * @return \\NineDotMedia\Viapost\Struct\AddUserToAccountPermissionsResponse|bool
     */
    public function AddUserToAccountPermissions(\\NineDotMedia\Viapost\Struct\AddUserToAccountPermissions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddUserToAccountPermissions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddUserToAccountNonUK
     * Meta information extracted from the WSDL
     * - documentation: Use this method to add a user to a customer account. Your login token must belong an account admin to use this method. You can specify whether or not you want the created user to also be an admin. Refer to Documentation for
     * information on which fields are required. This method returns True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure. If you pass in an empty string for the password variable the method
     * will create a password for you and return it to this variable.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\AddUserToAccountNonUK $parameters
     * @return \\NineDotMedia\Viapost\Struct\AddUserToAccountNonUKResponse|bool
     */
    public function AddUserToAccountNonUK(\\NineDotMedia\Viapost\Struct\AddUserToAccountNonUK $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddUserToAccountNonUK($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddUserToAccountNonUKPermissions
     * Meta information extracted from the WSDL
     * - documentation: Use this method to add a user to a customer account. Your login token must belong an account admin to use this method. You can specify whether or not you want the created user to also be an admin. Refer to Documentation for
     * information on which fields are required. This method returns True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure. If you pass in an empty string for the password variable the method
     * will create a password for you and return it to this variable.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\AddUserToAccountNonUKPermissions $parameters
     * @return \\NineDotMedia\Viapost\Struct\AddUserToAccountNonUKPermissionsResponse|bool
     */
    public function AddUserToAccountNonUKPermissions(\\NineDotMedia\Viapost\Struct\AddUserToAccountNonUKPermissions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddUserToAccountNonUKPermissions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * CalculateLetterCostComplexBatchWithExceptions
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Use this method to calculate a cost of a complex batch (one containing letters with different numbers of pages) that requires validation exceptions. You must supply a valid LoginToken to use this method (use SignIn to
     * acquire a LoginToken). You must also create a MailBatch Object which stores the details about the letters being sent in the batch. The method returns true on success and will also pass out the total Net Cost and VAT seperately.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\CalculateLetterCostComplexBatchWithExceptions $parameters
     * @return \\NineDotMedia\Viapost\Struct\CalculateLetterCostComplexBatchWithExceptionsResponse|bool
     */
    public function CalculateLetterCostComplexBatchWithExceptions(\\NineDotMedia\Viapost\Struct\CalculateLetterCostComplexBatchWithExceptions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateLetterCostComplexBatchWithExceptions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CalculateLetterCostSimpleBatch
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Use this method to calculate a cost of a simple batch(one contaning letters with the same number of pages) that does not require validation exceptions. You must supply a valid LoginToken to use this method (use SignIn to
     * acquire a LoginToken). The method returns true on success and will also pass out the total Net Cost and VAT seperately.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\CalculateLetterCostSimpleBatch $parameters
     * @return \\NineDotMedia\Viapost\Struct\CalculateLetterCostSimpleBatchResponse|bool
     */
    public function CalculateLetterCostSimpleBatch(\\NineDotMedia\Viapost\Struct\CalculateLetterCostSimpleBatch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateLetterCostSimpleBatch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * CalculateLetterCostSimpleBatchWithExceptions
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Use this method to calculate a cost of a complex batch(one contaning letters with the same number of pages) that requires validation exceptions. You must supply a valid LoginToken to use this method (use SignIn to
     * acquire a LoginToken). The method returns true on success and will also pass out the total Net Cost and VAT seperately.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\CalculateLetterCostSimpleBatchWithExceptions $parameters
     * @return \\NineDotMedia\Viapost\Struct\CalculateLetterCostSimpleBatchWithExceptionsResponse|bool
     */
    public function CalculateLetterCostSimpleBatchWithExceptions(\\NineDotMedia\Viapost\Struct\CalculateLetterCostSimpleBatchWithExceptions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateLetterCostSimpleBatchWithExceptions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CalculateLetterCostComplexBatch
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Use this method to calculate a cost of a mail merge. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The method returns true on success and will also pass out the total Net
     * Cost and VAT seperately.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\CalculateLetterCostComplexBatch $parameters
     * @return \\NineDotMedia\Viapost\Struct\CalculateLetterCostComplexBatchResponse|bool
     */
    public function CalculateLetterCostComplexBatch(\\NineDotMedia\Viapost\Struct\CalculateLetterCostComplexBatch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateLetterCostComplexBatch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CalculateMailMergeCost
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Use this method to perform a mail merge. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). This method returns True if successful or False if a problem occurred. The
     * ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\CalculateMailMergeCost $parameters
     * @return \\NineDotMedia\Viapost\Struct\CalculateMailMergeCostResponse|bool
     */
    public function CalculateMailMergeCost(\\NineDotMedia\Viapost\Struct\CalculateMailMergeCost $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateMailMergeCost($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CalculateEstimatedDeliveryDate
     * Meta information extracted from the WSDL
     * - documentation: Use this method to calculate the estimated delivery date of a letter based on the time passed in. This takes into account weekends, holidays and strikes. You must supply a valid LoginToken to use this method (use SignIn to acquire a
     * LoginToken). This method returns True if successful or False if a problem occured. The SendDateTime variable is the date and time when you wish to send letters out and the DeliveryDate is the estimated Royal Mail delivery date. The ReturnMessage
     * provides an explanation of the estimated delivery date.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\CalculateEstimatedDeliveryDate $parameters
     * @return \\NineDotMedia\Viapost\Struct\CalculateEstimatedDeliveryDateResponse|bool
     */
    public function CalculateEstimatedDeliveryDate(\\NineDotMedia\Viapost\Struct\CalculateEstimatedDeliveryDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateEstimatedDeliveryDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CalculateEstimatedDeliveryDateNow
     * Meta information extracted from the WSDL
     * - documentation: Use this method to calculate the estimated delivery date of a letter based on the current time. This takes into account weekends, holidays and strikes. You must supply a valid LoginToken to use this method (use SignIn to acquire a
     * LoginToken). This method returns True if successful or False if a problem occured. The DeliveryDate is the estimated Royal Mail delivery date. The ReturnMessage provides an explanation of the estimated delivery date.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\CalculateEstimatedDeliveryDateNow $parameters
     * @return \\NineDotMedia\Viapost\Struct\CalculateEstimatedDeliveryDateNowResponse|bool
     */
    public function CalculateEstimatedDeliveryDateNow(\\NineDotMedia\Viapost\Struct\CalculateEstimatedDeliveryDateNow $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateEstimatedDeliveryDateNow($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CalculateSendDateForDeliveryDate
     * Meta information extracted from the WSDL
     * - documentation: Use this method to calculate the date on which you should send a letter for it to arrive on a specified date. This takes into account weekends, holidays and strikes. You must supply a valid LoginToken to use this method (use SignIn
     * to acquire a LoginToken). This method returns True if successful or False if a problem occured. The earliest and latest SendDate are the estimated send dates based on our batching and Royal Mail delivery. The ReturnMessage provides an explanation of
     * the estimated delivery date.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\CalculateSendDateForDeliveryDate $parameters
     * @return \\NineDotMedia\Viapost\Struct\CalculateSendDateForDeliveryDateResponse|bool
     */
    public function CalculateSendDateForDeliveryDate(\\NineDotMedia\Viapost\Struct\CalculateSendDateForDeliveryDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateSendDateForDeliveryDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLetterStatusByLetterID
     * Meta information extracted from the WSDL
     * - documentation: Use this method to check the status of a letter. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken) and the letter specified by an ID must belong to you. This method returns True if successful
     * or False if a problem occured. The ReturnMessage provides details about the status or any problems that occurred.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetLetterStatusByLetterID $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetLetterStatusByLetterIDResponse|bool
     */
    public function GetLetterStatusByLetterID(\\NineDotMedia\Viapost\Struct\GetLetterStatusByLetterID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLetterStatusByLetterID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLetterStatusByCustomerAPILetter
     * Meta information extracted from the WSDL
     * - documentation: Use this method to check the status of a letter. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken) and the letter specified by a CustomerAPILetter object must belong to you. This method
     * returns True if successful or False if a problem occured. The ReturnMessage provides details about the status or any problems that occurred.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetLetterStatusByCustomerAPILetter $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetLetterStatusByCustomerAPILetterResponse|bool
     */
    public function GetLetterStatusByCustomerAPILetter(\\NineDotMedia\Viapost\Struct\GetLetterStatusByCustomerAPILetter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLetterStatusByCustomerAPILetter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteLetterByLetterID
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Use this method to delete a letter. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken) and the letter specified by an ID must belong to you. This method returns True if successful
     * or False if a problem occured. The ReturnMessage provides details about the status or any problems that occurred.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\DeleteLetterByLetterID $parameters
     * @return \\NineDotMedia\Viapost\Struct\DeleteLetterByLetterIDResponse|bool
     */
    public function DeleteLetterByLetterID(\\NineDotMedia\Viapost\Struct\DeleteLetterByLetterID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteLetterByLetterID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteLetterByCustomerAPILetter
     * Meta information extracted from the WSDL
     * - documentation: Use this method to delete a letter. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken) and the letter specified by a CustomerAPILetter object must belong to you. This method returns True if
     * successful or False if a problem occured. The ReturnMessage provides details about the status or any problems that occurred.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\DeleteLetterByCustomerAPILetter $parameters
     * @return \\NineDotMedia\Viapost\Struct\DeleteLetterByCustomerAPILetterResponse|bool
     */
    public function DeleteLetterByCustomerAPILetter(\\NineDotMedia\Viapost\Struct\DeleteLetterByCustomerAPILetter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteLetterByCustomerAPILetter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreatePriceBand
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create a new price band. You must supply a valid GUID to use this method as well as a unique description string to identify the price band. This method returns True if successful or False if a problem occured. It
     * also provides the PriceBandID for your use. The ReturnMessage provides details about the status or any problems that occurred.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\CreatePriceBand $parameters
     * @return \\NineDotMedia\Viapost\Struct\CreatePriceBandResponse|bool
     */
    public function CreatePriceBand(\\NineDotMedia\Viapost\Struct\CreatePriceBand $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreatePriceBand($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AssignPriceBand
     * Meta information extracted from the WSDL
     * - documentation: Use this method to assign a price band to a customer. You must supply a valid GUID to use this method as well as a username associated with the customer account and the ID of the price band that you wish to apply. The customer and
     * price band must be associated with your GUID. This method returns True if successful or False if a problem occured. The ReturnMessage provides details about the status or any problems that occurred.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\AssignPriceBand $parameters
     * @return \\NineDotMedia\Viapost\Struct\AssignPriceBandResponse|bool
     */
    public function AssignPriceBand(\\NineDotMedia\Viapost\Struct\AssignPriceBand $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AssignPriceBand($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPriceBands
     * Meta information extracted from the WSDL
     * - documentation: Use this method to return a delimited string containing the details of all price bands associated with your GUID. You must supply a valid GUID to use this method. This method returns True if successful or False if a problem occured.
     * The ReturnMessage provides details about the status or any problems that occurred.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetPriceBands $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetPriceBandsResponse|bool
     */
    public function GetPriceBands(\\NineDotMedia\Viapost\Struct\GetPriceBands $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPriceBands($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeletePriceBand
     * Meta information extracted from the WSDL
     * - documentation: Use this method to delete a price band. You must supply a valid GUID to use this method as well as the ID of the price band which you wish to delete. You can only delete a price band if no customers are currently using it. This
     * method returns True if successful or False if a problem occured. The ReturnMessage provides details about the status or any problems that occurred.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\DeletePriceBand $parameters
     * @return \\NineDotMedia\Viapost\Struct\DeletePriceBandResponse|bool
     */
    public function DeletePriceBand(\\NineDotMedia\Viapost\Struct\DeletePriceBand $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeletePriceBand($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCountries
     * Meta information extracted from the WSDL
     * - documentation: Use this method to get a list of all of the countries and their associated IDs. You need an ID to pass into the CreateAccount or AddUserToAccount methods if you wish to specify a non-UK address.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetCountries $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetCountriesResponse|bool
     */
    public function GetCountries(\\NineDotMedia\Viapost\Struct\GetCountries $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCountries($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DisableUser
     * Meta information extracted from the WSDL
     * - documentation: Use this method to disable a user account. You need to specify the username of the account that you wish to disable.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\DisableUser $parameters
     * @return \\NineDotMedia\Viapost\Struct\DisableUserResponse|bool
     */
    public function DisableUser(\\NineDotMedia\Viapost\Struct\DisableUser $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DisableUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMessage
     * Meta information extracted from the WSDL
     * - documentation: Get the return message.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GetMessage $parameters
     * @return \\NineDotMedia\Viapost\Struct\GetMessageResponse|bool
     */
    public function GetMessage(\\NineDotMedia\Viapost\Struct\GetMessage $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMessage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GenerateMapping
     * Meta information extracted from the WSDL
     * - documentation: Generate an XML Mapping for a Mailing List.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GenerateMapping $parameters
     * @return \\NineDotMedia\Viapost\Struct\GenerateMappingResponse|bool
     */
    public function GenerateMapping(\\NineDotMedia\Viapost\Struct\GenerateMapping $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GenerateMapping($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GenerateMappingWithDefaultName
     * Meta information extracted from the WSDL
     * - documentation: Generate an XML Mapping for a Mailing List and specify a default name.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\NineDotMedia\Viapost\Struct\GenerateMappingWithDefaultName $parameters
     * @return \\NineDotMedia\Viapost\Struct\GenerateMappingWithDefaultNameResponse|bool
     */
    public function GenerateMappingWithDefaultName(\\NineDotMedia\Viapost\Struct\GenerateMappingWithDefaultName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GenerateMappingWithDefaultName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \\NineDotMedia\Viapost\Struct\AddExcludedAddressResponse|\\NineDotMedia\Viapost\Struct\AddUserToAccountNonUKPermissionsResponse|\\NineDotMedia\Viapost\Struct\AddUserToAccountNonUKResponse|\\NineDotMedia\Viapost\Struct\AddUserToAccountPermissionsResponse|\\NineDotMedia\Viapost\Struct\AddUserToAccountResponse|\\NineDotMedia\Viapost\Struct\AssignPriceBandResponse|\\NineDotMedia\Viapost\Struct\CalculateCostOfDataListResponse|\\NineDotMedia\Viapost\Struct\CalculateCostOfFindNearestMailingResponse|\\NineDotMedia\Viapost\Struct\CalculateCostOfMailingResponse|\\NineDotMedia\Viapost\Struct\CalculateCostOfNewMailingResponse|\\NineDotMedia\Viapost\Struct\CalculateCostOfSingleAddressMailingResponse|\\NineDotMedia\Viapost\Struct\CalculateEstimatedDeliveryDateNowResponse|\\NineDotMedia\Viapost\Struct\CalculateEstimatedDeliveryDateResponse|\\NineDotMedia\Viapost\Struct\CalculateLetterCostComplexBatchResponse|\\NineDotMedia\Viapost\Struct\CalculateLetterCostComplexBatchWithExceptionsResponse|\\NineDotMedia\Viapost\Struct\CalculateLetterCostSimpleBatchResponse|\\NineDotMedia\Viapost\Struct\CalculateLetterCostSimpleBatchWithExceptionsResponse|\\NineDotMedia\Viapost\Struct\CalculateMailMergeCostResponse|\\NineDotMedia\Viapost\Struct\CalculateSendDateForDeliveryDateResponse|\\NineDotMedia\Viapost\Struct\ChangePasswordResponse|\\NineDotMedia\Viapost\Struct\CreateAccountNonUKResponse|\\NineDotMedia\Viapost\Struct\CreateAccountResponse|\\NineDotMedia\Viapost\Struct\CreateAndSendMailPackResponse|\\NineDotMedia\Viapost\Struct\CreateAndSendMailPackToFindNearestResponse|\\NineDotMedia\Viapost\Struct\CreateAndSendMailPackToSingleAddressResponse|\\NineDotMedia\Viapost\Struct\CreateAndSendPostcardResponse|\\NineDotMedia\Viapost\Struct\CreateAndSendPostcardToFindNearestResponse|\\NineDotMedia\Viapost\Struct\CreateAndSendPostcardToSingleAddressResponse|\\NineDotMedia\Viapost\Struct\CreateAndSendSimpleMailingResponse|\\NineDotMedia\Viapost\Struct\CreateAndSendSimpleMailingToFindNearestResponse|\\NineDotMedia\Viapost\Struct\CreateAndSendSimpleMailingToSingleAddressResponse|\\NineDotMedia\Viapost\Struct\CreateAttachmentResponse|\\NineDotMedia\Viapost\Struct\CreateJobRunRecordResponse|\\NineDotMedia\Viapost\Struct\CreateLetterFromXPSResponse|\\NineDotMedia\Viapost\Struct\CreateLetterheadResponse|\\NineDotMedia\Viapost\Struct\CreateLetterResponse|\\NineDotMedia\Viapost\Struct\CreateMailPackResponse|\\NineDotMedia\Viapost\Struct\CreatePostcardResponse|\\NineDotMedia\Viapost\Struct\CreatePriceBandResponse|\\NineDotMedia\Viapost\Struct\DeleteAttachmentResponse|\\NineDotMedia\Viapost\Struct\DeleteExcludedAddressByIDResponse|\\NineDotMedia\Viapost\Struct\DeleteLetterByCustomerAPILetterResponse|\\NineDotMedia\Viapost\Struct\DeleteLetterByLetterIDResponse|\\NineDotMedia\Viapost\Struct\DeleteLetterheadResponse|\\NineDotMedia\Viapost\Struct\DeleteLetterResponse|\\NineDotMedia\Viapost\Struct\DeleteMailingListResponse|\\NineDotMedia\Viapost\Struct\DeleteMailPackResponse|\\NineDotMedia\Viapost\Struct\DeleteMappingResponse|\\NineDotMedia\Viapost\Struct\DeletePostcardResponse|\\NineDotMedia\Viapost\Struct\DeletePriceBandResponse|\\NineDotMedia\Viapost\Struct\DeleteUserVariableResponse|\\NineDotMedia\Viapost\Struct\DisableUserResponse|\\NineDotMedia\Viapost\Struct\DownloadDataListResponse|\\NineDotMedia\Viapost\Struct\FindNearestExecuteSearchResponse|\\NineDotMedia\Viapost\Struct\FindNearestQueryAddressResponse|\\NineDotMedia\Viapost\Struct\GenerateMappingResponse|\\NineDotMedia\Viapost\Struct\GenerateMappingWithDefaultNameAndMergeFieldsResponse|\\NineDotMedia\Viapost\Struct\GenerateMappingWithDefaultNameAndMergeFieldsWithIDResponse|\\NineDotMedia\Viapost\Struct\GenerateMappingWithDefaultNameResponse|\\NineDotMedia\Viapost\Struct\GenerateMappingWithDefaultNameWithIDResponse|\\NineDotMedia\Viapost\Struct\GenerateMappingWithIDResponse|\\NineDotMedia\Viapost\Struct\GetAccountUrlResponse|\\NineDotMedia\Viapost\Struct\GetAddressesForPostcodeResponse|\\NineDotMedia\Viapost\Struct\GetAvailableFundsResponse|\\NineDotMedia\Viapost\Struct\GetBalanceResponse|\\NineDotMedia\Viapost\Struct\GetCostCentresResponse|\\NineDotMedia\Viapost\Struct\GetCountriesResponse|\\NineDotMedia\Viapost\Struct\GetDataListsResponse|\\NineDotMedia\Viapost\Struct\GetDataListUrlResponse|\\NineDotMedia\Viapost\Struct\GetDocumentationResponse|\\NineDotMedia\Viapost\Struct\GetDocumentPageCountRangeResponse|\\NineDotMedia\Viapost\Struct\GetDocumentReservedAreasResponse|\\NineDotMedia\Viapost\Struct\GetDocumentStickerAreaResponse|\\NineDotMedia\Viapost\Struct\GetExcludedAddressesResponse|\\NineDotMedia\Viapost\Struct\GetLatestVersionDetailsResponse|\\NineDotMedia\Viapost\Struct\GetLetterByIDResponse|\\NineDotMedia\Viapost\Struct\GetLettersResponse|\\NineDotMedia\Viapost\Struct\GetLetterStatusByCustomerAPILetterResponse|\\NineDotMedia\Viapost\Struct\GetLetterStatusByLetterIDResponse|\\NineDotMedia\Viapost\Struct\GetLibraryAttachmentsResponse|\\NineDotMedia\Viapost\Struct\GetLibraryInsertsResponse|\\NineDotMedia\Viapost\Struct\GetLibraryLetterheadsResponse|\\NineDotMedia\Viapost\Struct\GetLibraryLettersResponse|\\NineDotMedia\Viapost\Struct\GetLibraryMailPacksResponse|\\NineDotMedia\Viapost\Struct\GetLibraryMappingsResponse|\\NineDotMedia\Viapost\Struct\GetLibraryPostcardsResponse|\\NineDotMedia\Viapost\Struct\GetMailHistoryDocumentsByJobIdResponse|\\NineDotMedia\Viapost\Struct\GetMailHistoryJobsResponse|\\NineDotMedia\Viapost\Struct\GetMailingListByIDResponse|\\NineDotMedia\Viapost\Struct\GetMailingListsResponse|\\NineDotMedia\Viapost\Struct\GetMailPacksResponse|\\NineDotMedia\Viapost\Struct\GetMessageResponse|\\NineDotMedia\Viapost\Struct\GetPortalUrlResponse|\\NineDotMedia\Viapost\Struct\GetPriceBandsResponse|\\NineDotMedia\Viapost\Struct\GetSystemIDResponse|\\NineDotMedia\Viapost\Struct\GetUserDetailsResponse|\\NineDotMedia\Viapost\Struct\GetUserVariablesResponse|\\NineDotMedia\Viapost\Struct\IsFirstClassAvailableResponse|\\NineDotMedia\Viapost\Struct\IsValidLoginTokenResponse|\\NineDotMedia\Viapost\Struct\MailMergeResponse|\\NineDotMedia\Viapost\Struct\MailMergeWithExceptionsAndConfirmationEmailsResponse|\\NineDotMedia\Viapost\Struct\MailMergeWithExceptionsResponse|\\NineDotMedia\Viapost\Struct\PreviewDocumentFindNearestResponse|\\NineDotMedia\Viapost\Struct\PreviewDocumentMailingListResponse|\\NineDotMedia\Viapost\Struct\PreviewDocumentSingleAddressResponse|\\NineDotMedia\Viapost\Struct\PreviewLetterResponse|\\NineDotMedia\Viapost\Struct\PreviewLibraryAttachmentResponse|\\NineDotMedia\Viapost\Struct\PreviewLibraryLetterheadResponse|\\NineDotMedia\Viapost\Struct\PreviewLibraryLetterResponse|\\NineDotMedia\Viapost\Struct\PreviewLibraryPostcardResponse|\\NineDotMedia\Viapost\Struct\PreviewMailPackResponse|\\NineDotMedia\Viapost\Struct\RetryLetterResponse|\\NineDotMedia\Viapost\Struct\SearchAddressResponse|\\NineDotMedia\Viapost\Struct\SendDriverMailingConfirmationResponse|\\NineDotMedia\Viapost\Struct\SendLetterResponse|\\NineDotMedia\Viapost\Struct\SendLetterWithStructuredAddressAndExceptionsResponse|\\NineDotMedia\Viapost\Struct\SendLetterWithStructuredAddressResponse|\\NineDotMedia\Viapost\Struct\SendMailPackResponse|\\NineDotMedia\Viapost\Struct\SendMailPackToFindNearestResponse|\\NineDotMedia\Viapost\Struct\SendMailPackToSingleAddress2Response|\\NineDotMedia\Viapost\Struct\SendMailPackToSingleAddressResponse|\\NineDotMedia\Viapost\Struct\SendPostcardResponse|\\NineDotMedia\Viapost\Struct\SendPostcardToFindNearestResponse|\\NineDotMedia\Viapost\Struct\SendPostcardToSingleAddressResponse|\\NineDotMedia\Viapost\Struct\SendSimpleMailingResponse|\\NineDotMedia\Viapost\Struct\SendSimpleMailingToFindNearestResponse|\\NineDotMedia\Viapost\Struct\SendSimpleMailingToSingleAddressResponse|\\NineDotMedia\Viapost\Struct\SignInResponse|\\NineDotMedia\Viapost\Struct\UpdateLetterResponse|\\NineDotMedia\Viapost\Struct\UpdateMailPackLetterResponse|\\NineDotMedia\Viapost\Struct\UpdateMailPackTemplateResponse|\\NineDotMedia\Viapost\Struct\UploadConsolidatedPDFResponse|\\NineDotMedia\Viapost\Struct\UploadDocumentResponse|\\NineDotMedia\Viapost\Struct\UploadMailingListResponse|\\NineDotMedia\Viapost\Struct\UploadMailingListWithMappingAndShareResponse|\\NineDotMedia\Viapost\Struct\UploadMailingListWithMappingResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
