<?php

namespace \NineDotMedia\Viapost\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateMailPackLetter Struct
 * @subpackage Structs
 */
class UpdateMailPackLetter extends AbstractStructBase
{
    /**
     * The mailpackID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $mailpackID;
    /**
     * The letterID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $letterID;
    /**
     * The loginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginToken;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for UpdateMailPackLetter
     * @uses UpdateMailPackLetter::setMailpackID()
     * @uses UpdateMailPackLetter::setLetterID()
     * @uses UpdateMailPackLetter::setLoginToken()
     * @uses UpdateMailPackLetter::setReturnMessage()
     * @param int $mailpackID
     * @param int $letterID
     * @param string $loginToken
     * @param string $returnMessage
     */
    public function __construct($mailpackID = null, $letterID = null, $loginToken = null, $returnMessage = null)
    {
        $this
            ->setMailpackID($mailpackID)
            ->setLetterID($letterID)
            ->setLoginToken($loginToken)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get mailpackID value
     * @return int
     */
    public function getMailpackID()
    {
        return $this->mailpackID;
    }
    /**
     * Set mailpackID value
     * @param int $mailpackID
     * @return \\NineDotMedia\Viapost\Struct\UpdateMailPackLetter
     */
    public function setMailpackID($mailpackID = null)
    {
        // validation for constraint: int
        if (!is_null($mailpackID) && !(is_int($mailpackID) || ctype_digit($mailpackID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mailpackID, true), gettype($mailpackID)), __LINE__);
        }
        $this->mailpackID = $mailpackID;
        return $this;
    }
    /**
     * Get letterID value
     * @return int
     */
    public function getLetterID()
    {
        return $this->letterID;
    }
    /**
     * Set letterID value
     * @param int $letterID
     * @return \\NineDotMedia\Viapost\Struct\UpdateMailPackLetter
     */
    public function setLetterID($letterID = null)
    {
        // validation for constraint: int
        if (!is_null($letterID) && !(is_int($letterID) || ctype_digit($letterID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($letterID, true), gettype($letterID)), __LINE__);
        }
        $this->letterID = $letterID;
        return $this;
    }
    /**
     * Get loginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->loginToken;
    }
    /**
     * Set loginToken value
     * @param string $loginToken
     * @return \\NineDotMedia\Viapost\Struct\UpdateMailPackLetter
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->loginToken = $loginToken;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \\NineDotMedia\Viapost\Struct\UpdateMailPackLetter
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
