<?php

namespace \NineDotMedia\Viapost\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RectangleF Struct
 * @subpackage Structs
 */
class RectangleF extends AbstractStructBase
{
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \\NineDotMedia\Viapost\Struct\PointF
     */
    public $Location;
    /**
     * The Size
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \\NineDotMedia\Viapost\Struct\SizeF
     */
    public $Size;
    /**
     * The X
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $X;
    /**
     * The Y
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Y;
    /**
     * The Width
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Width;
    /**
     * The Height
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Height;
    /**
     * Constructor method for RectangleF
     * @uses RectangleF::setLocation()
     * @uses RectangleF::setSize()
     * @uses RectangleF::setX()
     * @uses RectangleF::setY()
     * @uses RectangleF::setWidth()
     * @uses RectangleF::setHeight()
     * @param \\NineDotMedia\Viapost\Struct\PointF $location
     * @param \\NineDotMedia\Viapost\Struct\SizeF $size
     * @param float $x
     * @param float $y
     * @param float $width
     * @param float $height
     */
    public function __construct(\\NineDotMedia\Viapost\Struct\PointF $location = null, \\NineDotMedia\Viapost\Struct\SizeF $size = null, $x = null, $y = null, $width = null, $height = null)
    {
        $this
            ->setLocation($location)
            ->setSize($size)
            ->setX($x)
            ->setY($y)
            ->setWidth($width)
            ->setHeight($height);
    }
    /**
     * Get Location value
     * @return \\NineDotMedia\Viapost\Struct\PointF
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param \\NineDotMedia\Viapost\Struct\PointF $location
     * @return \\NineDotMedia\Viapost\Struct\RectangleF
     */
    public function setLocation(\\NineDotMedia\Viapost\Struct\PointF $location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Get Size value
     * @return \\NineDotMedia\Viapost\Struct\SizeF
     */
    public function getSize()
    {
        return $this->Size;
    }
    /**
     * Set Size value
     * @param \\NineDotMedia\Viapost\Struct\SizeF $size
     * @return \\NineDotMedia\Viapost\Struct\RectangleF
     */
    public function setSize(\\NineDotMedia\Viapost\Struct\SizeF $size = null)
    {
        $this->Size = $size;
        return $this;
    }
    /**
     * Get X value
     * @return float
     */
    public function getX()
    {
        return $this->X;
    }
    /**
     * Set X value
     * @param float $x
     * @return \\NineDotMedia\Viapost\Struct\RectangleF
     */
    public function setX($x = null)
    {
        // validation for constraint: float
        if (!is_null($x) && !(is_float($x) || is_numeric($x))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($x, true), gettype($x)), __LINE__);
        }
        $this->X = $x;
        return $this;
    }
    /**
     * Get Y value
     * @return float
     */
    public function getY()
    {
        return $this->Y;
    }
    /**
     * Set Y value
     * @param float $y
     * @return \\NineDotMedia\Viapost\Struct\RectangleF
     */
    public function setY($y = null)
    {
        // validation for constraint: float
        if (!is_null($y) && !(is_float($y) || is_numeric($y))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($y, true), gettype($y)), __LINE__);
        }
        $this->Y = $y;
        return $this;
    }
    /**
     * Get Width value
     * @return float
     */
    public function getWidth()
    {
        return $this->Width;
    }
    /**
     * Set Width value
     * @param float $width
     * @return \\NineDotMedia\Viapost\Struct\RectangleF
     */
    public function setWidth($width = null)
    {
        // validation for constraint: float
        if (!is_null($width) && !(is_float($width) || is_numeric($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        $this->Width = $width;
        return $this;
    }
    /**
     * Get Height value
     * @return float
     */
    public function getHeight()
    {
        return $this->Height;
    }
    /**
     * Set Height value
     * @param float $height
     * @return \\NineDotMedia\Viapost\Struct\RectangleF
     */
    public function setHeight($height = null)
    {
        // validation for constraint: float
        if (!is_null($height) && !(is_float($height) || is_numeric($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        $this->Height = $height;
        return $this;
    }
}
