<?php

namespace \NineDotMedia\Viapost\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteMailPack Struct
 * @subpackage Structs
 */
class DeleteMailPack extends AbstractStructBase
{
    /**
     * The mailPackID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $mailPackID;
    /**
     * The sLoginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sLoginToken;
    /**
     * The sReturnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sReturnMessage;
    /**
     * Constructor method for DeleteMailPack
     * @uses DeleteMailPack::setMailPackID()
     * @uses DeleteMailPack::setSLoginToken()
     * @uses DeleteMailPack::setSReturnMessage()
     * @param int $mailPackID
     * @param string $sLoginToken
     * @param string $sReturnMessage
     */
    public function __construct($mailPackID = null, $sLoginToken = null, $sReturnMessage = null)
    {
        $this
            ->setMailPackID($mailPackID)
            ->setSLoginToken($sLoginToken)
            ->setSReturnMessage($sReturnMessage);
    }
    /**
     * Get mailPackID value
     * @return int
     */
    public function getMailPackID()
    {
        return $this->mailPackID;
    }
    /**
     * Set mailPackID value
     * @param int $mailPackID
     * @return \\NineDotMedia\Viapost\Struct\DeleteMailPack
     */
    public function setMailPackID($mailPackID = null)
    {
        // validation for constraint: int
        if (!is_null($mailPackID) && !(is_int($mailPackID) || ctype_digit($mailPackID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mailPackID, true), gettype($mailPackID)), __LINE__);
        }
        $this->mailPackID = $mailPackID;
        return $this;
    }
    /**
     * Get sLoginToken value
     * @return string|null
     */
    public function getSLoginToken()
    {
        return $this->sLoginToken;
    }
    /**
     * Set sLoginToken value
     * @param string $sLoginToken
     * @return \\NineDotMedia\Viapost\Struct\DeleteMailPack
     */
    public function setSLoginToken($sLoginToken = null)
    {
        // validation for constraint: string
        if (!is_null($sLoginToken) && !is_string($sLoginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sLoginToken, true), gettype($sLoginToken)), __LINE__);
        }
        $this->sLoginToken = $sLoginToken;
        return $this;
    }
    /**
     * Get sReturnMessage value
     * @return string|null
     */
    public function getSReturnMessage()
    {
        return $this->sReturnMessage;
    }
    /**
     * Set sReturnMessage value
     * @param string $sReturnMessage
     * @return \\NineDotMedia\Viapost\Struct\DeleteMailPack
     */
    public function setSReturnMessage($sReturnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($sReturnMessage) && !is_string($sReturnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sReturnMessage, true), gettype($sReturnMessage)), __LINE__);
        }
        $this->sReturnMessage = $sReturnMessage;
        return $this;
    }
}
