<?php

namespace \NineDotMedia\Viapost\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalculateCostOfFindNearestMailing Struct
 * @subpackage Structs
 */
class CalculateCostOfFindNearestMailing extends AbstractStructBase
{
    /**
     * The documentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $documentType;
    /**
     * The documentID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $documentID;
    /**
     * The colour
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $colour;
    /**
     * The simplex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $simplex;
    /**
     * The numberOfAddressesToSearch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $numberOfAddressesToSearch;
    /**
     * The radiusOfAreaToSearchInMetres
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $radiusOfAreaToSearchInMetres;
    /**
     * The includeThisAddressInResults
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $includeThisAddressInResults;
    /**
     * The onlyAddressesInThisStreet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $onlyAddressesInThisStreet;
    /**
     * The addressTypes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $addressTypes;
    /**
     * The costOfMailing
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $costOfMailing;
    /**
     * The numberOfPages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $numberOfPages;
    /**
     * The numberOfSheets
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $numberOfSheets;
    /**
     * The numberOfAddressesFound
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $numberOfAddressesFound;
    /**
     * The loginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginToken;
    /**
     * The firstClassStr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $firstClassStr;
    /**
     * The insertsStr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $insertsStr;
    /**
     * The houseNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $houseNumber;
    /**
     * The houseName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $houseName;
    /**
     * The organisation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $organisation;
    /**
     * The postCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $postCode;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for CalculateCostOfFindNearestMailing
     * @uses CalculateCostOfFindNearestMailing::setDocumentType()
     * @uses CalculateCostOfFindNearestMailing::setDocumentID()
     * @uses CalculateCostOfFindNearestMailing::setColour()
     * @uses CalculateCostOfFindNearestMailing::setSimplex()
     * @uses CalculateCostOfFindNearestMailing::setNumberOfAddressesToSearch()
     * @uses CalculateCostOfFindNearestMailing::setRadiusOfAreaToSearchInMetres()
     * @uses CalculateCostOfFindNearestMailing::setIncludeThisAddressInResults()
     * @uses CalculateCostOfFindNearestMailing::setOnlyAddressesInThisStreet()
     * @uses CalculateCostOfFindNearestMailing::setAddressTypes()
     * @uses CalculateCostOfFindNearestMailing::setCostOfMailing()
     * @uses CalculateCostOfFindNearestMailing::setNumberOfPages()
     * @uses CalculateCostOfFindNearestMailing::setNumberOfSheets()
     * @uses CalculateCostOfFindNearestMailing::setNumberOfAddressesFound()
     * @uses CalculateCostOfFindNearestMailing::setLoginToken()
     * @uses CalculateCostOfFindNearestMailing::setFirstClassStr()
     * @uses CalculateCostOfFindNearestMailing::setInsertsStr()
     * @uses CalculateCostOfFindNearestMailing::setHouseNumber()
     * @uses CalculateCostOfFindNearestMailing::setHouseName()
     * @uses CalculateCostOfFindNearestMailing::setOrganisation()
     * @uses CalculateCostOfFindNearestMailing::setPostCode()
     * @uses CalculateCostOfFindNearestMailing::setReturnMessage()
     * @param string $documentType
     * @param int $documentID
     * @param bool $colour
     * @param bool $simplex
     * @param int $numberOfAddressesToSearch
     * @param int $radiusOfAreaToSearchInMetres
     * @param bool $includeThisAddressInResults
     * @param bool $onlyAddressesInThisStreet
     * @param string $addressTypes
     * @param float $costOfMailing
     * @param int $numberOfPages
     * @param int $numberOfSheets
     * @param int $numberOfAddressesFound
     * @param string $loginToken
     * @param string $firstClassStr
     * @param string $insertsStr
     * @param string $houseNumber
     * @param string $houseName
     * @param string $organisation
     * @param string $postCode
     * @param string $returnMessage
     */
    public function __construct($documentType = null, $documentID = null, $colour = null, $simplex = null, $numberOfAddressesToSearch = null, $radiusOfAreaToSearchInMetres = null, $includeThisAddressInResults = null, $onlyAddressesInThisStreet = null, $addressTypes = null, $costOfMailing = null, $numberOfPages = null, $numberOfSheets = null, $numberOfAddressesFound = null, $loginToken = null, $firstClassStr = null, $insertsStr = null, $houseNumber = null, $houseName = null, $organisation = null, $postCode = null, $returnMessage = null)
    {
        $this
            ->setDocumentType($documentType)
            ->setDocumentID($documentID)
            ->setColour($colour)
            ->setSimplex($simplex)
            ->setNumberOfAddressesToSearch($numberOfAddressesToSearch)
            ->setRadiusOfAreaToSearchInMetres($radiusOfAreaToSearchInMetres)
            ->setIncludeThisAddressInResults($includeThisAddressInResults)
            ->setOnlyAddressesInThisStreet($onlyAddressesInThisStreet)
            ->setAddressTypes($addressTypes)
            ->setCostOfMailing($costOfMailing)
            ->setNumberOfPages($numberOfPages)
            ->setNumberOfSheets($numberOfSheets)
            ->setNumberOfAddressesFound($numberOfAddressesFound)
            ->setLoginToken($loginToken)
            ->setFirstClassStr($firstClassStr)
            ->setInsertsStr($insertsStr)
            ->setHouseNumber($houseNumber)
            ->setHouseName($houseName)
            ->setOrganisation($organisation)
            ->setPostCode($postCode)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get documentType value
     * @return string
     */
    public function getDocumentType()
    {
        return $this->documentType;
    }
    /**
     * Set documentType value
     * @uses \\NineDotMedia\Viapost\Enum\DocumentType::valueIsValid()
     * @uses \\NineDotMedia\Viapost\Enum\DocumentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $documentType
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfFindNearestMailing
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: enumeration
        if (!\\NineDotMedia\Viapost\Enum\DocumentType::valueIsValid($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \\NineDotMedia\Viapost\Enum\DocumentType', is_array($documentType) ? implode(', ', $documentType) : var_export($documentType, true), implode(', ', \\NineDotMedia\Viapost\Enum\DocumentType::getValidValues())), __LINE__);
        }
        $this->documentType = $documentType;
        return $this;
    }
    /**
     * Get documentID value
     * @return int
     */
    public function getDocumentID()
    {
        return $this->documentID;
    }
    /**
     * Set documentID value
     * @param int $documentID
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfFindNearestMailing
     */
    public function setDocumentID($documentID = null)
    {
        // validation for constraint: int
        if (!is_null($documentID) && !(is_int($documentID) || ctype_digit($documentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentID, true), gettype($documentID)), __LINE__);
        }
        $this->documentID = $documentID;
        return $this;
    }
    /**
     * Get colour value
     * @return bool
     */
    public function getColour()
    {
        return $this->colour;
    }
    /**
     * Set colour value
     * @param bool $colour
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfFindNearestMailing
     */
    public function setColour($colour = null)
    {
        // validation for constraint: boolean
        if (!is_null($colour) && !is_bool($colour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($colour, true), gettype($colour)), __LINE__);
        }
        $this->colour = $colour;
        return $this;
    }
    /**
     * Get simplex value
     * @return bool
     */
    public function getSimplex()
    {
        return $this->simplex;
    }
    /**
     * Set simplex value
     * @param bool $simplex
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfFindNearestMailing
     */
    public function setSimplex($simplex = null)
    {
        // validation for constraint: boolean
        if (!is_null($simplex) && !is_bool($simplex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($simplex, true), gettype($simplex)), __LINE__);
        }
        $this->simplex = $simplex;
        return $this;
    }
    /**
     * Get numberOfAddressesToSearch value
     * @return int
     */
    public function getNumberOfAddressesToSearch()
    {
        return $this->numberOfAddressesToSearch;
    }
    /**
     * Set numberOfAddressesToSearch value
     * @param int $numberOfAddressesToSearch
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfFindNearestMailing
     */
    public function setNumberOfAddressesToSearch($numberOfAddressesToSearch = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfAddressesToSearch) && !(is_int($numberOfAddressesToSearch) || ctype_digit($numberOfAddressesToSearch))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfAddressesToSearch, true), gettype($numberOfAddressesToSearch)), __LINE__);
        }
        $this->numberOfAddressesToSearch = $numberOfAddressesToSearch;
        return $this;
    }
    /**
     * Get radiusOfAreaToSearchInMetres value
     * @return int
     */
    public function getRadiusOfAreaToSearchInMetres()
    {
        return $this->radiusOfAreaToSearchInMetres;
    }
    /**
     * Set radiusOfAreaToSearchInMetres value
     * @param int $radiusOfAreaToSearchInMetres
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfFindNearestMailing
     */
    public function setRadiusOfAreaToSearchInMetres($radiusOfAreaToSearchInMetres = null)
    {
        // validation for constraint: int
        if (!is_null($radiusOfAreaToSearchInMetres) && !(is_int($radiusOfAreaToSearchInMetres) || ctype_digit($radiusOfAreaToSearchInMetres))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($radiusOfAreaToSearchInMetres, true), gettype($radiusOfAreaToSearchInMetres)), __LINE__);
        }
        $this->radiusOfAreaToSearchInMetres = $radiusOfAreaToSearchInMetres;
        return $this;
    }
    /**
     * Get includeThisAddressInResults value
     * @return bool
     */
    public function getIncludeThisAddressInResults()
    {
        return $this->includeThisAddressInResults;
    }
    /**
     * Set includeThisAddressInResults value
     * @param bool $includeThisAddressInResults
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfFindNearestMailing
     */
    public function setIncludeThisAddressInResults($includeThisAddressInResults = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeThisAddressInResults) && !is_bool($includeThisAddressInResults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeThisAddressInResults, true), gettype($includeThisAddressInResults)), __LINE__);
        }
        $this->includeThisAddressInResults = $includeThisAddressInResults;
        return $this;
    }
    /**
     * Get onlyAddressesInThisStreet value
     * @return bool
     */
    public function getOnlyAddressesInThisStreet()
    {
        return $this->onlyAddressesInThisStreet;
    }
    /**
     * Set onlyAddressesInThisStreet value
     * @param bool $onlyAddressesInThisStreet
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfFindNearestMailing
     */
    public function setOnlyAddressesInThisStreet($onlyAddressesInThisStreet = null)
    {
        // validation for constraint: boolean
        if (!is_null($onlyAddressesInThisStreet) && !is_bool($onlyAddressesInThisStreet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onlyAddressesInThisStreet, true), gettype($onlyAddressesInThisStreet)), __LINE__);
        }
        $this->onlyAddressesInThisStreet = $onlyAddressesInThisStreet;
        return $this;
    }
    /**
     * Get addressTypes value
     * @return string
     */
    public function getAddressTypes()
    {
        return $this->addressTypes;
    }
    /**
     * Set addressTypes value
     * @uses \\NineDotMedia\Viapost\Enum\FindNearestAddressTypes::valueIsValid()
     * @uses \\NineDotMedia\Viapost\Enum\FindNearestAddressTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $addressTypes
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfFindNearestMailing
     */
    public function setAddressTypes($addressTypes = null)
    {
        // validation for constraint: enumeration
        if (!\\NineDotMedia\Viapost\Enum\FindNearestAddressTypes::valueIsValid($addressTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \\NineDotMedia\Viapost\Enum\FindNearestAddressTypes', is_array($addressTypes) ? implode(', ', $addressTypes) : var_export($addressTypes, true), implode(', ', \\NineDotMedia\Viapost\Enum\FindNearestAddressTypes::getValidValues())), __LINE__);
        }
        $this->addressTypes = $addressTypes;
        return $this;
    }
    /**
     * Get costOfMailing value
     * @return float
     */
    public function getCostOfMailing()
    {
        return $this->costOfMailing;
    }
    /**
     * Set costOfMailing value
     * @param float $costOfMailing
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfFindNearestMailing
     */
    public function setCostOfMailing($costOfMailing = null)
    {
        // validation for constraint: float
        if (!is_null($costOfMailing) && !(is_float($costOfMailing) || is_numeric($costOfMailing))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($costOfMailing, true), gettype($costOfMailing)), __LINE__);
        }
        $this->costOfMailing = $costOfMailing;
        return $this;
    }
    /**
     * Get numberOfPages value
     * @return int
     */
    public function getNumberOfPages()
    {
        return $this->numberOfPages;
    }
    /**
     * Set numberOfPages value
     * @param int $numberOfPages
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfFindNearestMailing
     */
    public function setNumberOfPages($numberOfPages = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfPages) && !(is_int($numberOfPages) || ctype_digit($numberOfPages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfPages, true), gettype($numberOfPages)), __LINE__);
        }
        $this->numberOfPages = $numberOfPages;
        return $this;
    }
    /**
     * Get numberOfSheets value
     * @return int
     */
    public function getNumberOfSheets()
    {
        return $this->numberOfSheets;
    }
    /**
     * Set numberOfSheets value
     * @param int $numberOfSheets
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfFindNearestMailing
     */
    public function setNumberOfSheets($numberOfSheets = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfSheets) && !(is_int($numberOfSheets) || ctype_digit($numberOfSheets))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfSheets, true), gettype($numberOfSheets)), __LINE__);
        }
        $this->numberOfSheets = $numberOfSheets;
        return $this;
    }
    /**
     * Get numberOfAddressesFound value
     * @return int
     */
    public function getNumberOfAddressesFound()
    {
        return $this->numberOfAddressesFound;
    }
    /**
     * Set numberOfAddressesFound value
     * @param int $numberOfAddressesFound
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfFindNearestMailing
     */
    public function setNumberOfAddressesFound($numberOfAddressesFound = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfAddressesFound) && !(is_int($numberOfAddressesFound) || ctype_digit($numberOfAddressesFound))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfAddressesFound, true), gettype($numberOfAddressesFound)), __LINE__);
        }
        $this->numberOfAddressesFound = $numberOfAddressesFound;
        return $this;
    }
    /**
     * Get loginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->loginToken;
    }
    /**
     * Set loginToken value
     * @param string $loginToken
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfFindNearestMailing
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->loginToken = $loginToken;
        return $this;
    }
    /**
     * Get firstClassStr value
     * @return string|null
     */
    public function getFirstClassStr()
    {
        return $this->firstClassStr;
    }
    /**
     * Set firstClassStr value
     * @param string $firstClassStr
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfFindNearestMailing
     */
    public function setFirstClassStr($firstClassStr = null)
    {
        // validation for constraint: string
        if (!is_null($firstClassStr) && !is_string($firstClassStr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstClassStr, true), gettype($firstClassStr)), __LINE__);
        }
        $this->firstClassStr = $firstClassStr;
        return $this;
    }
    /**
     * Get insertsStr value
     * @return string|null
     */
    public function getInsertsStr()
    {
        return $this->insertsStr;
    }
    /**
     * Set insertsStr value
     * @param string $insertsStr
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfFindNearestMailing
     */
    public function setInsertsStr($insertsStr = null)
    {
        // validation for constraint: string
        if (!is_null($insertsStr) && !is_string($insertsStr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insertsStr, true), gettype($insertsStr)), __LINE__);
        }
        $this->insertsStr = $insertsStr;
        return $this;
    }
    /**
     * Get houseNumber value
     * @return string|null
     */
    public function getHouseNumber()
    {
        return $this->houseNumber;
    }
    /**
     * Set houseNumber value
     * @param string $houseNumber
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfFindNearestMailing
     */
    public function setHouseNumber($houseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($houseNumber) && !is_string($houseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($houseNumber, true), gettype($houseNumber)), __LINE__);
        }
        $this->houseNumber = $houseNumber;
        return $this;
    }
    /**
     * Get houseName value
     * @return string|null
     */
    public function getHouseName()
    {
        return $this->houseName;
    }
    /**
     * Set houseName value
     * @param string $houseName
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfFindNearestMailing
     */
    public function setHouseName($houseName = null)
    {
        // validation for constraint: string
        if (!is_null($houseName) && !is_string($houseName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($houseName, true), gettype($houseName)), __LINE__);
        }
        $this->houseName = $houseName;
        return $this;
    }
    /**
     * Get organisation value
     * @return string|null
     */
    public function getOrganisation()
    {
        return $this->organisation;
    }
    /**
     * Set organisation value
     * @param string $organisation
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfFindNearestMailing
     */
    public function setOrganisation($organisation = null)
    {
        // validation for constraint: string
        if (!is_null($organisation) && !is_string($organisation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organisation, true), gettype($organisation)), __LINE__);
        }
        $this->organisation = $organisation;
        return $this;
    }
    /**
     * Get postCode value
     * @return string|null
     */
    public function getPostCode()
    {
        return $this->postCode;
    }
    /**
     * Set postCode value
     * @param string $postCode
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfFindNearestMailing
     */
    public function setPostCode($postCode = null)
    {
        // validation for constraint: string
        if (!is_null($postCode) && !is_string($postCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postCode, true), gettype($postCode)), __LINE__);
        }
        $this->postCode = $postCode;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \\NineDotMedia\Viapost\Struct\CalculateCostOfFindNearestMailing
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
