<?php

namespace \NineDotMedia\viapost-php\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateMailPackTemplate StructType
 * @subpackage Structs
 */
class UpdateMailPackTemplate extends AbstractStructBase
{
    /**
     * The mailpackID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $mailpackID;
    /**
     * The templateID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $templateID;
    /**
     * The loginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginToken;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for UpdateMailPackTemplate
     * @uses UpdateMailPackTemplate::setMailpackID()
     * @uses UpdateMailPackTemplate::setTemplateID()
     * @uses UpdateMailPackTemplate::setLoginToken()
     * @uses UpdateMailPackTemplate::setReturnMessage()
     * @param int $mailpackID
     * @param int $templateID
     * @param string $loginToken
     * @param string $returnMessage
     */
    public function __construct($mailpackID = null, $templateID = null, $loginToken = null, $returnMessage = null)
    {
        $this
            ->setMailpackID($mailpackID)
            ->setTemplateID($templateID)
            ->setLoginToken($loginToken)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get mailpackID value
     * @return int
     */
    public function getMailpackID()
    {
        return $this->mailpackID;
    }
    /**
     * Set mailpackID value
     * @param int $mailpackID
     * @return \\NineDotMedia\viapost-php\StructType\UpdateMailPackTemplate
     */
    public function setMailpackID($mailpackID = null)
    {
        // validation for constraint: int
        if (!is_null($mailpackID) && !(is_int($mailpackID) || ctype_digit($mailpackID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mailpackID, true), gettype($mailpackID)), __LINE__);
        }
        $this->mailpackID = $mailpackID;
        return $this;
    }
    /**
     * Get templateID value
     * @return int
     */
    public function getTemplateID()
    {
        return $this->templateID;
    }
    /**
     * Set templateID value
     * @param int $templateID
     * @return \\NineDotMedia\viapost-php\StructType\UpdateMailPackTemplate
     */
    public function setTemplateID($templateID = null)
    {
        // validation for constraint: int
        if (!is_null($templateID) && !(is_int($templateID) || ctype_digit($templateID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($templateID, true), gettype($templateID)), __LINE__);
        }
        $this->templateID = $templateID;
        return $this;
    }
    /**
     * Get loginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->loginToken;
    }
    /**
     * Set loginToken value
     * @param string $loginToken
     * @return \\NineDotMedia\viapost-php\StructType\UpdateMailPackTemplate
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->loginToken = $loginToken;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \\NineDotMedia\viapost-php\StructType\UpdateMailPackTemplate
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
