<?php

namespace \NineDotMedia\viapost-php\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JobRun StructType
 * @subpackage Structs
 */
class JobRun extends AbstractStructBase
{
    /**
     * The JobId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $JobId;
    /**
     * The DateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateTime;
    /**
     * The Pages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Pages;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Quantity;
    /**
     * The TotalCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalCost;
    /**
     * The NetCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $NetCost;
    /**
     * The VatCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $VatCost;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for JobRun
     * @uses JobRun::setJobId()
     * @uses JobRun::setDateTime()
     * @uses JobRun::setPages()
     * @uses JobRun::setQuantity()
     * @uses JobRun::setTotalCost()
     * @uses JobRun::setNetCost()
     * @uses JobRun::setVatCost()
     * @uses JobRun::setDescription()
     * @param int $jobId
     * @param string $dateTime
     * @param int $pages
     * @param int $quantity
     * @param float $totalCost
     * @param float $netCost
     * @param float $vatCost
     * @param string $description
     */
    public function __construct($jobId = null, $dateTime = null, $pages = null, $quantity = null, $totalCost = null, $netCost = null, $vatCost = null, $description = null)
    {
        $this
            ->setJobId($jobId)
            ->setDateTime($dateTime)
            ->setPages($pages)
            ->setQuantity($quantity)
            ->setTotalCost($totalCost)
            ->setNetCost($netCost)
            ->setVatCost($vatCost)
            ->setDescription($description);
    }
    /**
     * Get JobId value
     * @return int
     */
    public function getJobId()
    {
        return $this->JobId;
    }
    /**
     * Set JobId value
     * @param int $jobId
     * @return \\NineDotMedia\viapost-php\StructType\JobRun
     */
    public function setJobId($jobId = null)
    {
        // validation for constraint: int
        if (!is_null($jobId) && !(is_int($jobId) || ctype_digit($jobId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($jobId, true), gettype($jobId)), __LINE__);
        }
        $this->JobId = $jobId;
        return $this;
    }
    /**
     * Get DateTime value
     * @return string
     */
    public function getDateTime()
    {
        return $this->DateTime;
    }
    /**
     * Set DateTime value
     * @param string $dateTime
     * @return \\NineDotMedia\viapost-php\StructType\JobRun
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTime, true), gettype($dateTime)), __LINE__);
        }
        $this->DateTime = $dateTime;
        return $this;
    }
    /**
     * Get Pages value
     * @return int
     */
    public function getPages()
    {
        return $this->Pages;
    }
    /**
     * Set Pages value
     * @param int $pages
     * @return \\NineDotMedia\viapost-php\StructType\JobRun
     */
    public function setPages($pages = null)
    {
        // validation for constraint: int
        if (!is_null($pages) && !(is_int($pages) || ctype_digit($pages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pages, true), gettype($pages)), __LINE__);
        }
        $this->Pages = $pages;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \\NineDotMedia\viapost-php\StructType\JobRun
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get TotalCost value
     * @return float
     */
    public function getTotalCost()
    {
        return $this->TotalCost;
    }
    /**
     * Set TotalCost value
     * @param float $totalCost
     * @return \\NineDotMedia\viapost-php\StructType\JobRun
     */
    public function setTotalCost($totalCost = null)
    {
        // validation for constraint: float
        if (!is_null($totalCost) && !(is_float($totalCost) || is_numeric($totalCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalCost, true), gettype($totalCost)), __LINE__);
        }
        $this->TotalCost = $totalCost;
        return $this;
    }
    /**
     * Get NetCost value
     * @return float
     */
    public function getNetCost()
    {
        return $this->NetCost;
    }
    /**
     * Set NetCost value
     * @param float $netCost
     * @return \\NineDotMedia\viapost-php\StructType\JobRun
     */
    public function setNetCost($netCost = null)
    {
        // validation for constraint: float
        if (!is_null($netCost) && !(is_float($netCost) || is_numeric($netCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($netCost, true), gettype($netCost)), __LINE__);
        }
        $this->NetCost = $netCost;
        return $this;
    }
    /**
     * Get VatCost value
     * @return float
     */
    public function getVatCost()
    {
        return $this->VatCost;
    }
    /**
     * Set VatCost value
     * @param float $vatCost
     * @return \\NineDotMedia\viapost-php\StructType\JobRun
     */
    public function setVatCost($vatCost = null)
    {
        // validation for constraint: float
        if (!is_null($vatCost) && !(is_float($vatCost) || is_numeric($vatCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vatCost, true), gettype($vatCost)), __LINE__);
        }
        $this->VatCost = $vatCost;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \\NineDotMedia\viapost-php\StructType\JobRun
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
}
