<?php

namespace \NineDotMedia\viapost-php\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeletePostcard StructType
 * @subpackage Structs
 */
class DeletePostcard extends AbstractStructBase
{
    /**
     * The postcardID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $postcardID;
    /**
     * The sLoginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sLoginToken;
    /**
     * The sReturnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sReturnMessage;
    /**
     * Constructor method for DeletePostcard
     * @uses DeletePostcard::setPostcardID()
     * @uses DeletePostcard::setSLoginToken()
     * @uses DeletePostcard::setSReturnMessage()
     * @param int $postcardID
     * @param string $sLoginToken
     * @param string $sReturnMessage
     */
    public function __construct($postcardID = null, $sLoginToken = null, $sReturnMessage = null)
    {
        $this
            ->setPostcardID($postcardID)
            ->setSLoginToken($sLoginToken)
            ->setSReturnMessage($sReturnMessage);
    }
    /**
     * Get postcardID value
     * @return int
     */
    public function getPostcardID()
    {
        return $this->postcardID;
    }
    /**
     * Set postcardID value
     * @param int $postcardID
     * @return \\NineDotMedia\viapost-php\StructType\DeletePostcard
     */
    public function setPostcardID($postcardID = null)
    {
        // validation for constraint: int
        if (!is_null($postcardID) && !(is_int($postcardID) || ctype_digit($postcardID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($postcardID, true), gettype($postcardID)), __LINE__);
        }
        $this->postcardID = $postcardID;
        return $this;
    }
    /**
     * Get sLoginToken value
     * @return string|null
     */
    public function getSLoginToken()
    {
        return $this->sLoginToken;
    }
    /**
     * Set sLoginToken value
     * @param string $sLoginToken
     * @return \\NineDotMedia\viapost-php\StructType\DeletePostcard
     */
    public function setSLoginToken($sLoginToken = null)
    {
        // validation for constraint: string
        if (!is_null($sLoginToken) && !is_string($sLoginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sLoginToken, true), gettype($sLoginToken)), __LINE__);
        }
        $this->sLoginToken = $sLoginToken;
        return $this;
    }
    /**
     * Get sReturnMessage value
     * @return string|null
     */
    public function getSReturnMessage()
    {
        return $this->sReturnMessage;
    }
    /**
     * Set sReturnMessage value
     * @param string $sReturnMessage
     * @return \\NineDotMedia\viapost-php\StructType\DeletePostcard
     */
    public function setSReturnMessage($sReturnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($sReturnMessage) && !is_string($sReturnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sReturnMessage, true), gettype($sReturnMessage)), __LINE__);
        }
        $this->sReturnMessage = $sReturnMessage;
        return $this;
    }
}
