<?php

namespace \NineDotMedia\viapost-php\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataList StructType
 * @subpackage Structs
 */
class DataList extends AbstractStructBase
{
    /**
     * The DataListId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DataListId;
    /**
     * The NumberOfItems
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfItems;
    /**
     * The PurchaseDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PurchaseDate;
    /**
     * The ExpiryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ExpiryDate;
    /**
     * The CurrentUseCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CurrentUseCount;
    /**
     * The MaximumUseCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MaximumUseCount;
    /**
     * The EnableDownload
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $EnableDownload;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for DataList
     * @uses DataList::setDataListId()
     * @uses DataList::setNumberOfItems()
     * @uses DataList::setPurchaseDate()
     * @uses DataList::setExpiryDate()
     * @uses DataList::setCurrentUseCount()
     * @uses DataList::setMaximumUseCount()
     * @uses DataList::setEnableDownload()
     * @uses DataList::setName()
     * @uses DataList::setDescription()
     * @param int $dataListId
     * @param int $numberOfItems
     * @param string $purchaseDate
     * @param string $expiryDate
     * @param int $currentUseCount
     * @param int $maximumUseCount
     * @param bool $enableDownload
     * @param string $name
     * @param string $description
     */
    public function __construct($dataListId = null, $numberOfItems = null, $purchaseDate = null, $expiryDate = null, $currentUseCount = null, $maximumUseCount = null, $enableDownload = null, $name = null, $description = null)
    {
        $this
            ->setDataListId($dataListId)
            ->setNumberOfItems($numberOfItems)
            ->setPurchaseDate($purchaseDate)
            ->setExpiryDate($expiryDate)
            ->setCurrentUseCount($currentUseCount)
            ->setMaximumUseCount($maximumUseCount)
            ->setEnableDownload($enableDownload)
            ->setName($name)
            ->setDescription($description);
    }
    /**
     * Get DataListId value
     * @return int
     */
    public function getDataListId()
    {
        return $this->DataListId;
    }
    /**
     * Set DataListId value
     * @param int $dataListId
     * @return \\NineDotMedia\viapost-php\StructType\DataList
     */
    public function setDataListId($dataListId = null)
    {
        // validation for constraint: int
        if (!is_null($dataListId) && !(is_int($dataListId) || ctype_digit($dataListId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dataListId, true), gettype($dataListId)), __LINE__);
        }
        $this->DataListId = $dataListId;
        return $this;
    }
    /**
     * Get NumberOfItems value
     * @return int
     */
    public function getNumberOfItems()
    {
        return $this->NumberOfItems;
    }
    /**
     * Set NumberOfItems value
     * @param int $numberOfItems
     * @return \\NineDotMedia\viapost-php\StructType\DataList
     */
    public function setNumberOfItems($numberOfItems = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfItems) && !(is_int($numberOfItems) || ctype_digit($numberOfItems))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfItems, true), gettype($numberOfItems)), __LINE__);
        }
        $this->NumberOfItems = $numberOfItems;
        return $this;
    }
    /**
     * Get PurchaseDate value
     * @return string
     */
    public function getPurchaseDate()
    {
        return $this->PurchaseDate;
    }
    /**
     * Set PurchaseDate value
     * @param string $purchaseDate
     * @return \\NineDotMedia\viapost-php\StructType\DataList
     */
    public function setPurchaseDate($purchaseDate = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseDate) && !is_string($purchaseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseDate, true), gettype($purchaseDate)), __LINE__);
        }
        $this->PurchaseDate = $purchaseDate;
        return $this;
    }
    /**
     * Get ExpiryDate value
     * @return string
     */
    public function getExpiryDate()
    {
        return $this->ExpiryDate;
    }
    /**
     * Set ExpiryDate value
     * @param string $expiryDate
     * @return \\NineDotMedia\viapost-php\StructType\DataList
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDate, true), gettype($expiryDate)), __LINE__);
        }
        $this->ExpiryDate = $expiryDate;
        return $this;
    }
    /**
     * Get CurrentUseCount value
     * @return int
     */
    public function getCurrentUseCount()
    {
        return $this->CurrentUseCount;
    }
    /**
     * Set CurrentUseCount value
     * @param int $currentUseCount
     * @return \\NineDotMedia\viapost-php\StructType\DataList
     */
    public function setCurrentUseCount($currentUseCount = null)
    {
        // validation for constraint: int
        if (!is_null($currentUseCount) && !(is_int($currentUseCount) || ctype_digit($currentUseCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currentUseCount, true), gettype($currentUseCount)), __LINE__);
        }
        $this->CurrentUseCount = $currentUseCount;
        return $this;
    }
    /**
     * Get MaximumUseCount value
     * @return int
     */
    public function getMaximumUseCount()
    {
        return $this->MaximumUseCount;
    }
    /**
     * Set MaximumUseCount value
     * @param int $maximumUseCount
     * @return \\NineDotMedia\viapost-php\StructType\DataList
     */
    public function setMaximumUseCount($maximumUseCount = null)
    {
        // validation for constraint: int
        if (!is_null($maximumUseCount) && !(is_int($maximumUseCount) || ctype_digit($maximumUseCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumUseCount, true), gettype($maximumUseCount)), __LINE__);
        }
        $this->MaximumUseCount = $maximumUseCount;
        return $this;
    }
    /**
     * Get EnableDownload value
     * @return bool
     */
    public function getEnableDownload()
    {
        return $this->EnableDownload;
    }
    /**
     * Set EnableDownload value
     * @param bool $enableDownload
     * @return \\NineDotMedia\viapost-php\StructType\DataList
     */
    public function setEnableDownload($enableDownload = null)
    {
        // validation for constraint: boolean
        if (!is_null($enableDownload) && !is_bool($enableDownload)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enableDownload, true), gettype($enableDownload)), __LINE__);
        }
        $this->EnableDownload = $enableDownload;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \\NineDotMedia\viapost-php\StructType\DataList
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \\NineDotMedia\viapost-php\StructType\DataList
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
}
