<?php

namespace \NineDotMedia\viapost-php\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Attachment StructType
 * @subpackage Structs
 */
class Attachment extends AbstractStructBase
{
    /**
     * The AttachmentId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AttachmentId;
    /**
     * The IsShared
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsShared;
    /**
     * The NumberOfPages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfPages;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for Attachment
     * @uses Attachment::setAttachmentId()
     * @uses Attachment::setIsShared()
     * @uses Attachment::setNumberOfPages()
     * @uses Attachment::setName()
     * @uses Attachment::setDescription()
     * @param int $attachmentId
     * @param bool $isShared
     * @param int $numberOfPages
     * @param string $name
     * @param string $description
     */
    public function __construct($attachmentId = null, $isShared = null, $numberOfPages = null, $name = null, $description = null)
    {
        $this
            ->setAttachmentId($attachmentId)
            ->setIsShared($isShared)
            ->setNumberOfPages($numberOfPages)
            ->setName($name)
            ->setDescription($description);
    }
    /**
     * Get AttachmentId value
     * @return int
     */
    public function getAttachmentId()
    {
        return $this->AttachmentId;
    }
    /**
     * Set AttachmentId value
     * @param int $attachmentId
     * @return \\NineDotMedia\viapost-php\StructType\Attachment
     */
    public function setAttachmentId($attachmentId = null)
    {
        // validation for constraint: int
        if (!is_null($attachmentId) && !(is_int($attachmentId) || ctype_digit($attachmentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($attachmentId, true), gettype($attachmentId)), __LINE__);
        }
        $this->AttachmentId = $attachmentId;
        return $this;
    }
    /**
     * Get IsShared value
     * @return bool
     */
    public function getIsShared()
    {
        return $this->IsShared;
    }
    /**
     * Set IsShared value
     * @param bool $isShared
     * @return \\NineDotMedia\viapost-php\StructType\Attachment
     */
    public function setIsShared($isShared = null)
    {
        // validation for constraint: boolean
        if (!is_null($isShared) && !is_bool($isShared)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isShared, true), gettype($isShared)), __LINE__);
        }
        $this->IsShared = $isShared;
        return $this;
    }
    /**
     * Get NumberOfPages value
     * @return int
     */
    public function getNumberOfPages()
    {
        return $this->NumberOfPages;
    }
    /**
     * Set NumberOfPages value
     * @param int $numberOfPages
     * @return \\NineDotMedia\viapost-php\StructType\Attachment
     */
    public function setNumberOfPages($numberOfPages = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfPages) && !(is_int($numberOfPages) || ctype_digit($numberOfPages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfPages, true), gettype($numberOfPages)), __LINE__);
        }
        $this->NumberOfPages = $numberOfPages;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \\NineDotMedia\viapost-php\StructType\Attachment
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \\NineDotMedia\viapost-php\StructType\Attachment
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
}
