<?php

namespace \NineDotMedia\viapost-php\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPortalUrl StructType
 * @subpackage Structs
 */
class GetPortalUrl extends AbstractStructBase
{
    /**
     * The urlType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $urlType;
    /**
     * The loginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginToken;
    /**
     * The url
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $url;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * Constructor method for GetPortalUrl
     * @uses GetPortalUrl::setUrlType()
     * @uses GetPortalUrl::setLoginToken()
     * @uses GetPortalUrl::setUrl()
     * @uses GetPortalUrl::setMessage()
     * @param string $urlType
     * @param string $loginToken
     * @param string $url
     * @param string $message
     */
    public function __construct($urlType = null, $loginToken = null, $url = null, $message = null)
    {
        $this
            ->setUrlType($urlType)
            ->setLoginToken($loginToken)
            ->setUrl($url)
            ->setMessage($message);
    }
    /**
     * Get urlType value
     * @return string
     */
    public function getUrlType()
    {
        return $this->urlType;
    }
    /**
     * Set urlType value
     * @uses \\NineDotMedia\viapost-php\EnumType\UrlType::valueIsValid()
     * @uses \\NineDotMedia\viapost-php\EnumType\UrlType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $urlType
     * @return \\NineDotMedia\viapost-php\StructType\GetPortalUrl
     */
    public function setUrlType($urlType = null)
    {
        // validation for constraint: enumeration
        if (!\\NineDotMedia\viapost-php\EnumType\UrlType::valueIsValid($urlType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \\NineDotMedia\viapost-php\EnumType\UrlType', is_array($urlType) ? implode(', ', $urlType) : var_export($urlType, true), implode(', ', \\NineDotMedia\viapost-php\EnumType\UrlType::getValidValues())), __LINE__);
        }
        $this->urlType = $urlType;
        return $this;
    }
    /**
     * Get loginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->loginToken;
    }
    /**
     * Set loginToken value
     * @param string $loginToken
     * @return \\NineDotMedia\viapost-php\StructType\GetPortalUrl
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->loginToken = $loginToken;
        return $this;
    }
    /**
     * Get url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return \\NineDotMedia\viapost-php\StructType\GetPortalUrl
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        $this->url = $url;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \\NineDotMedia\viapost-php\StructType\GetPortalUrl
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
}
