<?php

namespace \NineDotMedia\viapost-php\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteAttachment StructType
 * @subpackage Structs
 */
class DeleteAttachment extends AbstractStructBase
{
    /**
     * The attachmentID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $attachmentID;
    /**
     * The sLoginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sLoginToken;
    /**
     * The sReturnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sReturnMessage;
    /**
     * Constructor method for DeleteAttachment
     * @uses DeleteAttachment::setAttachmentID()
     * @uses DeleteAttachment::setSLoginToken()
     * @uses DeleteAttachment::setSReturnMessage()
     * @param int $attachmentID
     * @param string $sLoginToken
     * @param string $sReturnMessage
     */
    public function __construct($attachmentID = null, $sLoginToken = null, $sReturnMessage = null)
    {
        $this
            ->setAttachmentID($attachmentID)
            ->setSLoginToken($sLoginToken)
            ->setSReturnMessage($sReturnMessage);
    }
    /**
     * Get attachmentID value
     * @return int
     */
    public function getAttachmentID()
    {
        return $this->attachmentID;
    }
    /**
     * Set attachmentID value
     * @param int $attachmentID
     * @return \\NineDotMedia\viapost-php\StructType\DeleteAttachment
     */
    public function setAttachmentID($attachmentID = null)
    {
        // validation for constraint: int
        if (!is_null($attachmentID) && !(is_int($attachmentID) || ctype_digit($attachmentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($attachmentID, true), gettype($attachmentID)), __LINE__);
        }
        $this->attachmentID = $attachmentID;
        return $this;
    }
    /**
     * Get sLoginToken value
     * @return string|null
     */
    public function getSLoginToken()
    {
        return $this->sLoginToken;
    }
    /**
     * Set sLoginToken value
     * @param string $sLoginToken
     * @return \\NineDotMedia\viapost-php\StructType\DeleteAttachment
     */
    public function setSLoginToken($sLoginToken = null)
    {
        // validation for constraint: string
        if (!is_null($sLoginToken) && !is_string($sLoginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sLoginToken, true), gettype($sLoginToken)), __LINE__);
        }
        $this->sLoginToken = $sLoginToken;
        return $this;
    }
    /**
     * Get sReturnMessage value
     * @return string|null
     */
    public function getSReturnMessage()
    {
        return $this->sReturnMessage;
    }
    /**
     * Set sReturnMessage value
     * @param string $sReturnMessage
     * @return \\NineDotMedia\viapost-php\StructType\DeleteAttachment
     */
    public function setSReturnMessage($sReturnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($sReturnMessage) && !is_string($sReturnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sReturnMessage, true), gettype($sReturnMessage)), __LINE__);
        }
        $this->sReturnMessage = $sReturnMessage;
        return $this;
    }
}
