<?php

namespace \NineDotMedia\viapost-php\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreatePriceBand StructType
 * @subpackage Structs
 */
class CreatePriceBand extends AbstractStructBase
{
    /**
     * The BWBaseCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BWBaseCost;
    /**
     * The ColourBaseCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ColourBaseCost;
    /**
     * The RunOnBWCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $RunOnBWCost;
    /**
     * The RunOnColourCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $RunOnColourCost;
    /**
     * The SheetCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $SheetCost;
    /**
     * The PriceBandId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PriceBandId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The sAffiliateGUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAffiliateGUID;
    /**
     * The sReturnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sReturnMessage;
    /**
     * Constructor method for CreatePriceBand
     * @uses CreatePriceBand::setBWBaseCost()
     * @uses CreatePriceBand::setColourBaseCost()
     * @uses CreatePriceBand::setRunOnBWCost()
     * @uses CreatePriceBand::setRunOnColourCost()
     * @uses CreatePriceBand::setSheetCost()
     * @uses CreatePriceBand::setPriceBandId()
     * @uses CreatePriceBand::setDescription()
     * @uses CreatePriceBand::setSAffiliateGUID()
     * @uses CreatePriceBand::setSReturnMessage()
     * @param float $bWBaseCost
     * @param float $colourBaseCost
     * @param float $runOnBWCost
     * @param float $runOnColourCost
     * @param float $sheetCost
     * @param int $priceBandId
     * @param string $description
     * @param string $sAffiliateGUID
     * @param string $sReturnMessage
     */
    public function __construct($bWBaseCost = null, $colourBaseCost = null, $runOnBWCost = null, $runOnColourCost = null, $sheetCost = null, $priceBandId = null, $description = null, $sAffiliateGUID = null, $sReturnMessage = null)
    {
        $this
            ->setBWBaseCost($bWBaseCost)
            ->setColourBaseCost($colourBaseCost)
            ->setRunOnBWCost($runOnBWCost)
            ->setRunOnColourCost($runOnColourCost)
            ->setSheetCost($sheetCost)
            ->setPriceBandId($priceBandId)
            ->setDescription($description)
            ->setSAffiliateGUID($sAffiliateGUID)
            ->setSReturnMessage($sReturnMessage);
    }
    /**
     * Get BWBaseCost value
     * @return float
     */
    public function getBWBaseCost()
    {
        return $this->BWBaseCost;
    }
    /**
     * Set BWBaseCost value
     * @param float $bWBaseCost
     * @return \\NineDotMedia\viapost-php\StructType\CreatePriceBand
     */
    public function setBWBaseCost($bWBaseCost = null)
    {
        // validation for constraint: float
        if (!is_null($bWBaseCost) && !(is_float($bWBaseCost) || is_numeric($bWBaseCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bWBaseCost, true), gettype($bWBaseCost)), __LINE__);
        }
        $this->BWBaseCost = $bWBaseCost;
        return $this;
    }
    /**
     * Get ColourBaseCost value
     * @return float
     */
    public function getColourBaseCost()
    {
        return $this->ColourBaseCost;
    }
    /**
     * Set ColourBaseCost value
     * @param float $colourBaseCost
     * @return \\NineDotMedia\viapost-php\StructType\CreatePriceBand
     */
    public function setColourBaseCost($colourBaseCost = null)
    {
        // validation for constraint: float
        if (!is_null($colourBaseCost) && !(is_float($colourBaseCost) || is_numeric($colourBaseCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($colourBaseCost, true), gettype($colourBaseCost)), __LINE__);
        }
        $this->ColourBaseCost = $colourBaseCost;
        return $this;
    }
    /**
     * Get RunOnBWCost value
     * @return float
     */
    public function getRunOnBWCost()
    {
        return $this->RunOnBWCost;
    }
    /**
     * Set RunOnBWCost value
     * @param float $runOnBWCost
     * @return \\NineDotMedia\viapost-php\StructType\CreatePriceBand
     */
    public function setRunOnBWCost($runOnBWCost = null)
    {
        // validation for constraint: float
        if (!is_null($runOnBWCost) && !(is_float($runOnBWCost) || is_numeric($runOnBWCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($runOnBWCost, true), gettype($runOnBWCost)), __LINE__);
        }
        $this->RunOnBWCost = $runOnBWCost;
        return $this;
    }
    /**
     * Get RunOnColourCost value
     * @return float
     */
    public function getRunOnColourCost()
    {
        return $this->RunOnColourCost;
    }
    /**
     * Set RunOnColourCost value
     * @param float $runOnColourCost
     * @return \\NineDotMedia\viapost-php\StructType\CreatePriceBand
     */
    public function setRunOnColourCost($runOnColourCost = null)
    {
        // validation for constraint: float
        if (!is_null($runOnColourCost) && !(is_float($runOnColourCost) || is_numeric($runOnColourCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($runOnColourCost, true), gettype($runOnColourCost)), __LINE__);
        }
        $this->RunOnColourCost = $runOnColourCost;
        return $this;
    }
    /**
     * Get SheetCost value
     * @return float
     */
    public function getSheetCost()
    {
        return $this->SheetCost;
    }
    /**
     * Set SheetCost value
     * @param float $sheetCost
     * @return \\NineDotMedia\viapost-php\StructType\CreatePriceBand
     */
    public function setSheetCost($sheetCost = null)
    {
        // validation for constraint: float
        if (!is_null($sheetCost) && !(is_float($sheetCost) || is_numeric($sheetCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sheetCost, true), gettype($sheetCost)), __LINE__);
        }
        $this->SheetCost = $sheetCost;
        return $this;
    }
    /**
     * Get PriceBandId value
     * @return int
     */
    public function getPriceBandId()
    {
        return $this->PriceBandId;
    }
    /**
     * Set PriceBandId value
     * @param int $priceBandId
     * @return \\NineDotMedia\viapost-php\StructType\CreatePriceBand
     */
    public function setPriceBandId($priceBandId = null)
    {
        // validation for constraint: int
        if (!is_null($priceBandId) && !(is_int($priceBandId) || ctype_digit($priceBandId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priceBandId, true), gettype($priceBandId)), __LINE__);
        }
        $this->PriceBandId = $priceBandId;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \\NineDotMedia\viapost-php\StructType\CreatePriceBand
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get sAffiliateGUID value
     * @return string|null
     */
    public function getSAffiliateGUID()
    {
        return $this->sAffiliateGUID;
    }
    /**
     * Set sAffiliateGUID value
     * @param string $sAffiliateGUID
     * @return \\NineDotMedia\viapost-php\StructType\CreatePriceBand
     */
    public function setSAffiliateGUID($sAffiliateGUID = null)
    {
        // validation for constraint: string
        if (!is_null($sAffiliateGUID) && !is_string($sAffiliateGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAffiliateGUID, true), gettype($sAffiliateGUID)), __LINE__);
        }
        $this->sAffiliateGUID = $sAffiliateGUID;
        return $this;
    }
    /**
     * Get sReturnMessage value
     * @return string|null
     */
    public function getSReturnMessage()
    {
        return $this->sReturnMessage;
    }
    /**
     * Set sReturnMessage value
     * @param string $sReturnMessage
     * @return \\NineDotMedia\viapost-php\StructType\CreatePriceBand
     */
    public function setSReturnMessage($sReturnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($sReturnMessage) && !is_string($sReturnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sReturnMessage, true), gettype($sReturnMessage)), __LINE__);
        }
        $this->sReturnMessage = $sReturnMessage;
        return $this;
    }
}
