<?php

namespace \NineDotMedia\viapost-php;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetryLetter StructType
 * @subpackage Structs
 */
class RetryLetter extends AbstractStructBase
{
    /**
     * The letterID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $letterID;
    /**
     * The forceAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $forceAddress;
    /**
     * The loginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginToken;
    /**
     * The jobRunIDStr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $jobRunIDStr;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for RetryLetter
     * @uses RetryLetter::setLetterID()
     * @uses RetryLetter::setForceAddress()
     * @uses RetryLetter::setLoginToken()
     * @uses RetryLetter::setJobRunIDStr()
     * @uses RetryLetter::setReturnMessage()
     * @param int $letterID
     * @param bool $forceAddress
     * @param string $loginToken
     * @param string $jobRunIDStr
     * @param string $returnMessage
     */
    public function __construct($letterID = null, $forceAddress = null, $loginToken = null, $jobRunIDStr = null, $returnMessage = null)
    {
        $this
            ->setLetterID($letterID)
            ->setForceAddress($forceAddress)
            ->setLoginToken($loginToken)
            ->setJobRunIDStr($jobRunIDStr)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get letterID value
     * @return int
     */
    public function getLetterID()
    {
        return $this->letterID;
    }
    /**
     * Set letterID value
     * @param int $letterID
     * @return \\NineDotMedia\viapost-php\RetryLetter
     */
    public function setLetterID($letterID = null)
    {
        // validation for constraint: int
        if (!is_null($letterID) && !(is_int($letterID) || ctype_digit($letterID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($letterID, true), gettype($letterID)), __LINE__);
        }
        $this->letterID = $letterID;
        return $this;
    }
    /**
     * Get forceAddress value
     * @return bool
     */
    public function getForceAddress()
    {
        return $this->forceAddress;
    }
    /**
     * Set forceAddress value
     * @param bool $forceAddress
     * @return \\NineDotMedia\viapost-php\RetryLetter
     */
    public function setForceAddress($forceAddress = null)
    {
        // validation for constraint: boolean
        if (!is_null($forceAddress) && !is_bool($forceAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forceAddress, true), gettype($forceAddress)), __LINE__);
        }
        $this->forceAddress = $forceAddress;
        return $this;
    }
    /**
     * Get loginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->loginToken;
    }
    /**
     * Set loginToken value
     * @param string $loginToken
     * @return \\NineDotMedia\viapost-php\RetryLetter
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->loginToken = $loginToken;
        return $this;
    }
    /**
     * Get jobRunIDStr value
     * @return string|null
     */
    public function getJobRunIDStr()
    {
        return $this->jobRunIDStr;
    }
    /**
     * Set jobRunIDStr value
     * @param string $jobRunIDStr
     * @return \\NineDotMedia\viapost-php\RetryLetter
     */
    public function setJobRunIDStr($jobRunIDStr = null)
    {
        // validation for constraint: string
        if (!is_null($jobRunIDStr) && !is_string($jobRunIDStr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jobRunIDStr, true), gettype($jobRunIDStr)), __LINE__);
        }
        $this->jobRunIDStr = $jobRunIDStr;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \\NineDotMedia\viapost-php\RetryLetter
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
