<?php

namespace \NineDotMedia\viapost-php;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDocumentStickerArea StructType
 * @subpackage Structs
 */
class GetDocumentStickerArea extends AbstractStructBase
{
    /**
     * The documentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $documentType;
    /**
     * The area
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \\NineDotMedia\viapost-php\RectangleF
     */
    public $area;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for GetDocumentStickerArea
     * @uses GetDocumentStickerArea::setDocumentType()
     * @uses GetDocumentStickerArea::setArea()
     * @uses GetDocumentStickerArea::setReturnMessage()
     * @param string $documentType
     * @param \\NineDotMedia\viapost-php\RectangleF $area
     * @param string $returnMessage
     */
    public function __construct($documentType = null, \\NineDotMedia\viapost-php\RectangleF $area = null, $returnMessage = null)
    {
        $this
            ->setDocumentType($documentType)
            ->setArea($area)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get documentType value
     * @return string
     */
    public function getDocumentType()
    {
        return $this->documentType;
    }
    /**
     * Set documentType value
     * @uses \\NineDotMedia\viapost-php\DocumentType::valueIsValid()
     * @uses \\NineDotMedia\viapost-php\DocumentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $documentType
     * @return \\NineDotMedia\viapost-php\GetDocumentStickerArea
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: enumeration
        if (!\\NineDotMedia\viapost-php\DocumentType::valueIsValid($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \\NineDotMedia\viapost-php\DocumentType', is_array($documentType) ? implode(', ', $documentType) : var_export($documentType, true), implode(', ', \\NineDotMedia\viapost-php\DocumentType::getValidValues())), __LINE__);
        }
        $this->documentType = $documentType;
        return $this;
    }
    /**
     * Get area value
     * @return \\NineDotMedia\viapost-php\RectangleF
     */
    public function getArea()
    {
        return $this->area;
    }
    /**
     * Set area value
     * @param \\NineDotMedia\viapost-php\RectangleF $area
     * @return \\NineDotMedia\viapost-php\GetDocumentStickerArea
     */
    public function setArea(\\NineDotMedia\viapost-php\RectangleF $area = null)
    {
        $this->area = $area;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \\NineDotMedia\viapost-php\GetDocumentStickerArea
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
