<?php

namespace \NineDotMedia\viapost-php;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DownloadDataList StructType
 * @subpackage Structs
 */
class DownloadDataList extends AbstractStructBase
{
    /**
     * The dataListID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $dataListID;
    /**
     * The loginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginToken;
    /**
     * The csvBuffer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $csvBuffer;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for DownloadDataList
     * @uses DownloadDataList::setDataListID()
     * @uses DownloadDataList::setLoginToken()
     * @uses DownloadDataList::setCsvBuffer()
     * @uses DownloadDataList::setReturnMessage()
     * @param int $dataListID
     * @param string $loginToken
     * @param string $csvBuffer
     * @param string $returnMessage
     */
    public function __construct($dataListID = null, $loginToken = null, $csvBuffer = null, $returnMessage = null)
    {
        $this
            ->setDataListID($dataListID)
            ->setLoginToken($loginToken)
            ->setCsvBuffer($csvBuffer)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get dataListID value
     * @return int
     */
    public function getDataListID()
    {
        return $this->dataListID;
    }
    /**
     * Set dataListID value
     * @param int $dataListID
     * @return \\NineDotMedia\viapost-php\DownloadDataList
     */
    public function setDataListID($dataListID = null)
    {
        // validation for constraint: int
        if (!is_null($dataListID) && !(is_int($dataListID) || ctype_digit($dataListID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dataListID, true), gettype($dataListID)), __LINE__);
        }
        $this->dataListID = $dataListID;
        return $this;
    }
    /**
     * Get loginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->loginToken;
    }
    /**
     * Set loginToken value
     * @param string $loginToken
     * @return \\NineDotMedia\viapost-php\DownloadDataList
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->loginToken = $loginToken;
        return $this;
    }
    /**
     * Get csvBuffer value
     * @return string|null
     */
    public function getCsvBuffer()
    {
        return $this->csvBuffer;
    }
    /**
     * Set csvBuffer value
     * @param string $csvBuffer
     * @return \\NineDotMedia\viapost-php\DownloadDataList
     */
    public function setCsvBuffer($csvBuffer = null)
    {
        // validation for constraint: string
        if (!is_null($csvBuffer) && !is_string($csvBuffer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($csvBuffer, true), gettype($csvBuffer)), __LINE__);
        }
        $this->csvBuffer = $csvBuffer;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \\NineDotMedia\viapost-php\DownloadDataList
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
