<?php

namespace \NineDotMedia\viapost-php;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for DocumentType EnumType
 * @subpackage Enumerations
 */
class DocumentType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'SimpleMailing'
     * @return string 'SimpleMailing'
     */
    const VALUE_SIMPLE_MAILING = 'SimpleMailing';
    /**
     * Constant for value 'MailPack'
     * @return string 'MailPack'
     */
    const VALUE_MAIL_PACK = 'MailPack';
    /**
     * Constant for value 'Postcard'
     * @return string 'Postcard'
     */
    const VALUE_POSTCARD = 'Postcard';
    /**
     * Return allowed values
     * @uses self::VALUE_SIMPLE_MAILING
     * @uses self::VALUE_MAIL_PACK
     * @uses self::VALUE_POSTCARD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SIMPLE_MAILING,
            self::VALUE_MAIL_PACK,
            self::VALUE_POSTCARD,
        );
    }
}
