<?php

namespace \NineDotMedia\viapost-php;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchAddress StructType
 * @subpackage Structs
 */
class SearchAddress extends AbstractStructBase
{
    /**
     * The PafCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PafCode;
    /**
     * The LoginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoginToken;
    /**
     * The InputAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\NineDotMedia\viapost-php\PostalAddress
     */
    public $InputAddress;
    /**
     * The ReturnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturnMessage;
    /**
     * Constructor method for SearchAddress
     * @uses SearchAddress::setPafCode()
     * @uses SearchAddress::setLoginToken()
     * @uses SearchAddress::setInputAddress()
     * @uses SearchAddress::setReturnMessage()
     * @param int $pafCode
     * @param string $loginToken
     * @param \\NineDotMedia\viapost-php\PostalAddress $inputAddress
     * @param string $returnMessage
     */
    public function __construct($pafCode = null, $loginToken = null, \\NineDotMedia\viapost-php\PostalAddress $inputAddress = null, $returnMessage = null)
    {
        $this
            ->setPafCode($pafCode)
            ->setLoginToken($loginToken)
            ->setInputAddress($inputAddress)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get PafCode value
     * @return int
     */
    public function getPafCode()
    {
        return $this->PafCode;
    }
    /**
     * Set PafCode value
     * @param int $pafCode
     * @return \\NineDotMedia\viapost-php\SearchAddress
     */
    public function setPafCode($pafCode = null)
    {
        // validation for constraint: int
        if (!is_null($pafCode) && !(is_int($pafCode) || ctype_digit($pafCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pafCode, true), gettype($pafCode)), __LINE__);
        }
        $this->PafCode = $pafCode;
        return $this;
    }
    /**
     * Get LoginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->LoginToken;
    }
    /**
     * Set LoginToken value
     * @param string $loginToken
     * @return \\NineDotMedia\viapost-php\SearchAddress
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->LoginToken = $loginToken;
        return $this;
    }
    /**
     * Get InputAddress value
     * @return \\NineDotMedia\viapost-php\PostalAddress|null
     */
    public function getInputAddress()
    {
        return $this->InputAddress;
    }
    /**
     * Set InputAddress value
     * @param \\NineDotMedia\viapost-php\PostalAddress $inputAddress
     * @return \\NineDotMedia\viapost-php\SearchAddress
     */
    public function setInputAddress(\\NineDotMedia\viapost-php\PostalAddress $inputAddress = null)
    {
        $this->InputAddress = $inputAddress;
        return $this;
    }
    /**
     * Get ReturnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->ReturnMessage;
    }
    /**
     * Set ReturnMessage value
     * @param string $returnMessage
     * @return \\NineDotMedia\viapost-php\SearchAddress
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->ReturnMessage = $returnMessage;
        return $this;
    }
}
