<?php

namespace \NineDotMedia\viapost-php;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PreviewLibraryPostcard StructType
 * @subpackage Structs
 */
class PreviewLibraryPostcard extends AbstractStructBase
{
    /**
     * The postcardId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $postcardId;
    /**
     * The loginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginToken;
    /**
     * The format
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $format;
    /**
     * The pageNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pageNumber;
    /**
     * The postcardData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $postcardData;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for PreviewLibraryPostcard
     * @uses PreviewLibraryPostcard::setPostcardId()
     * @uses PreviewLibraryPostcard::setLoginToken()
     * @uses PreviewLibraryPostcard::setFormat()
     * @uses PreviewLibraryPostcard::setPageNumber()
     * @uses PreviewLibraryPostcard::setPostcardData()
     * @uses PreviewLibraryPostcard::setReturnMessage()
     * @param int $postcardId
     * @param string $loginToken
     * @param string $format
     * @param string $pageNumber
     * @param string $postcardData
     * @param string $returnMessage
     */
    public function __construct($postcardId = null, $loginToken = null, $format = null, $pageNumber = null, $postcardData = null, $returnMessage = null)
    {
        $this
            ->setPostcardId($postcardId)
            ->setLoginToken($loginToken)
            ->setFormat($format)
            ->setPageNumber($pageNumber)
            ->setPostcardData($postcardData)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get postcardId value
     * @return int
     */
    public function getPostcardId()
    {
        return $this->postcardId;
    }
    /**
     * Set postcardId value
     * @param int $postcardId
     * @return \\NineDotMedia\viapost-php\PreviewLibraryPostcard
     */
    public function setPostcardId($postcardId = null)
    {
        // validation for constraint: int
        if (!is_null($postcardId) && !(is_int($postcardId) || ctype_digit($postcardId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($postcardId, true), gettype($postcardId)), __LINE__);
        }
        $this->postcardId = $postcardId;
        return $this;
    }
    /**
     * Get loginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->loginToken;
    }
    /**
     * Set loginToken value
     * @param string $loginToken
     * @return \\NineDotMedia\viapost-php\PreviewLibraryPostcard
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->loginToken = $loginToken;
        return $this;
    }
    /**
     * Get format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->format;
    }
    /**
     * Set format value
     * @param string $format
     * @return \\NineDotMedia\viapost-php\PreviewLibraryPostcard
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($format, true), gettype($format)), __LINE__);
        }
        $this->format = $format;
        return $this;
    }
    /**
     * Get pageNumber value
     * @return string|null
     */
    public function getPageNumber()
    {
        return $this->pageNumber;
    }
    /**
     * Set pageNumber value
     * @param string $pageNumber
     * @return \\NineDotMedia\viapost-php\PreviewLibraryPostcard
     */
    public function setPageNumber($pageNumber = null)
    {
        // validation for constraint: string
        if (!is_null($pageNumber) && !is_string($pageNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pageNumber, true), gettype($pageNumber)), __LINE__);
        }
        $this->pageNumber = $pageNumber;
        return $this;
    }
    /**
     * Get postcardData value
     * @return string|null
     */
    public function getPostcardData()
    {
        return $this->postcardData;
    }
    /**
     * Set postcardData value
     * @param string $postcardData
     * @return \\NineDotMedia\viapost-php\PreviewLibraryPostcard
     */
    public function setPostcardData($postcardData = null)
    {
        // validation for constraint: string
        if (!is_null($postcardData) && !is_string($postcardData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcardData, true), gettype($postcardData)), __LINE__);
        }
        $this->postcardData = $postcardData;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \\NineDotMedia\viapost-php\PreviewLibraryPostcard
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
