<?php

namespace \NineDotMedia\viapost-php;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDocumentReservedAreas StructType
 * @subpackage Structs
 */
class GetDocumentReservedAreas extends AbstractStructBase
{
    /**
     * The documentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $documentType;
    /**
     * The areas
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\NineDotMedia\viapost-php\ArrayOfAnyType
     */
    public $areas;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for GetDocumentReservedAreas
     * @uses GetDocumentReservedAreas::setDocumentType()
     * @uses GetDocumentReservedAreas::setAreas()
     * @uses GetDocumentReservedAreas::setReturnMessage()
     * @param string $documentType
     * @param \\NineDotMedia\viapost-php\ArrayOfAnyType $areas
     * @param string $returnMessage
     */
    public function __construct($documentType = null, \\NineDotMedia\viapost-php\ArrayOfAnyType $areas = null, $returnMessage = null)
    {
        $this
            ->setDocumentType($documentType)
            ->setAreas($areas)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get documentType value
     * @return string
     */
    public function getDocumentType()
    {
        return $this->documentType;
    }
    /**
     * Set documentType value
     * @uses \\NineDotMedia\viapost-php\DocumentType::valueIsValid()
     * @uses \\NineDotMedia\viapost-php\DocumentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $documentType
     * @return \\NineDotMedia\viapost-php\GetDocumentReservedAreas
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: enumeration
        if (!\\NineDotMedia\viapost-php\DocumentType::valueIsValid($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \\NineDotMedia\viapost-php\DocumentType', is_array($documentType) ? implode(', ', $documentType) : var_export($documentType, true), implode(', ', \\NineDotMedia\viapost-php\DocumentType::getValidValues())), __LINE__);
        }
        $this->documentType = $documentType;
        return $this;
    }
    /**
     * Get areas value
     * @return \\NineDotMedia\viapost-php\ArrayOfAnyType|null
     */
    public function getAreas()
    {
        return $this->areas;
    }
    /**
     * Set areas value
     * @param \\NineDotMedia\viapost-php\ArrayOfAnyType $areas
     * @return \\NineDotMedia\viapost-php\GetDocumentReservedAreas
     */
    public function setAreas(\\NineDotMedia\viapost-php\ArrayOfAnyType $areas = null)
    {
        $this->areas = $areas;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \\NineDotMedia\viapost-php\GetDocumentReservedAreas
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
