<?php

namespace \NineDotMedia\viapost-php;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FindNearestExecuteSearch StructType
 * @subpackage Structs
 */
class FindNearestExecuteSearch extends AbstractStructBase
{
    /**
     * The numberOfAddressesToSearch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $numberOfAddressesToSearch;
    /**
     * The radiusOfAreaToSearchInMetres
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $radiusOfAreaToSearchInMetres;
    /**
     * The includeThisAddressInResults
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $includeThisAddressInResults;
    /**
     * The onlyAddressesInThisStreet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $onlyAddressesInThisStreet;
    /**
     * The addressTypes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $addressTypes;
    /**
     * The numberOfAddressesFound
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $numberOfAddressesFound;
    /**
     * The mailingListID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $mailingListID;
    /**
     * The loginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginToken;
    /**
     * The AddresseeTitle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddresseeTitle;
    /**
     * The houseNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $houseNumber;
    /**
     * The houseName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $houseName;
    /**
     * The Organisation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Organisation;
    /**
     * The postCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $postCode;
    /**
     * The affiliateGUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $affiliateGUID;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for FindNearestExecuteSearch
     * @uses FindNearestExecuteSearch::setNumberOfAddressesToSearch()
     * @uses FindNearestExecuteSearch::setRadiusOfAreaToSearchInMetres()
     * @uses FindNearestExecuteSearch::setIncludeThisAddressInResults()
     * @uses FindNearestExecuteSearch::setOnlyAddressesInThisStreet()
     * @uses FindNearestExecuteSearch::setAddressTypes()
     * @uses FindNearestExecuteSearch::setNumberOfAddressesFound()
     * @uses FindNearestExecuteSearch::setMailingListID()
     * @uses FindNearestExecuteSearch::setLoginToken()
     * @uses FindNearestExecuteSearch::setAddresseeTitle()
     * @uses FindNearestExecuteSearch::setHouseNumber()
     * @uses FindNearestExecuteSearch::setHouseName()
     * @uses FindNearestExecuteSearch::setOrganisation()
     * @uses FindNearestExecuteSearch::setPostCode()
     * @uses FindNearestExecuteSearch::setAffiliateGUID()
     * @uses FindNearestExecuteSearch::setReturnMessage()
     * @param int $numberOfAddressesToSearch
     * @param int $radiusOfAreaToSearchInMetres
     * @param bool $includeThisAddressInResults
     * @param bool $onlyAddressesInThisStreet
     * @param string $addressTypes
     * @param int $numberOfAddressesFound
     * @param int $mailingListID
     * @param string $loginToken
     * @param string $addresseeTitle
     * @param string $houseNumber
     * @param string $houseName
     * @param string $organisation
     * @param string $postCode
     * @param string $affiliateGUID
     * @param string $returnMessage
     */
    public function __construct($numberOfAddressesToSearch = null, $radiusOfAreaToSearchInMetres = null, $includeThisAddressInResults = null, $onlyAddressesInThisStreet = null, $addressTypes = null, $numberOfAddressesFound = null, $mailingListID = null, $loginToken = null, $addresseeTitle = null, $houseNumber = null, $houseName = null, $organisation = null, $postCode = null, $affiliateGUID = null, $returnMessage = null)
    {
        $this
            ->setNumberOfAddressesToSearch($numberOfAddressesToSearch)
            ->setRadiusOfAreaToSearchInMetres($radiusOfAreaToSearchInMetres)
            ->setIncludeThisAddressInResults($includeThisAddressInResults)
            ->setOnlyAddressesInThisStreet($onlyAddressesInThisStreet)
            ->setAddressTypes($addressTypes)
            ->setNumberOfAddressesFound($numberOfAddressesFound)
            ->setMailingListID($mailingListID)
            ->setLoginToken($loginToken)
            ->setAddresseeTitle($addresseeTitle)
            ->setHouseNumber($houseNumber)
            ->setHouseName($houseName)
            ->setOrganisation($organisation)
            ->setPostCode($postCode)
            ->setAffiliateGUID($affiliateGUID)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get numberOfAddressesToSearch value
     * @return int
     */
    public function getNumberOfAddressesToSearch()
    {
        return $this->numberOfAddressesToSearch;
    }
    /**
     * Set numberOfAddressesToSearch value
     * @param int $numberOfAddressesToSearch
     * @return \\NineDotMedia\viapost-php\FindNearestExecuteSearch
     */
    public function setNumberOfAddressesToSearch($numberOfAddressesToSearch = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfAddressesToSearch) && !(is_int($numberOfAddressesToSearch) || ctype_digit($numberOfAddressesToSearch))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfAddressesToSearch, true), gettype($numberOfAddressesToSearch)), __LINE__);
        }
        $this->numberOfAddressesToSearch = $numberOfAddressesToSearch;
        return $this;
    }
    /**
     * Get radiusOfAreaToSearchInMetres value
     * @return int
     */
    public function getRadiusOfAreaToSearchInMetres()
    {
        return $this->radiusOfAreaToSearchInMetres;
    }
    /**
     * Set radiusOfAreaToSearchInMetres value
     * @param int $radiusOfAreaToSearchInMetres
     * @return \\NineDotMedia\viapost-php\FindNearestExecuteSearch
     */
    public function setRadiusOfAreaToSearchInMetres($radiusOfAreaToSearchInMetres = null)
    {
        // validation for constraint: int
        if (!is_null($radiusOfAreaToSearchInMetres) && !(is_int($radiusOfAreaToSearchInMetres) || ctype_digit($radiusOfAreaToSearchInMetres))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($radiusOfAreaToSearchInMetres, true), gettype($radiusOfAreaToSearchInMetres)), __LINE__);
        }
        $this->radiusOfAreaToSearchInMetres = $radiusOfAreaToSearchInMetres;
        return $this;
    }
    /**
     * Get includeThisAddressInResults value
     * @return bool
     */
    public function getIncludeThisAddressInResults()
    {
        return $this->includeThisAddressInResults;
    }
    /**
     * Set includeThisAddressInResults value
     * @param bool $includeThisAddressInResults
     * @return \\NineDotMedia\viapost-php\FindNearestExecuteSearch
     */
    public function setIncludeThisAddressInResults($includeThisAddressInResults = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeThisAddressInResults) && !is_bool($includeThisAddressInResults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeThisAddressInResults, true), gettype($includeThisAddressInResults)), __LINE__);
        }
        $this->includeThisAddressInResults = $includeThisAddressInResults;
        return $this;
    }
    /**
     * Get onlyAddressesInThisStreet value
     * @return bool
     */
    public function getOnlyAddressesInThisStreet()
    {
        return $this->onlyAddressesInThisStreet;
    }
    /**
     * Set onlyAddressesInThisStreet value
     * @param bool $onlyAddressesInThisStreet
     * @return \\NineDotMedia\viapost-php\FindNearestExecuteSearch
     */
    public function setOnlyAddressesInThisStreet($onlyAddressesInThisStreet = null)
    {
        // validation for constraint: boolean
        if (!is_null($onlyAddressesInThisStreet) && !is_bool($onlyAddressesInThisStreet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onlyAddressesInThisStreet, true), gettype($onlyAddressesInThisStreet)), __LINE__);
        }
        $this->onlyAddressesInThisStreet = $onlyAddressesInThisStreet;
        return $this;
    }
    /**
     * Get addressTypes value
     * @return string
     */
    public function getAddressTypes()
    {
        return $this->addressTypes;
    }
    /**
     * Set addressTypes value
     * @uses \\NineDotMedia\viapost-php\FindNearestAddressTypes::valueIsValid()
     * @uses \\NineDotMedia\viapost-php\FindNearestAddressTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $addressTypes
     * @return \\NineDotMedia\viapost-php\FindNearestExecuteSearch
     */
    public function setAddressTypes($addressTypes = null)
    {
        // validation for constraint: enumeration
        if (!\\NineDotMedia\viapost-php\FindNearestAddressTypes::valueIsValid($addressTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \\NineDotMedia\viapost-php\FindNearestAddressTypes', is_array($addressTypes) ? implode(', ', $addressTypes) : var_export($addressTypes, true), implode(', ', \\NineDotMedia\viapost-php\FindNearestAddressTypes::getValidValues())), __LINE__);
        }
        $this->addressTypes = $addressTypes;
        return $this;
    }
    /**
     * Get numberOfAddressesFound value
     * @return int
     */
    public function getNumberOfAddressesFound()
    {
        return $this->numberOfAddressesFound;
    }
    /**
     * Set numberOfAddressesFound value
     * @param int $numberOfAddressesFound
     * @return \\NineDotMedia\viapost-php\FindNearestExecuteSearch
     */
    public function setNumberOfAddressesFound($numberOfAddressesFound = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfAddressesFound) && !(is_int($numberOfAddressesFound) || ctype_digit($numberOfAddressesFound))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfAddressesFound, true), gettype($numberOfAddressesFound)), __LINE__);
        }
        $this->numberOfAddressesFound = $numberOfAddressesFound;
        return $this;
    }
    /**
     * Get mailingListID value
     * @return int
     */
    public function getMailingListID()
    {
        return $this->mailingListID;
    }
    /**
     * Set mailingListID value
     * @param int $mailingListID
     * @return \\NineDotMedia\viapost-php\FindNearestExecuteSearch
     */
    public function setMailingListID($mailingListID = null)
    {
        // validation for constraint: int
        if (!is_null($mailingListID) && !(is_int($mailingListID) || ctype_digit($mailingListID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mailingListID, true), gettype($mailingListID)), __LINE__);
        }
        $this->mailingListID = $mailingListID;
        return $this;
    }
    /**
     * Get loginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->loginToken;
    }
    /**
     * Set loginToken value
     * @param string $loginToken
     * @return \\NineDotMedia\viapost-php\FindNearestExecuteSearch
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->loginToken = $loginToken;
        return $this;
    }
    /**
     * Get AddresseeTitle value
     * @return string|null
     */
    public function getAddresseeTitle()
    {
        return $this->AddresseeTitle;
    }
    /**
     * Set AddresseeTitle value
     * @param string $addresseeTitle
     * @return \\NineDotMedia\viapost-php\FindNearestExecuteSearch
     */
    public function setAddresseeTitle($addresseeTitle = null)
    {
        // validation for constraint: string
        if (!is_null($addresseeTitle) && !is_string($addresseeTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addresseeTitle, true), gettype($addresseeTitle)), __LINE__);
        }
        $this->AddresseeTitle = $addresseeTitle;
        return $this;
    }
    /**
     * Get houseNumber value
     * @return string|null
     */
    public function getHouseNumber()
    {
        return $this->houseNumber;
    }
    /**
     * Set houseNumber value
     * @param string $houseNumber
     * @return \\NineDotMedia\viapost-php\FindNearestExecuteSearch
     */
    public function setHouseNumber($houseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($houseNumber) && !is_string($houseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($houseNumber, true), gettype($houseNumber)), __LINE__);
        }
        $this->houseNumber = $houseNumber;
        return $this;
    }
    /**
     * Get houseName value
     * @return string|null
     */
    public function getHouseName()
    {
        return $this->houseName;
    }
    /**
     * Set houseName value
     * @param string $houseName
     * @return \\NineDotMedia\viapost-php\FindNearestExecuteSearch
     */
    public function setHouseName($houseName = null)
    {
        // validation for constraint: string
        if (!is_null($houseName) && !is_string($houseName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($houseName, true), gettype($houseName)), __LINE__);
        }
        $this->houseName = $houseName;
        return $this;
    }
    /**
     * Get Organisation value
     * @return string|null
     */
    public function getOrganisation()
    {
        return $this->Organisation;
    }
    /**
     * Set Organisation value
     * @param string $organisation
     * @return \\NineDotMedia\viapost-php\FindNearestExecuteSearch
     */
    public function setOrganisation($organisation = null)
    {
        // validation for constraint: string
        if (!is_null($organisation) && !is_string($organisation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organisation, true), gettype($organisation)), __LINE__);
        }
        $this->Organisation = $organisation;
        return $this;
    }
    /**
     * Get postCode value
     * @return string|null
     */
    public function getPostCode()
    {
        return $this->postCode;
    }
    /**
     * Set postCode value
     * @param string $postCode
     * @return \\NineDotMedia\viapost-php\FindNearestExecuteSearch
     */
    public function setPostCode($postCode = null)
    {
        // validation for constraint: string
        if (!is_null($postCode) && !is_string($postCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postCode, true), gettype($postCode)), __LINE__);
        }
        $this->postCode = $postCode;
        return $this;
    }
    /**
     * Get affiliateGUID value
     * @return string|null
     */
    public function getAffiliateGUID()
    {
        return $this->affiliateGUID;
    }
    /**
     * Set affiliateGUID value
     * @param string $affiliateGUID
     * @return \\NineDotMedia\viapost-php\FindNearestExecuteSearch
     */
    public function setAffiliateGUID($affiliateGUID = null)
    {
        // validation for constraint: string
        if (!is_null($affiliateGUID) && !is_string($affiliateGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($affiliateGUID, true), gettype($affiliateGUID)), __LINE__);
        }
        $this->affiliateGUID = $affiliateGUID;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \\NineDotMedia\viapost-php\FindNearestExecuteSearch
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
