<?php

namespace \NineDotMedia\viapost-php;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddExcludedAddress StructType
 * @subpackage Structs
 */
class AddExcludedAddress extends AbstractStructBase
{
    /**
     * The mailingListID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $mailingListID;
    /**
     * The companyLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $companyLevel;
    /**
     * The loginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginToken;
    /**
     * The Street1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Street1;
    /**
     * The Postcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Postcode;
    /**
     * The strReturnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $strReturnMessage;
    /**
     * Constructor method for AddExcludedAddress
     * @uses AddExcludedAddress::setMailingListID()
     * @uses AddExcludedAddress::setCompanyLevel()
     * @uses AddExcludedAddress::setLoginToken()
     * @uses AddExcludedAddress::setStreet1()
     * @uses AddExcludedAddress::setPostcode()
     * @uses AddExcludedAddress::setStrReturnMessage()
     * @param int $mailingListID
     * @param bool $companyLevel
     * @param string $loginToken
     * @param string $street1
     * @param string $postcode
     * @param string $strReturnMessage
     */
    public function __construct($mailingListID = null, $companyLevel = null, $loginToken = null, $street1 = null, $postcode = null, $strReturnMessage = null)
    {
        $this
            ->setMailingListID($mailingListID)
            ->setCompanyLevel($companyLevel)
            ->setLoginToken($loginToken)
            ->setStreet1($street1)
            ->setPostcode($postcode)
            ->setStrReturnMessage($strReturnMessage);
    }
    /**
     * Get mailingListID value
     * @return int
     */
    public function getMailingListID()
    {
        return $this->mailingListID;
    }
    /**
     * Set mailingListID value
     * @param int $mailingListID
     * @return \\NineDotMedia\viapost-php\AddExcludedAddress
     */
    public function setMailingListID($mailingListID = null)
    {
        // validation for constraint: int
        if (!is_null($mailingListID) && !(is_int($mailingListID) || ctype_digit($mailingListID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mailingListID, true), gettype($mailingListID)), __LINE__);
        }
        $this->mailingListID = $mailingListID;
        return $this;
    }
    /**
     * Get companyLevel value
     * @return bool
     */
    public function getCompanyLevel()
    {
        return $this->companyLevel;
    }
    /**
     * Set companyLevel value
     * @param bool $companyLevel
     * @return \\NineDotMedia\viapost-php\AddExcludedAddress
     */
    public function setCompanyLevel($companyLevel = null)
    {
        // validation for constraint: boolean
        if (!is_null($companyLevel) && !is_bool($companyLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($companyLevel, true), gettype($companyLevel)), __LINE__);
        }
        $this->companyLevel = $companyLevel;
        return $this;
    }
    /**
     * Get loginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->loginToken;
    }
    /**
     * Set loginToken value
     * @param string $loginToken
     * @return \\NineDotMedia\viapost-php\AddExcludedAddress
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->loginToken = $loginToken;
        return $this;
    }
    /**
     * Get Street1 value
     * @return string|null
     */
    public function getStreet1()
    {
        return $this->Street1;
    }
    /**
     * Set Street1 value
     * @param string $street1
     * @return \\NineDotMedia\viapost-php\AddExcludedAddress
     */
    public function setStreet1($street1 = null)
    {
        // validation for constraint: string
        if (!is_null($street1) && !is_string($street1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street1, true), gettype($street1)), __LINE__);
        }
        $this->Street1 = $street1;
        return $this;
    }
    /**
     * Get Postcode value
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->Postcode;
    }
    /**
     * Set Postcode value
     * @param string $postcode
     * @return \\NineDotMedia\viapost-php\AddExcludedAddress
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        $this->Postcode = $postcode;
        return $this;
    }
    /**
     * Get strReturnMessage value
     * @return string|null
     */
    public function getStrReturnMessage()
    {
        return $this->strReturnMessage;
    }
    /**
     * Set strReturnMessage value
     * @param string $strReturnMessage
     * @return \\NineDotMedia\viapost-php\AddExcludedAddress
     */
    public function setStrReturnMessage($strReturnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($strReturnMessage) && !is_string($strReturnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($strReturnMessage, true), gettype($strReturnMessage)), __LINE__);
        }
        $this->strReturnMessage = $strReturnMessage;
        return $this;
    }
}
