<?php

namespace TRIBUNALWS;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReturnValuePN TRIBUNALWS
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: ns1:ReturnValuePN
 * @subpackage Structs
 */
class ReturnValuePN extends BaseReturnValue
{
    /**
     * The FaseProcesso
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FaseProcesso;
    /**
     * The NumProcesso
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumProcesso;
    /**
     * The ReturnDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReturnDescription;
    /**
     * Constructor method for ReturnValuePN
     * @uses ReturnValuePN::setFaseProcesso()
     * @uses ReturnValuePN::setNumProcesso()
     * @uses ReturnValuePN::setReturnDescription()
     * @param string $faseProcesso
     * @param string $numProcesso
     * @param string $returnDescription
     */
    public function __construct($faseProcesso = null, $numProcesso = null, $returnDescription = null)
    {
        $this
            ->setFaseProcesso($faseProcesso)
            ->setNumProcesso($numProcesso)
            ->setReturnDescription($returnDescription);
    }
    /**
     * Get FaseProcesso value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFaseProcesso()
    {
        return isset($this->FaseProcesso) ? $this->FaseProcesso : null;
    }
    /**
     * Set FaseProcesso value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $faseProcesso
     * @return \TRIBUNALWS\ReturnValuePN
     */
    public function setFaseProcesso($faseProcesso = null)
    {
        if (is_null($faseProcesso) || (is_array($faseProcesso) && empty($faseProcesso))) {
            unset($this->FaseProcesso);
        } else {
            $this->FaseProcesso = $faseProcesso;
        }
        return $this;
    }
    /**
     * Get NumProcesso value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumProcesso()
    {
        return isset($this->NumProcesso) ? $this->NumProcesso : null;
    }
    /**
     * Set NumProcesso value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numProcesso
     * @return \TRIBUNALWS\ReturnValuePN
     */
    public function setNumProcesso($numProcesso = null)
    {
        if (is_null($numProcesso) || (is_array($numProcesso) && empty($numProcesso))) {
            unset($this->NumProcesso);
        } else {
            $this->NumProcesso = $numProcesso;
        }
        return $this;
    }
    /**
     * Get ReturnDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReturnDescription()
    {
        return isset($this->ReturnDescription) ? $this->ReturnDescription : null;
    }
    /**
     * Set ReturnDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $returnDescription
     * @return \TRIBUNALWS\ReturnValuePN
     */
    public function setReturnDescription($returnDescription = null)
    {
        if (is_null($returnDescription) || (is_array($returnDescription) && empty($returnDescription))) {
            unset($this->ReturnDescription);
        } else {
            $this->ReturnDescription = $returnDescription;
        }
        return $this;
    }
}
