<?php

namespace TRIBUNALWS;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseReturnValue TRIBUNALWS
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: ns1:BaseReturnValue
 * @subpackage Structs
 */
class BaseReturnValue extends AbstractStructBase
{
    /**
     * The IdProcesso
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: ns0:guid
     * @var string
     */
    public $IdProcesso;
    /**
     * The ReturnCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReturnCode;
    /**
     * The ReturnMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReturnMessage;
    /**
     * The ReturnValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReturnValue;
    /**
     * The WorkflowInstanceId
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: ns0:guid
     * @var string
     */
    public $WorkflowInstanceId;
    /**
     * Constructor method for BaseReturnValue
     * @uses BaseReturnValue::setIdProcesso()
     * @uses BaseReturnValue::setReturnCode()
     * @uses BaseReturnValue::setReturnMessage()
     * @uses BaseReturnValue::setReturnValue()
     * @uses BaseReturnValue::setWorkflowInstanceId()
     * @param string $idProcesso
     * @param string $returnCode
     * @param string $returnMessage
     * @param string $returnValue
     * @param string $workflowInstanceId
     */
    public function __construct($idProcesso = null, $returnCode = null, $returnMessage = null, $returnValue = null, $workflowInstanceId = null)
    {
        $this
            ->setIdProcesso($idProcesso)
            ->setReturnCode($returnCode)
            ->setReturnMessage($returnMessage)
            ->setReturnValue($returnValue)
            ->setWorkflowInstanceId($workflowInstanceId);
    }
    /**
     * Get IdProcesso value
     * @return string|null
     */
    public function getIdProcesso()
    {
        return $this->IdProcesso;
    }
    /**
     * Set IdProcesso value
     * @param string $idProcesso
     * @return \TRIBUNALWS\BaseReturnValue
     */
    public function setIdProcesso($idProcesso = null)
    {
        $this->IdProcesso = $idProcesso;
        return $this;
    }
    /**
     * Get ReturnCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReturnCode()
    {
        return isset($this->ReturnCode) ? $this->ReturnCode : null;
    }
    /**
     * Set ReturnCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $returnCode
     * @return \TRIBUNALWS\BaseReturnValue
     */
    public function setReturnCode($returnCode = null)
    {
        if (is_null($returnCode) || (is_array($returnCode) && empty($returnCode))) {
            unset($this->ReturnCode);
        } else {
            $this->ReturnCode = $returnCode;
        }
        return $this;
    }
    /**
     * Get ReturnMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReturnMessage()
    {
        return isset($this->ReturnMessage) ? $this->ReturnMessage : null;
    }
    /**
     * Set ReturnMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $returnMessage
     * @return \TRIBUNALWS\BaseReturnValue
     */
    public function setReturnMessage($returnMessage = null)
    {
        if (is_null($returnMessage) || (is_array($returnMessage) && empty($returnMessage))) {
            unset($this->ReturnMessage);
        } else {
            $this->ReturnMessage = $returnMessage;
        }
        return $this;
    }
    /**
     * Get ReturnValue value
     * @return string|null
     */
    public function getReturnValue()
    {
        return $this->ReturnValue;
    }
    /**
     * Set ReturnValue value
     * @param string $returnValue
     * @return \TRIBUNALWS\BaseReturnValue
     */
    public function setReturnValue($returnValue = null)
    {
        $this->ReturnValue = $returnValue;
        return $this;
    }
    /**
     * Get WorkflowInstanceId value
     * @return string|null
     */
    public function getWorkflowInstanceId()
    {
        return $this->WorkflowInstanceId;
    }
    /**
     * Set WorkflowInstanceId value
     * @param string $workflowInstanceId
     * @return \TRIBUNALWS\BaseReturnValue
     */
    public function setWorkflowInstanceId($workflowInstanceId = null)
    {
        $this->WorkflowInstanceId = $workflowInstanceId;
        return $this;
    }
}
