<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for RNI ServiceType
 * @subpackage Services
 */
class RNI extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RNI
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TRIBUNALWS\PessoaRNI $parameters
     * @return \ArrayType\ArrayOfPessoaRNI|bool
     */
    public function RNI(\TRIBUNALWS\PessoaRNI $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RNI($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \ArrayType\ArrayOfPessoaRNI
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
