<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Upload ServiceType
 */
$upload = new \ServiceType\Upload($options);
/**
 * Sample call for UploadDocumentos operation/method
 */
if ($upload->UploadDocumentos(new \TRIBUNALWS\UploadDocumentos()) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
/**
 * Samples for BIT ServiceType
 */
$bIT = new \ServiceType\BIT($options);
/**
 * Sample call for BITestemunhas operation/method
 */
if ($bIT->BITestemunhas(new \TRIBUNALWS\BITestemunhas()) !== false) {
    print_r($bIT->getResult());
} else {
    print_r($bIT->getLastError());
}
/**
 * Samples for Outras ServiceType
 */
$outras = new \ServiceType\Outras($options);
/**
 * Sample call for OutrasPessoasVitimas operation/method
 */
if ($outras->OutrasPessoasVitimas(new \TRIBUNALWS\OutrasPessoasVitimas()) !== false) {
    print_r($outras->getResult());
} else {
    print_r($outras->getLastError());
}
/**
 * Sample call for OutrasPessoasDenunciados operation/method
 */
if ($outras->OutrasPessoasDenunciados(new \TRIBUNALWS\OutrasPessoasDenunciados()) !== false) {
    print_r($outras->getResult());
} else {
    print_r($outras->getLastError());
}
/**
 * Sample call for OutrasPessoasTestemunhas operation/method
 */
if ($outras->OutrasPessoasTestemunhas(new \TRIBUNALWS\OutrasPessoasTestemunhas()) !== false) {
    print_r($outras->getResult());
} else {
    print_r($outras->getLastError());
}
/**
 * Sample call for OutrasPessoasDenunciantes operation/method
 */
if ($outras->OutrasPessoasDenunciantes(new \TRIBUNALWS\OutrasPessoasDenunciantes()) !== false) {
    print_r($outras->getResult());
} else {
    print_r($outras->getLastError());
}
/**
 * Samples for Enviar ServiceType
 */
$enviar = new \ServiceType\Enviar($options);
/**
 * Sample call for EnviarAutoDenunciaNoticiaOuQueixa operation/method
 */
if ($enviar->EnviarAutoDenunciaNoticiaOuQueixa(new \TRIBUNALWS\EnviarAutoDenunciaNoticiaOuQueixa()) !== false) {
    print_r($enviar->getResult());
} else {
    print_r($enviar->getLastError());
}
/**
 * Sample call for EnviarAutoDetencaoEmFlagranteDelito operation/method
 */
if ($enviar->EnviarAutoDetencaoEmFlagranteDelito(new \TRIBUNALWS\EnviarAutoDetencaoEmFlagranteDelito()) !== false) {
    print_r($enviar->getResult());
} else {
    print_r($enviar->getLastError());
}
/**
 * Samples for BID ServiceType
 */
$bID = new \ServiceType\BID($options);
/**
 * Sample call for BIDenunciantes operation/method
 */
if ($bID->BIDenunciantes(new \TRIBUNALWS\BIDenunciantes()) !== false) {
    print_r($bID->getResult());
} else {
    print_r($bID->getLastError());
}
/**
 * Sample call for BIDenunciados operation/method
 */
if ($bID->BIDenunciados(new \TRIBUNALWS\BIDenunciados()) !== false) {
    print_r($bID->getResult());
} else {
    print_r($bID->getLastError());
}
/**
 * Samples for BIV ServiceType
 */
$bIV = new \ServiceType\BIV($options);
/**
 * Sample call for BIVitimas operation/method
 */
if ($bIV->BIVitimas(new \TRIBUNALWS\BIVitimas()) !== false) {
    print_r($bIV->getResult());
} else {
    print_r($bIV->getLastError());
}
/**
 * Samples for Entidade ServiceType
 */
$entidade = new \ServiceType\Entidade($options);
/**
 * Sample call for EntidadeEmitente operation/method
 */
if ($entidade->EntidadeEmitente(new \TRIBUNALWS\EntidadeEmitente()) !== false) {
    print_r($entidade->getResult());
} else {
    print_r($entidade->getLastError());
}
/**
 * Samples for Tribunal ServiceType
 */
$tribunal = new \ServiceType\Tribunal($options);
/**
 * Sample call for Tribunal operation/method
 */
if ($tribunal->Tribunal(new \TRIBUNALWS\Tribunal()) !== false) {
    print_r($tribunal->getResult());
} else {
    print_r($tribunal->getLastError());
}
/**
 * Samples for RNI ServiceType
 */
$rNI = new \ServiceType\RNI($options);
/**
 * Sample call for RNI operation/method
 */
if ($rNI->RNI(new \TRIBUNALWS\PessoaRNI()) !== false) {
    print_r($rNI->getResult());
} else {
    print_r($rNI->getLastError());
}
