<?php

namespace TRIBUNALWS;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PublicTribunal TRIBUNALWS
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: ns1:PublicTribunal
 * @subpackage Structs
 */
class PublicTribunal extends AbstractStructBase
{
    /**
     * The ComarcaID
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: ns0:guid
     * @var string
     */
    public $ComarcaID;
    /**
     * The ComarcaNome
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ComarcaNome;
    /**
     * The Descricao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Descricao;
    /**
     * The Localidade
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Localidade;
    /**
     * The Morada
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Morada;
    /**
     * The Nome
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Nome;
    /**
     * The ParentTribunal
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: ns0:guid
     * @var string
     */
    public $ParentTribunal;
    /**
     * The ParentTribunalNome
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ParentTribunalNome;
    /**
     * The TribunalID
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: ns0:guid
     * @var string
     */
    public $TribunalID;
    /**
     * Constructor method for PublicTribunal
     * @uses PublicTribunal::setComarcaID()
     * @uses PublicTribunal::setComarcaNome()
     * @uses PublicTribunal::setDescricao()
     * @uses PublicTribunal::setLocalidade()
     * @uses PublicTribunal::setMorada()
     * @uses PublicTribunal::setNome()
     * @uses PublicTribunal::setParentTribunal()
     * @uses PublicTribunal::setParentTribunalNome()
     * @uses PublicTribunal::setTribunalID()
     * @param string $comarcaID
     * @param string $comarcaNome
     * @param string $descricao
     * @param string $localidade
     * @param string $morada
     * @param string $nome
     * @param string $parentTribunal
     * @param string $parentTribunalNome
     * @param string $tribunalID
     */
    public function __construct($comarcaID = null, $comarcaNome = null, $descricao = null, $localidade = null, $morada = null, $nome = null, $parentTribunal = null, $parentTribunalNome = null, $tribunalID = null)
    {
        $this
            ->setComarcaID($comarcaID)
            ->setComarcaNome($comarcaNome)
            ->setDescricao($descricao)
            ->setLocalidade($localidade)
            ->setMorada($morada)
            ->setNome($nome)
            ->setParentTribunal($parentTribunal)
            ->setParentTribunalNome($parentTribunalNome)
            ->setTribunalID($tribunalID);
    }
    /**
     * Get ComarcaID value
     * @return string|null
     */
    public function getComarcaID()
    {
        return $this->ComarcaID;
    }
    /**
     * Set ComarcaID value
     * @param string $comarcaID
     * @return \TRIBUNALWS\PublicTribunal
     */
    public function setComarcaID($comarcaID = null)
    {
        $this->ComarcaID = $comarcaID;
        return $this;
    }
    /**
     * Get ComarcaNome value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComarcaNome()
    {
        return isset($this->ComarcaNome) ? $this->ComarcaNome : null;
    }
    /**
     * Set ComarcaNome value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $comarcaNome
     * @return \TRIBUNALWS\PublicTribunal
     */
    public function setComarcaNome($comarcaNome = null)
    {
        if (is_null($comarcaNome) || (is_array($comarcaNome) && empty($comarcaNome))) {
            unset($this->ComarcaNome);
        } else {
            $this->ComarcaNome = $comarcaNome;
        }
        return $this;
    }
    /**
     * Get Descricao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescricao()
    {
        return isset($this->Descricao) ? $this->Descricao : null;
    }
    /**
     * Set Descricao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descricao
     * @return \TRIBUNALWS\PublicTribunal
     */
    public function setDescricao($descricao = null)
    {
        if (is_null($descricao) || (is_array($descricao) && empty($descricao))) {
            unset($this->Descricao);
        } else {
            $this->Descricao = $descricao;
        }
        return $this;
    }
    /**
     * Get Localidade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocalidade()
    {
        return isset($this->Localidade) ? $this->Localidade : null;
    }
    /**
     * Set Localidade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $localidade
     * @return \TRIBUNALWS\PublicTribunal
     */
    public function setLocalidade($localidade = null)
    {
        if (is_null($localidade) || (is_array($localidade) && empty($localidade))) {
            unset($this->Localidade);
        } else {
            $this->Localidade = $localidade;
        }
        return $this;
    }
    /**
     * Get Morada value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMorada()
    {
        return isset($this->Morada) ? $this->Morada : null;
    }
    /**
     * Set Morada value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $morada
     * @return \TRIBUNALWS\PublicTribunal
     */
    public function setMorada($morada = null)
    {
        if (is_null($morada) || (is_array($morada) && empty($morada))) {
            unset($this->Morada);
        } else {
            $this->Morada = $morada;
        }
        return $this;
    }
    /**
     * Get Nome value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNome()
    {
        return isset($this->Nome) ? $this->Nome : null;
    }
    /**
     * Set Nome value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nome
     * @return \TRIBUNALWS\PublicTribunal
     */
    public function setNome($nome = null)
    {
        if (is_null($nome) || (is_array($nome) && empty($nome))) {
            unset($this->Nome);
        } else {
            $this->Nome = $nome;
        }
        return $this;
    }
    /**
     * Get ParentTribunal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentTribunal()
    {
        return isset($this->ParentTribunal) ? $this->ParentTribunal : null;
    }
    /**
     * Set ParentTribunal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentTribunal
     * @return \TRIBUNALWS\PublicTribunal
     */
    public function setParentTribunal($parentTribunal = null)
    {
        if (is_null($parentTribunal) || (is_array($parentTribunal) && empty($parentTribunal))) {
            unset($this->ParentTribunal);
        } else {
            $this->ParentTribunal = $parentTribunal;
        }
        return $this;
    }
    /**
     * Get ParentTribunalNome value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentTribunalNome()
    {
        return isset($this->ParentTribunalNome) ? $this->ParentTribunalNome : null;
    }
    /**
     * Set ParentTribunalNome value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentTribunalNome
     * @return \TRIBUNALWS\PublicTribunal
     */
    public function setParentTribunalNome($parentTribunalNome = null)
    {
        if (is_null($parentTribunalNome) || (is_array($parentTribunalNome) && empty($parentTribunalNome))) {
            unset($this->ParentTribunalNome);
        } else {
            $this->ParentTribunalNome = $parentTribunalNome;
        }
        return $this;
    }
    /**
     * Get TribunalID value
     * @return string|null
     */
    public function getTribunalID()
    {
        return $this->TribunalID;
    }
    /**
     * Set TribunalID value
     * @param string $tribunalID
     * @return \TRIBUNALWS\PublicTribunal
     */
    public function setTribunalID($tribunalID = null)
    {
        $this->TribunalID = $tribunalID;
        return $this;
    }
}
