<?php

namespace TRIBUNALWS;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AutoPN TRIBUNALWS
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: ns1:AutoPN
 * @subpackage Structs
 */
class AutoPN extends AbstractStructBase
{
    /**
     * The DataDenuncia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataDenuncia;
    /**
     * The Descricao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Descricao;
    /**
     * The EntidadeOriginadoraID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $EntidadeOriginadoraID;
    /**
     * The LocalOcorrencia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LocalOcorrencia;
    /**
     * The NomeCodigo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NomeCodigo;
    /**
     * The NumeroDePolicia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumeroDePolicia;
    /**
     * The RequerentePedido
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequerentePedido;
    /**
     * The TribunalID
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: ns0:guid
     * @var string
     */
    public $TribunalID;
    /**
     * Constructor method for AutoPN
     * @uses AutoPN::setDataDenuncia()
     * @uses AutoPN::setDescricao()
     * @uses AutoPN::setEntidadeOriginadoraID()
     * @uses AutoPN::setLocalOcorrencia()
     * @uses AutoPN::setNomeCodigo()
     * @uses AutoPN::setNumeroDePolicia()
     * @uses AutoPN::setRequerentePedido()
     * @uses AutoPN::setTribunalID()
     * @param string $dataDenuncia
     * @param string $descricao
     * @param int $entidadeOriginadoraID
     * @param string $localOcorrencia
     * @param string $nomeCodigo
     * @param string $numeroDePolicia
     * @param string $requerentePedido
     * @param string $tribunalID
     */
    public function __construct($dataDenuncia = null, $descricao = null, $entidadeOriginadoraID = null, $localOcorrencia = null, $nomeCodigo = null, $numeroDePolicia = null, $requerentePedido = null, $tribunalID = null)
    {
        $this
            ->setDataDenuncia($dataDenuncia)
            ->setDescricao($descricao)
            ->setEntidadeOriginadoraID($entidadeOriginadoraID)
            ->setLocalOcorrencia($localOcorrencia)
            ->setNomeCodigo($nomeCodigo)
            ->setNumeroDePolicia($numeroDePolicia)
            ->setRequerentePedido($requerentePedido)
            ->setTribunalID($tribunalID);
    }
    /**
     * Get DataDenuncia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataDenuncia()
    {
        return isset($this->DataDenuncia) ? $this->DataDenuncia : null;
    }
    /**
     * Set DataDenuncia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataDenuncia
     * @return \TRIBUNALWS\AutoPN
     */
    public function setDataDenuncia($dataDenuncia = null)
    {
        if (is_null($dataDenuncia) || (is_array($dataDenuncia) && empty($dataDenuncia))) {
            unset($this->DataDenuncia);
        } else {
            $this->DataDenuncia = $dataDenuncia;
        }
        return $this;
    }
    /**
     * Get Descricao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescricao()
    {
        return isset($this->Descricao) ? $this->Descricao : null;
    }
    /**
     * Set Descricao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descricao
     * @return \TRIBUNALWS\AutoPN
     */
    public function setDescricao($descricao = null)
    {
        if (is_null($descricao) || (is_array($descricao) && empty($descricao))) {
            unset($this->Descricao);
        } else {
            $this->Descricao = $descricao;
        }
        return $this;
    }
    /**
     * Get EntidadeOriginadoraID value
     * @return int|null
     */
    public function getEntidadeOriginadoraID()
    {
        return $this->EntidadeOriginadoraID;
    }
    /**
     * Set EntidadeOriginadoraID value
     * @param int $entidadeOriginadoraID
     * @return \TRIBUNALWS\AutoPN
     */
    public function setEntidadeOriginadoraID($entidadeOriginadoraID = null)
    {
        $this->EntidadeOriginadoraID = $entidadeOriginadoraID;
        return $this;
    }
    /**
     * Get LocalOcorrencia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocalOcorrencia()
    {
        return isset($this->LocalOcorrencia) ? $this->LocalOcorrencia : null;
    }
    /**
     * Set LocalOcorrencia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $localOcorrencia
     * @return \TRIBUNALWS\AutoPN
     */
    public function setLocalOcorrencia($localOcorrencia = null)
    {
        if (is_null($localOcorrencia) || (is_array($localOcorrencia) && empty($localOcorrencia))) {
            unset($this->LocalOcorrencia);
        } else {
            $this->LocalOcorrencia = $localOcorrencia;
        }
        return $this;
    }
    /**
     * Get NomeCodigo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNomeCodigo()
    {
        return isset($this->NomeCodigo) ? $this->NomeCodigo : null;
    }
    /**
     * Set NomeCodigo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nomeCodigo
     * @return \TRIBUNALWS\AutoPN
     */
    public function setNomeCodigo($nomeCodigo = null)
    {
        if (is_null($nomeCodigo) || (is_array($nomeCodigo) && empty($nomeCodigo))) {
            unset($this->NomeCodigo);
        } else {
            $this->NomeCodigo = $nomeCodigo;
        }
        return $this;
    }
    /**
     * Get NumeroDePolicia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumeroDePolicia()
    {
        return isset($this->NumeroDePolicia) ? $this->NumeroDePolicia : null;
    }
    /**
     * Set NumeroDePolicia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numeroDePolicia
     * @return \TRIBUNALWS\AutoPN
     */
    public function setNumeroDePolicia($numeroDePolicia = null)
    {
        if (is_null($numeroDePolicia) || (is_array($numeroDePolicia) && empty($numeroDePolicia))) {
            unset($this->NumeroDePolicia);
        } else {
            $this->NumeroDePolicia = $numeroDePolicia;
        }
        return $this;
    }
    /**
     * Get RequerentePedido value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequerentePedido()
    {
        return isset($this->RequerentePedido) ? $this->RequerentePedido : null;
    }
    /**
     * Set RequerentePedido value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requerentePedido
     * @return \TRIBUNALWS\AutoPN
     */
    public function setRequerentePedido($requerentePedido = null)
    {
        if (is_null($requerentePedido) || (is_array($requerentePedido) && empty($requerentePedido))) {
            unset($this->RequerentePedido);
        } else {
            $this->RequerentePedido = $requerentePedido;
        }
        return $this;
    }
    /**
     * Get TribunalID value
     * @return string|null
     */
    public function getTribunalID()
    {
        return $this->TribunalID;
    }
    /**
     * Set TribunalID value
     * @param string $tribunalID
     * @return \TRIBUNALWS\AutoPN
     */
    public function setTribunalID($tribunalID = null)
    {
        $this->TribunalID = $tribunalID;
        return $this;
    }
}
