<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Tribunal ServiceType
 * @subpackage Services
 */
class Tribunal extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Tribunal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TRIBUNALWS\Tribunal $parameters
     * @return \TRIBUNALWS\TribunalResponse|bool
     */
    public function Tribunal(\TRIBUNALWS\Tribunal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Tribunal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TRIBUNALWS\TribunalResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
