<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for BIV ServiceType
 * @subpackage Services
 */
class BIV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named BIVitimas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TRIBUNALWS\BIVitimas $parameters
     * @return \TRIBUNALWS\BIVitimasResponse|bool
     */
    public function BIVitimas(\TRIBUNALWS\BIVitimas $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->BIVitimas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TRIBUNALWS\BIVitimasResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
