<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for BID ServiceType
 * @subpackage Services
 */
class BID extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named BIDenunciantes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TRIBUNALWS\BIDenunciantes $parameters
     * @return \TRIBUNALWS\BIDenunciantesResponse|bool
     */
    public function BIDenunciantes(\TRIBUNALWS\BIDenunciantes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->BIDenunciantes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named BIDenunciados
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TRIBUNALWS\BIDenunciados $parameters
     * @return \TRIBUNALWS\BIDenunciadosResponse|bool
     */
    public function BIDenunciados(\TRIBUNALWS\BIDenunciados $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->BIDenunciados($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TRIBUNALWS\BIDenunciadosResponse|\TRIBUNALWS\BIDenunciantesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
