<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Login StructType
 * @subpackage Structs
 */
class Login extends AbstractStructBase
{
    /**
     * The delisId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $delisId;
    /**
     * The customerUid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $customerUid;
    /**
     * The authToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $authToken;
    /**
     * The depot
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $depot;
    /**
     * The authTokenExpires
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $authTokenExpires;
    /**
     * Constructor method for Login
     * @uses Login::setDelisId()
     * @uses Login::setCustomerUid()
     * @uses Login::setAuthToken()
     * @uses Login::setDepot()
     * @uses Login::setAuthTokenExpires()
     * @param string $delisId
     * @param string $customerUid
     * @param string $authToken
     * @param string $depot
     * @param string $authTokenExpires
     */
    public function __construct($delisId = null, $customerUid = null, $authToken = null, $depot = null, $authTokenExpires = null)
    {
        $this
            ->setDelisId($delisId)
            ->setCustomerUid($customerUid)
            ->setAuthToken($authToken)
            ->setDepot($depot)
            ->setAuthTokenExpires($authTokenExpires);
    }
    /**
     * Get delisId value
     * @return string
     */
    public function getDelisId()
    {
        return $this->delisId;
    }
    /**
     * Set delisId value
     * @param string $delisId
     * @return \StructType\Login
     */
    public function setDelisId($delisId = null)
    {
        // validation for constraint: string
        if (!is_null($delisId) && !is_string($delisId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($delisId, true), gettype($delisId)), __LINE__);
        }
        $this->delisId = $delisId;
        return $this;
    }
    /**
     * Get customerUid value
     * @return string
     */
    public function getCustomerUid()
    {
        return $this->customerUid;
    }
    /**
     * Set customerUid value
     * @param string $customerUid
     * @return \StructType\Login
     */
    public function setCustomerUid($customerUid = null)
    {
        // validation for constraint: string
        if (!is_null($customerUid) && !is_string($customerUid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerUid, true), gettype($customerUid)), __LINE__);
        }
        $this->customerUid = $customerUid;
        return $this;
    }
    /**
     * Get authToken value
     * @return string
     */
    public function getAuthToken()
    {
        return $this->authToken;
    }
    /**
     * Set authToken value
     * @param string $authToken
     * @return \StructType\Login
     */
    public function setAuthToken($authToken = null)
    {
        // validation for constraint: string
        if (!is_null($authToken) && !is_string($authToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authToken, true), gettype($authToken)), __LINE__);
        }
        $this->authToken = $authToken;
        return $this;
    }
    /**
     * Get depot value
     * @return string
     */
    public function getDepot()
    {
        return $this->depot;
    }
    /**
     * Set depot value
     * @param string $depot
     * @return \StructType\Login
     */
    public function setDepot($depot = null)
    {
        // validation for constraint: string
        if (!is_null($depot) && !is_string($depot)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depot, true), gettype($depot)), __LINE__);
        }
        $this->depot = $depot;
        return $this;
    }
    /**
     * Get authTokenExpires value
     * @return string
     */
    public function getAuthTokenExpires()
    {
        return $this->authTokenExpires;
    }
    /**
     * Set authTokenExpires value
     * @param string $authTokenExpires
     * @return \StructType\Login
     */
    public function setAuthTokenExpires($authTokenExpires = null)
    {
        // validation for constraint: string
        if (!is_null($authTokenExpires) && !is_string($authTokenExpires)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authTokenExpires, true), gettype($authTokenExpires)), __LINE__);
        }
        $this->authTokenExpires = $authTokenExpires;
        return $this;
    }
}
