<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Say ServiceType
 * @subpackage Services
 */
class Say extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SayHello
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SayHello $parameters
     * @return \StructType\SayHelloResponse|bool
     */
    public function SayHello(\StructType\SayHello $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SayHello($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SayHelloResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
