<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \MoniBounce\ClassMap::get(),
);
/**
 * Samples for Match ServiceType
 */
$match = new \MoniBounce\ServiceType\Match($options);
/**
 * Sample call for Match operation/method
 */
if ($match->Match(new \MoniBounce\StructType\Match()) !== false) {
    print_r($match->getResult());
} else {
    print_r($match->getLastError());
}
/**
 * Samples for Batch ServiceType
 */
$batch = new \MoniBounce\ServiceType\Batch($options);
/**
 * Sample call for BatchMatch operation/method
 */
if ($batch->BatchMatch(new \MoniBounce\StructType\BatchMatch()) !== false) {
    print_r($batch->getResult());
} else {
    print_r($batch->getLastError());
}
/**
 * Samples for Save ServiceType
 */
$save = new \MoniBounce\ServiceType\Save($options);
/**
 * Sample call for SaveMatchComment operation/method
 */
if ($save->SaveMatchComment(new \MoniBounce\StructType\SaveMatchComment()) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Sample call for SaveMatchResponse operation/method
 */
if ($save->SaveMatchResponse(new \MoniBounce\StructType\SaveMatchResponse()) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \MoniBounce\ServiceType\Get($options);
/**
 * Sample call for GetMatchComments operation/method
 */
if ($get->GetMatchComments(new \MoniBounce\StructType\GetMatchComments()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
